/*
 * Decompiled with CFR 0.152.
 */
package org.stone.tools;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stone.tools.exception.BeanException;
import org.stone.tools.exception.PropertyValueConvertException;
import org.stone.tools.exception.PropertyValueSetFailedException;

public class BeanUtil {
    public static final String Separator_MiddleLine = "-";
    public static final String Separator_UnderLine = "_";
    public static final Logger CommonLog = LoggerFactory.getLogger(BeanUtil.class);

    public static void setAccessible(final Field field) {
        if (!field.isAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction<Field>(){

                @Override
                public Field run() {
                    field.setAccessible(true);
                    return field;
                }
            });
        }
    }

    public static void setAccessible(final Method method) {
        if (!method.isAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    method.setAccessible(true);
                    return method;
                }
            });
        }
    }

    public static Map<String, Method> getClassSetMethodMap(Class<?> beanClass) {
        Method[] methods = beanClass.getMethods();
        LinkedHashMap<String, Method> methodMap = new LinkedHashMap<String, Method>(methods.length);
        for (Method method : methods) {
            String methodName = method.getName();
            if (method.getParameterTypes().length != 1 || !methodName.startsWith("set") || methodName.length() <= 3) continue;
            String propertyName = methodName.substring(3);
            propertyName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
            methodMap.put(propertyName, method);
        }
        return methodMap;
    }

    public static String getPropertyValue(Map<String, String> valueMap, String propertyName) {
        String value = valueMap.get(propertyName);
        if (value != null) {
            return value;
        }
        value = valueMap.get(BeanUtil.propertyNameToFieldId(propertyName, Separator_MiddleLine));
        if (value != null) {
            return value;
        }
        value = valueMap.get(BeanUtil.propertyNameToFieldId(propertyName, Separator_UnderLine));
        if (value != null) {
            return value;
        }
        String firstChar = propertyName.substring(0, 1);
        if (Character.isLowerCase(firstChar.charAt(0))) {
            return valueMap.get(firstChar.toUpperCase() + propertyName.substring(1));
        }
        return null;
    }

    private static Object getFieldValue(Map<String, ?> valueMap, String propertyName) {
        Object value = valueMap.get(propertyName);
        if (value != null) {
            return value;
        }
        value = valueMap.get(BeanUtil.propertyNameToFieldId(propertyName, Separator_MiddleLine));
        if (value != null) {
            return value;
        }
        value = valueMap.get(BeanUtil.propertyNameToFieldId(propertyName, Separator_UnderLine));
        if (value != null) {
            return value;
        }
        String firstChar = propertyName.substring(0, 1);
        if (Character.isLowerCase(firstChar.charAt(0))) {
            return valueMap.get(firstChar.toUpperCase() + propertyName.substring(1));
        }
        return null;
    }

    public static String propertyNameToFieldId(String propertyName, String separator) {
        char[] chars = propertyName.toCharArray();
        StringBuilder sb = new StringBuilder(chars.length);
        for (char c : chars) {
            if (Character.isUpperCase(c)) {
                sb.append(separator).append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void setPropertiesValue(Object bean, Map<String, ?> valueMap) throws BeanException {
        if (bean == null) {
            throw new BeanException("Bean can't be null");
        }
        BeanUtil.setPropertiesValue(bean, BeanUtil.getClassSetMethodMap(bean.getClass()), valueMap);
    }

    public static void setPropertiesValue(Object bean, Map<String, Method> setMethodMap, Map<String, ?> valueMap) throws BeanException {
        if (bean == null) {
            throw new BeanException("Bean can't be null");
        }
        if (setMethodMap == null || setMethodMap.isEmpty() || valueMap == null || valueMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Method> entry : setMethodMap.entrySet()) {
            String propertyName = entry.getKey();
            Method setMethod = entry.getValue();
            Object setValue = BeanUtil.getFieldValue(valueMap, propertyName);
            if (setValue == null) continue;
            Class<?> type = setMethod.getParameterTypes()[0];
            try {
                setValue = BeanUtil.convert(setValue, type);
            }
            catch (Throwable e) {
                throw new PropertyValueConvertException("Failed to convert value[" + setValue + "]to property type(" + propertyName + ":" + type + ")", e);
            }
            try {
                setMethod.invoke(bean, setValue);
            }
            catch (IllegalAccessException e) {
                throw new PropertyValueSetFailedException("Failed to set value on property[" + propertyName + "],message:" + e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause == null) {
                    throw new PropertyValueSetFailedException("Failed to set value on property[" + propertyName + "],message:" + e.getMessage(), e);
                }
                throw new PropertyValueSetFailedException("Failed to set value on property[" + propertyName + "],message:" + cause.getMessage(), cause);
            }
        }
    }

    public static Object createClassInstance(Class<?> beanClass, Class<?> parentClass, String objectClassType) throws BeanException {
        Class[] classArray;
        if (parentClass != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = parentClass;
        } else {
            classArray = null;
        }
        return BeanUtil.createClassInstance(beanClass, classArray, objectClassType);
    }

    public static Object createClassInstance(Class<?> beanClass, Class<?>[] parentClasses, String beanClassType) throws BeanException {
        if (beanClass == null) {
            throw new BeanException("Bean class can't be null");
        }
        int modifiers = beanClass.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            throw new BeanException("Bean class can't be abstract");
        }
        if (!Modifier.isPublic(modifiers)) {
            throw new BeanException("Not defined public constructor in bean class");
        }
        if (parentClasses != null && parentClasses.length > 0) {
            int parentClassCount = 0;
            boolean isSubClass = false;
            for (Class<?> parentClass : parentClasses) {
                if (parentClass == null) continue;
                ++parentClassCount;
                if (!parentClass.isAssignableFrom(beanClass)) continue;
                isSubClass = true;
                break;
            }
            if (parentClassCount > 0 && !isSubClass) {
                throw new BeanException("Can\u2018t create instance on class[" + beanClass.getName() + "]which must extend from one of type[" + BeanUtil.getClassName(parentClasses) + "]at least,creation category[" + beanClassType + "]");
            }
        }
        try {
            return beanClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new BeanException("Failed to create instance on class[" + beanClass + "]", e);
        }
    }

    private static String getClassName(Class<?>[] classes) {
        StringBuilder buf = new StringBuilder(classes.length * 10);
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(clazz.getName());
        }
        return buf.toString();
    }

    private static Object convert(Object propValue, Class<?> type) throws Exception {
        if (type.isInstance(propValue)) {
            return propValue;
        }
        if (type == String.class) {
            return propValue.toString();
        }
        String text = propValue.toString();
        if ((text = text.trim()).isEmpty()) {
            return null;
        }
        if (type == Character.TYPE || type == Character.class) {
            return Character.valueOf(text.toCharArray()[0]);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.parseBoolean(text);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return Byte.parseByte(text);
        }
        if (type == Short.TYPE || type == Short.class) {
            return Short.parseShort(text);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(text);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.parseLong(text);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(Float.parseFloat(text));
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.parseDouble(text);
        }
        if (type == BigInteger.class) {
            return new BigInteger(text);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(text);
        }
        if (type == Class.class) {
            return Class.forName(text);
        }
        if (type.isArray()) {
            return null;
        }
        Object objInstance = Class.forName(text).newInstance();
        if (type.isInstance(objInstance)) {
            return objInstance;
        }
        throw new ClassCastException();
    }
}

