/*
 * Decompiled with CFR 0.152.
 */
package org.stone.tools.atomic;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.stone.tools.UnsafeHolder;
import org.stone.tools.exception.ReflectionOperationException;
import sun.misc.Unsafe;

public final class IntegerFieldUpdaterImpl<T>
extends AtomicIntegerFieldUpdater<T> {
    private static final Unsafe UA = UnsafeHolder.getUnsafe();
    private final long offset;

    private IntegerFieldUpdaterImpl(long offset) {
        this.offset = offset;
    }

    public static <T> AtomicIntegerFieldUpdater<T> newUpdater(Class<T> beanClass, String fieldName) {
        try {
            return new IntegerFieldUpdaterImpl<T>(UA.objectFieldOffset(beanClass.getDeclaredField(fieldName)));
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionOperationException(e);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            return AtomicIntegerFieldUpdater.newUpdater(beanClass, fieldName);
        }
    }

    @Override
    public boolean compareAndSet(T bean, int expect, int update) {
        return UA.compareAndSwapInt(bean, this.offset, expect, update);
    }

    @Override
    public boolean weakCompareAndSet(T bean, int expect, int update) {
        return UA.compareAndSwapInt(bean, this.offset, expect, update);
    }

    @Override
    public void set(T bean, int newValue) {
        UA.putIntVolatile(bean, this.offset, newValue);
    }

    @Override
    public void lazySet(T bean, int newValue) {
        UA.putOrderedInt(bean, this.offset, newValue);
    }

    @Override
    public int get(T bean) {
        return UA.getIntVolatile(bean, this.offset);
    }
}

