/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.photoview;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.FloatMath;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;

public abstract class VersionedGestureDetector {
    static final String LOG_TAG = "VersionedGestureDetector";
    OnGestureListener mListener;

    public static VersionedGestureDetector newInstance(Context context, OnGestureListener listener) {
        int sdkVersion = Build.VERSION.SDK_INT;
        CupcakeDetector detector = null;
        detector = sdkVersion < 5 ? new CupcakeDetector(context) : (sdkVersion < 8 ? new EclairDetector(context) : new FroyoDetector(context));
        detector.mListener = listener;
        return detector;
    }

    public abstract boolean onTouchEvent(MotionEvent var1);

    public abstract boolean isScaling();

    @TargetApi(value=8)
    private static class FroyoDetector
    extends EclairDetector {
        private final ScaleGestureDetector mDetector;
        private final ScaleGestureDetector.OnScaleGestureListener mScaleListener = new ScaleGestureDetector.OnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector detector) {
                FroyoDetector.this.mListener.onScale(detector.getScaleFactor(), detector.getFocusX(), detector.getFocusY());
                return true;
            }

            public boolean onScaleBegin(ScaleGestureDetector detector) {
                return true;
            }

            public void onScaleEnd(ScaleGestureDetector detector) {
            }
        };

        public FroyoDetector(Context context) {
            super(context);
            this.mDetector = new ScaleGestureDetector(context, this.mScaleListener);
        }

        public boolean isScaling() {
            return this.mDetector.isInProgress();
        }

        public boolean onTouchEvent(MotionEvent ev) {
            this.mDetector.onTouchEvent(ev);
            return super.onTouchEvent(ev);
        }
    }

    @TargetApi(value=5)
    private static class EclairDetector
    extends CupcakeDetector {
        private static final int INVALID_POINTER_ID = -1;
        private int mActivePointerId = -1;
        private int mActivePointerIndex = 0;

        public EclairDetector(Context context) {
            super(context);
        }

        float getActiveX(MotionEvent ev) {
            try {
                return ev.getX(this.mActivePointerIndex);
            }
            catch (Exception e) {
                return ev.getX();
            }
        }

        float getActiveY(MotionEvent ev) {
            try {
                return ev.getY(this.mActivePointerIndex);
            }
            catch (Exception e) {
                return ev.getY();
            }
        }

        public boolean onTouchEvent(MotionEvent ev) {
            int action = ev.getAction();
            switch (action & 0xFF) {
                case 0: {
                    this.mActivePointerId = ev.getPointerId(0);
                    break;
                }
                case 1: 
                case 3: {
                    this.mActivePointerId = -1;
                    break;
                }
                case 6: {
                    int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
                    int pointerId = ev.getPointerId(pointerIndex);
                    if (pointerId != this.mActivePointerId) break;
                    int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                    this.mActivePointerId = ev.getPointerId(newPointerIndex);
                    this.mLastTouchX = ev.getX(newPointerIndex);
                    this.mLastTouchY = ev.getY(newPointerIndex);
                }
            }
            this.mActivePointerIndex = ev.findPointerIndex(this.mActivePointerId != -1 ? this.mActivePointerId : 0);
            return super.onTouchEvent(ev);
        }
    }

    private static class CupcakeDetector
    extends VersionedGestureDetector {
        float mLastTouchX;
        float mLastTouchY;
        final float mTouchSlop;
        final float mMinimumVelocity;
        private VelocityTracker mVelocityTracker;
        private boolean mIsDragging;

        public CupcakeDetector(Context context) {
            ViewConfiguration configuration = ViewConfiguration.get((Context)context);
            this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
            this.mTouchSlop = configuration.getScaledTouchSlop();
        }

        float getActiveX(MotionEvent ev) {
            return ev.getX();
        }

        float getActiveY(MotionEvent ev) {
            return ev.getY();
        }

        public boolean isScaling() {
            return false;
        }

        public boolean onTouchEvent(MotionEvent ev) {
            switch (ev.getAction()) {
                case 0: {
                    this.mVelocityTracker = VelocityTracker.obtain();
                    this.mVelocityTracker.addMovement(ev);
                    this.mLastTouchX = this.getActiveX(ev);
                    this.mLastTouchY = this.getActiveY(ev);
                    this.mIsDragging = false;
                    break;
                }
                case 2: {
                    float x = this.getActiveX(ev);
                    float y = this.getActiveY(ev);
                    float dx = x - this.mLastTouchX;
                    float dy = y - this.mLastTouchY;
                    if (!this.mIsDragging) {
                        boolean bl = this.mIsDragging = FloatMath.sqrt((float)(dx * dx + dy * dy)) >= this.mTouchSlop;
                    }
                    if (!this.mIsDragging) break;
                    this.mListener.onDrag(dx, dy);
                    this.mLastTouchX = x;
                    this.mLastTouchY = y;
                    if (null == this.mVelocityTracker) break;
                    this.mVelocityTracker.addMovement(ev);
                    break;
                }
                case 3: {
                    if (null == this.mVelocityTracker) break;
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                    break;
                }
                case 1: {
                    if (this.mIsDragging && null != this.mVelocityTracker) {
                        this.mLastTouchX = this.getActiveX(ev);
                        this.mLastTouchY = this.getActiveY(ev);
                        this.mVelocityTracker.addMovement(ev);
                        this.mVelocityTracker.computeCurrentVelocity(1000);
                        float vX = this.mVelocityTracker.getXVelocity();
                        float vY = this.mVelocityTracker.getYVelocity();
                        if (Math.max(Math.abs(vX), Math.abs(vY)) >= this.mMinimumVelocity) {
                            this.mListener.onFling(this.mLastTouchX, this.mLastTouchY, -vX, -vY);
                        }
                    }
                    if (null == this.mVelocityTracker) break;
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
            }
            return true;
        }
    }

    public static interface OnGestureListener {
        public void onDrag(float var1, float var2);

        public void onFling(float var1, float var2, float var3, float var4);

        public void onScale(float var1, float var2, float var3);
    }
}

