/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.photoview;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import uk.co.senab.photoview.Compat;
import uk.co.senab.photoview.PhotoView;
import uk.co.senab.photoview.ScrollerProxy;
import uk.co.senab.photoview.VersionedGestureDetector;

public class PhotoViewAttacher
implements View.OnTouchListener,
VersionedGestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener,
ViewTreeObserver.OnGlobalLayoutListener {
    static final boolean DEBUG = false;
    static final String LOG_TAG = "PhotoViewAttacher";
    static final int EDGE_NONE = -1;
    static final int EDGE_LEFT = 0;
    static final int EDGE_RIGHT = 1;
    static final int EDGE_BOTH = 2;
    private static final float MAX_ZOOM = 3.0f;
    private static final float MID_ZOOM = 1.75f;
    private static final float MIN_ZOOM = 1.0f;
    private GestureDetector mGestureDetector;
    private VersionedGestureDetector mScaleDragDetector;
    private final Matrix mBaseMatrix = new Matrix();
    private final Matrix mDrawMatrix = new Matrix();
    private final Matrix mSuppMatrix = new Matrix();
    private final RectF mDisplayRect = new RectF();
    private OnMatrixChangedListener mMatrixChangeListener;
    private OnPhotoTapListener mPhotoTapListener;
    private final float[] mMatrixValues = new float[9];
    private int mScrollEdge = 2;
    private boolean mZoomEnabled;
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;
    private FlingRunnable mCurrentFlingRunnable;
    private final ImageView mImageView;
    private int mIvTop;
    private int mIvRight;
    private int mIvBottom;
    private int mIvLeft;

    private static boolean isSupportedScaleType(ImageView.ScaleType scaleType) {
        if (null == scaleType) {
            return false;
        }
        switch (scaleType) {
            case MATRIX: {
                throw new IllegalArgumentException(scaleType.name() + " is not supported in PhotoView");
            }
        }
        return true;
    }

    public PhotoViewAttacher(ImageView imageView) {
        this.mImageView = imageView;
        this.mImageView.setOnTouchListener((View.OnTouchListener)this);
        this.mImageView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        if (!imageView.isInEditMode()) {
            this.mScaleDragDetector = VersionedGestureDetector.newInstance(this.mImageView.getContext(), this);
            this.mGestureDetector = new GestureDetector(this.mImageView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener());
            this.mGestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)this);
        }
        this.setImageViewScaleTypeMatrix();
        if (!imageView.isInEditMode()) {
            this.setZoomable(true);
        }
    }

    public final boolean canZoom() {
        return this.mZoomEnabled;
    }

    public final RectF getDisplayRect() {
        this.checkMatrixBounds();
        return this.getDisplayRect(this.getDisplayMatrix());
    }

    public final float getScale() {
        return this.getValue(this.mSuppMatrix, 0);
    }

    public final ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public final boolean onDoubleTap(MotionEvent ev) {
        try {
            float scale = this.getScale();
            float x = ev.getX();
            float y = ev.getY();
            if (scale < 1.75f) {
                this.zoomTo(1.75f, x, y);
            } else if (scale >= 1.75f && scale < 3.0f) {
                this.zoomTo(3.0f, x, y);
            } else {
                this.zoomTo(1.0f, x, y);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return true;
    }

    public final boolean onDoubleTapEvent(MotionEvent e) {
        return false;
    }

    public final void onDrag(float dx, float dy) {
        if (this.hasDrawable()) {
            this.mSuppMatrix.postTranslate(dx, dy);
            this.checkAndDisplayMatrix();
            if (!this.mScaleDragDetector.isScaling() && (this.mScrollEdge == 2 || this.mScrollEdge == 0 && dx >= 1.0f || this.mScrollEdge == 1 && dx <= -1.0f)) {
                this.mImageView.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
    }

    public final void onFling(float startX, float startY, float velocityX, float velocityY) {
        if (this.hasDrawable()) {
            this.mCurrentFlingRunnable = new FlingRunnable();
            this.mCurrentFlingRunnable.fling((int)velocityX, (int)velocityY);
            this.mImageView.post((Runnable)this.mCurrentFlingRunnable);
        }
    }

    public final void onGlobalLayout() {
        if (this.mZoomEnabled) {
            int top = this.mImageView.getTop();
            int right = this.mImageView.getRight();
            int bottom = this.mImageView.getBottom();
            int left = this.mImageView.getLeft();
            if (top != this.mIvTop || bottom != this.mIvBottom || left != this.mIvLeft || right != this.mIvRight) {
                this.updateBaseMatrix(this.mImageView.getDrawable());
                this.mIvTop = top;
                this.mIvRight = right;
                this.mIvBottom = bottom;
                this.mIvLeft = left;
            }
        }
    }

    public final void onScale(float scaleFactor, float focusX, float focusY) {
        if (this.hasDrawable() && (this.getScale() < 3.0f || scaleFactor < 1.0f)) {
            this.mSuppMatrix.postScale(scaleFactor, scaleFactor, focusX, focusY);
            this.checkAndDisplayMatrix();
        }
    }

    public final boolean onSingleTapConfirmed(MotionEvent e) {
        float y;
        float x;
        RectF displayRect;
        if (null != this.mPhotoTapListener && null != (displayRect = this.getDisplayRect()) && displayRect.contains(x = e.getX(), y = e.getY())) {
            float xResult = (x - displayRect.left) / displayRect.width();
            float yResult = (y - displayRect.top) / displayRect.height();
            this.mPhotoTapListener.onPhotoTap((View)this.mImageView, xResult, yResult);
            return true;
        }
        return false;
    }

    public final boolean onTouch(View v, MotionEvent ev) {
        if (this.mZoomEnabled) {
            switch (ev.getAction()) {
                case 0: {
                    v.getParent().requestDisallowInterceptTouchEvent(true);
                    this.cancelFling();
                    break;
                }
                case 1: 
                case 3: {
                    if (!(this.getScale() < 1.0f)) break;
                    RectF rect = this.getDisplayRect();
                    if (null != rect) {
                        v.post((Runnable)new AnimatedZoomRunnable(this.getScale(), 1.0f, rect.centerX(), rect.centerY()));
                    }
                    return true;
                }
            }
            if (null != this.mGestureDetector && this.mGestureDetector.onTouchEvent(ev)) {
                return true;
            }
            if (null != this.mScaleDragDetector && this.mScaleDragDetector.onTouchEvent(ev)) {
                return true;
            }
        }
        return false;
    }

    public final void setScaleType(ImageView.ScaleType scaleType) {
        if (PhotoViewAttacher.isSupportedScaleType(scaleType) && scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.update();
        }
    }

    public final void setOnMatrixChangeListener(OnMatrixChangedListener listener) {
        this.mMatrixChangeListener = listener;
    }

    public final void setOnPhotoTapListener(OnPhotoTapListener listener) {
        this.mPhotoTapListener = listener;
    }

    public final void setZoomable(boolean zoomable) {
        this.mZoomEnabled = zoomable;
        this.update();
    }

    public final void update() {
        if (this.mZoomEnabled) {
            this.setImageViewScaleTypeMatrix();
            this.updateBaseMatrix(this.mImageView.getDrawable());
        } else {
            this.resetMatrix();
        }
    }

    public final void zoomTo(float scale, float focalX, float focalY) {
        this.mImageView.post((Runnable)new AnimatedZoomRunnable(this.getScale(), scale, focalX, focalY));
    }

    protected Matrix getDisplayMatrix() {
        this.mDrawMatrix.set(this.mBaseMatrix);
        this.mDrawMatrix.postConcat(this.mSuppMatrix);
        return this.mDrawMatrix;
    }

    private void cancelFling() {
        if (null != this.mCurrentFlingRunnable) {
            this.mCurrentFlingRunnable.cancelFling();
            this.mCurrentFlingRunnable = null;
        }
    }

    private void checkAndDisplayMatrix() {
        this.checkMatrixBounds();
        this.setImageViewMatrix(this.getDisplayMatrix());
    }

    private void checkImageViewScaleType() {
        if (!(this.mImageView instanceof PhotoView) && this.mImageView.getScaleType() != ImageView.ScaleType.MATRIX) {
            throw new IllegalStateException("The ImageView's ScaleType has been changed since attaching a PhotoViewAttacher");
        }
    }

    private void checkMatrixBounds() {
        RectF rect = this.getDisplayRect(this.getDisplayMatrix());
        if (null == rect) {
            return;
        }
        float height = rect.height();
        float width = rect.width();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        int viewHeight = this.mImageView.getHeight();
        if (height <= (float)viewHeight) {
            switch (this.mScaleType) {
                case FIT_START: {
                    deltaY = -rect.top;
                    break;
                }
                case FIT_END: {
                    deltaY = (float)viewHeight - height - rect.top;
                    break;
                }
                default: {
                    deltaY = ((float)viewHeight - height) / 2.0f - rect.top;
                    break;
                }
            }
        } else if (rect.top > 0.0f) {
            deltaY = -rect.top;
        } else if (rect.bottom < (float)viewHeight) {
            deltaY = (float)viewHeight - rect.bottom;
        }
        int viewWidth = this.mImageView.getWidth();
        if (width <= (float)viewWidth) {
            switch (this.mScaleType) {
                case FIT_START: {
                    deltaX = -rect.left;
                    break;
                }
                case FIT_END: {
                    deltaX = (float)viewWidth - width - rect.left;
                    break;
                }
                default: {
                    deltaX = ((float)viewWidth - width) / 2.0f - rect.left;
                }
            }
            this.mScrollEdge = 2;
        } else if (rect.left > 0.0f) {
            this.mScrollEdge = 0;
            deltaX = -rect.left;
        } else if (rect.right < (float)viewWidth) {
            deltaX = (float)viewWidth - rect.right;
            this.mScrollEdge = 1;
        } else {
            this.mScrollEdge = -1;
        }
        this.mSuppMatrix.postTranslate(deltaX, deltaY);
    }

    private RectF getDisplayRect(Matrix matrix) {
        Drawable d = this.mImageView.getDrawable();
        if (null != d) {
            this.mDisplayRect.set(0.0f, 0.0f, (float)d.getIntrinsicWidth(), (float)d.getIntrinsicHeight());
            matrix.mapRect(this.mDisplayRect);
            return this.mDisplayRect;
        }
        return null;
    }

    private float getValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[whichValue];
    }

    private boolean hasDrawable() {
        return null != this.mImageView.getDrawable();
    }

    private void resetMatrix() {
        this.mSuppMatrix.reset();
        this.setImageViewMatrix(this.getDisplayMatrix());
        this.checkMatrixBounds();
    }

    private void setImageViewScaleTypeMatrix() {
        if (!(this.mImageView instanceof PhotoView)) {
            this.mImageView.setScaleType(ImageView.ScaleType.MATRIX);
        }
    }

    private void setImageViewMatrix(Matrix matrix) {
        RectF displayRect;
        this.checkImageViewScaleType();
        this.mImageView.setImageMatrix(matrix);
        if (null != this.mMatrixChangeListener && null != (displayRect = this.getDisplayRect(matrix))) {
            this.mMatrixChangeListener.onMatrixChanged(displayRect);
        }
    }

    private void updateBaseMatrix(Drawable d) {
        if (null == d) {
            return;
        }
        float viewWidth = this.mImageView.getWidth();
        float viewHeight = this.mImageView.getHeight();
        int drawableWidth = d.getIntrinsicWidth();
        int drawableHeight = d.getIntrinsicHeight();
        this.mBaseMatrix.reset();
        float widthScale = viewWidth / (float)drawableWidth;
        float heightScale = viewHeight / (float)drawableHeight;
        if (this.mScaleType == ImageView.ScaleType.CENTER) {
            this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth) / 2.0f, (viewHeight - (float)drawableHeight) / 2.0f);
        } else if (this.mScaleType == ImageView.ScaleType.CENTER_CROP) {
            float scale = Math.max(widthScale, heightScale);
            this.mBaseMatrix.postScale(scale, scale);
            this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
        } else if (this.mScaleType == ImageView.ScaleType.CENTER_INSIDE) {
            float scale = Math.min(1.0f, Math.min(widthScale, heightScale));
            this.mBaseMatrix.postScale(scale, scale);
            this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
        } else {
            RectF mTempSrc = new RectF(0.0f, 0.0f, (float)drawableWidth, (float)drawableHeight);
            RectF mTempDst = new RectF(0.0f, 0.0f, viewWidth, viewHeight);
            switch (this.mScaleType) {
                case FIT_CENTER: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.CENTER);
                    break;
                }
                case FIT_START: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.START);
                    break;
                }
                case FIT_END: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.END);
                    break;
                }
                case FIT_XY: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.FILL);
                }
            }
        }
        this.resetMatrix();
    }

    private class AnimatedZoomRunnable
    implements Runnable {
        static final float ANIMATION_SCALE_PER_ITERATION_IN = 1.07f;
        static final float ANIMATION_SCALE_PER_ITERATION_OUT = 0.93f;
        private final float mFocalX;
        private final float mFocalY;
        private final float mTargetZoom;
        private final float mDeltaScale;

        public AnimatedZoomRunnable(float currentZoom, float targetZoom, float focalX, float focalY) {
            this.mTargetZoom = targetZoom;
            this.mFocalX = focalX;
            this.mFocalY = focalY;
            this.mDeltaScale = currentZoom < targetZoom ? 1.07f : 0.93f;
        }

        public void run() {
            PhotoViewAttacher.this.mSuppMatrix.postScale(this.mDeltaScale, this.mDeltaScale, this.mFocalX, this.mFocalY);
            PhotoViewAttacher.this.checkAndDisplayMatrix();
            float currentScale = PhotoViewAttacher.this.getScale();
            if (this.mDeltaScale > 1.0f && currentScale < this.mTargetZoom || this.mDeltaScale < 1.0f && this.mTargetZoom < currentScale) {
                Compat.postOnAnimation((View)PhotoViewAttacher.this.mImageView, this);
            } else {
                float delta = this.mTargetZoom / currentScale;
                PhotoViewAttacher.this.mSuppMatrix.postScale(delta, delta, this.mFocalX, this.mFocalY);
                PhotoViewAttacher.this.checkAndDisplayMatrix();
            }
        }
    }

    private class FlingRunnable
    implements Runnable {
        private final ScrollerProxy mScroller;
        private int mCurrentX;
        private int mCurrentY;

        public FlingRunnable() {
            Context context = PhotoViewAttacher.this.mImageView.getContext();
            this.mScroller = ScrollerProxy.getScroller(context);
        }

        public void fling(int velocityX, int velocityY) {
            int maxY;
            int minY;
            int maxX;
            int minX;
            RectF rect = PhotoViewAttacher.this.getDisplayRect();
            if (null == rect) {
                return;
            }
            int viewHeight = PhotoViewAttacher.this.mImageView.getHeight();
            int viewWidth = PhotoViewAttacher.this.mImageView.getWidth();
            int startX = Math.round(-rect.left);
            if ((float)viewWidth < rect.width()) {
                minX = 0;
                maxX = Math.round(rect.width() - (float)viewWidth);
            } else {
                minX = maxX = startX;
            }
            int startY = Math.round(-rect.top);
            if ((float)viewHeight < rect.height()) {
                minY = 0;
                maxY = Math.round(rect.height() - (float)viewHeight);
            } else {
                minY = maxY = startY;
            }
            this.mCurrentX = startX;
            this.mCurrentY = startY;
            if (startX != maxX || startY != maxY) {
                this.mScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY, 0, 0);
            }
        }

        public void run() {
            if (this.mScroller.computeScrollOffset()) {
                int newX = this.mScroller.getCurrX();
                int newY = this.mScroller.getCurrY();
                PhotoViewAttacher.this.mSuppMatrix.postTranslate((float)(this.mCurrentX - newX), (float)(this.mCurrentY - newY));
                PhotoViewAttacher.this.setImageViewMatrix(PhotoViewAttacher.this.getDisplayMatrix());
                this.mCurrentX = newX;
                this.mCurrentY = newY;
                Compat.postOnAnimation((View)PhotoViewAttacher.this.mImageView, this);
            }
        }

        public void cancelFling() {
            this.mScroller.forceFinished(true);
        }
    }

    public static interface OnPhotoTapListener {
        public void onPhotoTap(View var1, float var2, float var3);
    }

    public static interface OnMatrixChangedListener {
        public void onMatrixChanged(RectF var1);
    }
}

