/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisdchristo.capsule;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultMavenProjectHelper;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class CapsuleMojo
extends AbstractMojo {
    private String LOG_PREFIX = "[CapsuleMavenPlugin] ";
    private static final String DEFAULT_CAPSULE_VERSION = "1.0.3";
    private static final String DEFAULT_CAPSULE_MAVEN_VERSION = "1.0.3";
    private static final String CAPSULE_GROUP = "co.paralleluniverse";
    private static final String DEFAULT_CAPSULE_NAME = "Capsule";
    private static final String DEFAULT_CAPSULE_CLASS = "Capsule.class";
    private static final String DEFAULT_CAPSULE_MAVEN_NAME = "MavenCapsule";
    private static final String DEFAULT_CAPSULE_MAVEN_CLASS = "MavenCapsule.class";
    private static final String EXEC_PREFIX = "#!/bin/sh\n\nexec java -jar \"$0\" \"$@\"\n\n";
    private static final String EXEC_TRAMPOLINE_PREFIX = "#!/bin/sh\n\nexec java -Dcapsule.trampoline -jar \"$0\" \"$@\"\n\n";
    private static final String EXEC_PLUGIN_KEY = "org.codehaus.mojo:exec-maven-plugin";
    private final MavenProjectHelper helper = new DefaultMavenProjectHelper();
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project = null;
    @Component
    private RepositorySystem repoSystem = null;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession = null;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos = null;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName = null;
    @Parameter(defaultValue="${project.build.directory}")
    private File buildDir = null;
    @Parameter(defaultValue="${project.basedir}")
    private File baseDir = null;
    @Parameter(property="capsule.outputDir", defaultValue="${project.build.directory}")
    private File outputDir = null;
    @Parameter(property="capsule.version")
    private String capsuleVersion = "1.0.3";
    @Parameter(property="capsule.maven.version")
    private String capsuleMavenVersion = "1.0.3";
    @Parameter(property="capsule.appClass")
    private String appClass = null;
    @Parameter(property="capsule.caplets")
    private String caplets;
    @Parameter(property="capsule.type")
    private Type type = null;
    @Parameter(property="capsule.chmod")
    private boolean chmod = false;
    @Parameter(property="capsule.trampoline")
    private boolean trampoline = false;
    @Parameter(property="capsule.setManifestRepos")
    private boolean setManifestRepos = false;
    @Parameter(property="capsule.includeApp")
    private boolean includeApp = true;
    @Parameter(property="capsule.includeTransitiveDep")
    private boolean includeTransitiveDep = true;
    @Parameter(property="capsule.includeCompileDep")
    private boolean includeCompileDep = true;
    @Parameter(property="capsule.includeRuntimeDep")
    private boolean includeRuntimeDep = true;
    @Parameter(property="capsule.includeProvidedDep")
    private boolean includeProvidedDep = false;
    @Parameter(property="capsule.includeSystemDep")
    private boolean includeSystemDep = false;
    @Parameter(property="capsule.includeTestDep")
    private boolean includeTestDep = false;
    @Parameter(property="capsule.includeOptionalDep")
    private boolean includeOptionalDep = false;
    @Parameter(property="capsule.resolveApp")
    private boolean resolveApp = false;
    @Parameter(property="capsule.resolveTransitiveDep")
    private boolean resolveTransitiveDep = false;
    @Parameter(property="capsule.resolveCompileDep")
    private boolean resolveCompileDep = false;
    @Parameter(property="capsule.resolveRuntimeDep")
    private boolean resolveRuntimeDep = false;
    @Parameter(property="capsule.resolveProvidedDep")
    private boolean resolveProvidedDep = false;
    @Parameter(property="capsule.resolveSystemDep")
    private boolean resolveSystemDep = false;
    @Parameter(property="capsule.resolveTestDep")
    private boolean resolveTestDep = false;
    @Parameter(property="capsule.resolveOptionalDep")
    private boolean resolveOptionalDep = false;
    @Parameter(property="capsule.execPluginConfig")
    private String execPluginConfig = null;
    @Parameter(property="capsule.customDescriptor")
    private String customDescriptor = "-capsule";
    @Parameter
    private Pair<String, String>[] properties = null;
    @Parameter
    private Pair<String, String>[] manifest = null;
    @Parameter
    private Mode[] modes = null;
    @Parameter
    private FileSet[] fileSets = null;
    @Parameter
    private DependencySet[] dependencySets = null;
    private Map<String, File> capletFiles = new HashMap<String, File>();
    private Xpp3Dom execConfig = null;
    private File resolvedCapsuleProjectFile = null;
    private File resolvedCapsuleMavenProjectFile = null;
    private String outputName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean success;
        List<String> illegalOutputPaths;
        Xpp3Dom mainClassElement;
        if (this.type == Type.empty) {
            this.includeApp = false;
            this.includeTransitiveDep = false;
            this.includeCompileDep = false;
            this.includeRuntimeDep = false;
            this.includeProvidedDep = false;
            this.includeSystemDep = false;
            this.includeTestDep = false;
            this.includeOptionalDep = false;
            this.resolveApp = true;
            this.resolveTransitiveDep = true;
            this.resolveCompileDep = true;
            this.resolveRuntimeDep = true;
            this.resolveProvidedDep = false;
            this.resolveSystemDep = false;
            this.resolveTestDep = false;
            this.resolveOptionalDep = false;
        } else if (this.type == Type.thin) {
            this.includeApp = true;
            this.includeTransitiveDep = false;
            this.includeCompileDep = false;
            this.includeRuntimeDep = false;
            this.includeProvidedDep = false;
            this.includeSystemDep = false;
            this.includeTestDep = false;
            this.includeOptionalDep = false;
            this.resolveApp = false;
            this.resolveTransitiveDep = true;
            this.resolveCompileDep = true;
            this.resolveRuntimeDep = true;
            this.resolveProvidedDep = false;
            this.resolveSystemDep = false;
            this.resolveTestDep = false;
            this.resolveOptionalDep = false;
        } else if (this.type == Type.fat) {
            this.includeApp = true;
            this.includeTransitiveDep = true;
            this.includeCompileDep = true;
            this.includeRuntimeDep = true;
            this.includeProvidedDep = false;
            this.includeSystemDep = false;
            this.includeTestDep = false;
            this.includeOptionalDep = false;
            this.resolveApp = false;
            this.resolveTransitiveDep = false;
            this.resolveCompileDep = false;
            this.resolveRuntimeDep = false;
            this.resolveProvidedDep = false;
            this.resolveSystemDep = false;
            this.resolveTestDep = false;
            this.resolveOptionalDep = false;
        }
        if (this.execPluginConfig != null && this.project.getPlugin(EXEC_PLUGIN_KEY) != null) {
            Plugin plugin = this.project.getPlugin(EXEC_PLUGIN_KEY);
            if (this.execPluginConfig.equals("root")) {
                this.execConfig = (Xpp3Dom)plugin.getConfiguration();
            } else {
                List executions = plugin.getExecutions();
                for (PluginExecution execution : executions) {
                    if (!execution.getId().equals(this.execPluginConfig)) continue;
                    this.execConfig = (Xpp3Dom)execution.getConfiguration();
                    break;
                }
            }
        }
        if (this.appClass == null && this.execConfig != null && (mainClassElement = this.execConfig.getChild("mainClass")) != null) {
            this.appClass = mainClassElement.getValue();
        }
        if (this.appClass == null) {
            throw new MojoFailureException(this.LOG_PREFIX + " appClass not set (or could not be obtained from the exec plugin mainClass)");
        }
        this.outputName = this.finalName;
        if (this.customDescriptor != null) {
            this.outputName = this.outputName + this.customDescriptor;
        }
        if (this.caplets == null) {
            this.caplets = "";
        }
        if (!this.caplets.isEmpty()) {
            StringBuilder capletString = new StringBuilder();
            File classesDir = new File(this.buildDir, "classes");
            for (final String caplet : this.caplets.split(" ")) {
                try {
                    Files.walkFileTree(classesDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                            if (!attrs.isDirectory() && path.toString().contains(caplet)) {
                                CapsuleMojo.this.capletFiles.put(caplet, path.toFile());
                                return FileVisitResult.TERMINATE;
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (!this.capletFiles.containsKey(caplet) && !caplet.contains(":")) {
                    this.warn("Could not find caplet " + caplet + " class, skipping.");
                }
                if (capletString.length() > 0) {
                    capletString.append(" ");
                }
                capletString.append(caplet);
            }
            this.caplets = capletString.toString();
        }
        if (this.capsuleVersion == null) {
            DefaultArtifact artifact = new DefaultArtifact(CAPSULE_GROUP, "capsule", null, null, "[0,)");
            VersionRangeRequest request = new VersionRangeRequest().setRepositories(this.remoteRepos).setArtifact((org.eclipse.aether.artifact.Artifact)artifact);
            try {
                VersionRangeResult result = this.repoSystem.resolveVersionRange(this.repoSession, request);
                for (int i = result.getVersions().size() - 1; i >= 0; --i) {
                    String currentVersion = ((Version)result.getVersions().get(i)).toString();
                    if (currentVersion.contains("SNAPSHOT")) continue;
                    this.capsuleVersion = ((Version)result.getVersions().get(i)).toString();
                    break;
                }
            }
            catch (VersionRangeResolutionException e) {
                throw new MojoFailureException(e.getMessage());
            }
        }
        if ((illegalOutputPaths = Arrays.asList(this.buildDir.getPath() + File.separatorChar + "classes", this.buildDir.getPath() + File.separatorChar + "classes/")).contains(this.outputDir.getPath())) {
            this.outputDir = this.buildDir;
            this.debug("Output was an illegal path, resorting to default build directory.");
        }
        if (!this.outputDir.exists() && !(success = this.outputDir.mkdirs())) {
            throw new MojoFailureException("Failed to build outputDir path");
        }
        this.info("[Capsule Version]: " + this.capsuleVersion);
        this.info("[Output Directory]: " + this.outputDir.toString());
        this.info("[Build Info]: " + this.buildInfoString());
        try {
            this.build();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoFailureException(e.getMessage());
        }
    }

    public void build() throws IOException {
        File jarFile = new File(this.outputDir, this.outputName + ".jar");
        if (!jarFile.exists()) {
            JarOutputStream jarStream = new JarOutputStream(new FileOutputStream(jarFile));
            this.info("[Capsule Jar File]: " + jarFile.getName());
            this.addManifest(jarStream);
            this.addCapsuleClass(jarStream);
            this.addCapletClasses(jarStream);
            this.addMavenCapletClasses(jarStream);
            this.addApp(jarStream);
            this.addDependencies(jarStream);
            this.addFileSets(jarStream);
            this.addDependencySets(jarStream);
            IOUtil.close((OutputStream)jarStream);
        } else {
            this.info("EXISTS - " + jarFile.getName() + " (WILL NOT OVERWRITE)");
        }
        this.addChmodCopy(jarFile);
        this.addTrampolineCopy(jarFile);
        this.info("[Maven Artifact]: Attached capsule artifact to maven (" + jarFile.getName() + ").");
        this.helper.attachArtifact(this.project, jarFile, "capsule");
    }

    private void addManifest(JarOutputStream jar) throws IOException {
        Xpp3Dom[] argsElements;
        Object[] argsElement;
        String repoString;
        String dependencyString;
        Manifest manifestBuild = new Manifest();
        Attributes mainAttributes = manifestBuild.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.put(Attributes.Name.MAIN_CLASS, DEFAULT_CAPSULE_NAME);
        mainAttributes.put(new Attributes.Name("Application-Class"), this.appClass);
        mainAttributes.put(new Attributes.Name("Application-Name"), this.outputName);
        mainAttributes.put(new Attributes.Name("Premain-Class"), DEFAULT_CAPSULE_NAME);
        mainAttributes.put(new Attributes.Name("Build-Info"), this.buildInfoString());
        String artifactsString = this.artifactString();
        if (!artifactsString.isEmpty()) {
            mainAttributes.put(new Attributes.Name("Embedded-Artifacts"), artifactsString);
        }
        if (!(dependencyString = this.dependencyString()).isEmpty()) {
            mainAttributes.put(new Attributes.Name("Dependencies"), dependencyString);
        }
        if (!(repoString = this.repoString().trim()).isEmpty() && this.setManifestRepos) {
            mainAttributes.put(new Attributes.Name("Repositories"), repoString);
        }
        if (this.resolveApp || this.resolveCompileDep || this.resolveRuntimeDep || this.resolveProvidedDep || this.resolveSystemDep || this.resolveTestDep) {
            mainAttributes.put(new Attributes.Name("Caplets"), ("MavenCapsule " + this.caplets).trim());
        } else if (this.caplets != null && !this.caplets.isEmpty()) {
            mainAttributes.put(new Attributes.Name("Caplets"), this.caplets.trim());
        }
        String propertiesString = this.systemPropertiesString();
        if (propertiesString != null) {
            mainAttributes.put(new Attributes.Name("System-Properties"), propertiesString);
        }
        if (this.execConfig != null && (argsElement = this.execConfig.getChild("arguments")) != null && (argsElements = argsElement.getChildren()) != null && argsElements.length > 0) {
            StringBuilder argsList = new StringBuilder();
            for (Xpp3Dom arg : argsElements) {
                if (arg == null || arg.getValue() == null) continue;
                argsList.append(arg.getValue().replace(" ", "")).append(" ");
            }
            mainAttributes.put(new Attributes.Name("Args"), argsList.toString());
        }
        if (this.manifest != null) {
            for (Pair<String, String> entry : this.manifest) {
                mainAttributes.put(new Attributes.Name((String)entry.key), entry.value);
            }
        }
        if (this.modes != null) {
            for (Mode mode : this.modes) {
                if (mode.name == null) {
                    this.getLog().warn((CharSequence)(this.LOG_PREFIX + "Mode defined without name, ignoring."));
                    continue;
                }
                Attributes modeAttributes = new Attributes();
                if (mode.manifest != null) {
                    for (Pair entry : mode.manifest) {
                        modeAttributes.put(new Attributes.Name((String)entry.key), entry.value);
                    }
                }
                if (mode.properties != null) {
                    StringBuilder modePropertiesList = new StringBuilder();
                    for (Pair property : mode.properties) {
                        if (property.key == null || property.value == null) continue;
                        modePropertiesList.append(property.key).append("=").append(property.value).append(" ");
                    }
                    if (modePropertiesList.length() > 0) {
                        modeAttributes.put(new Attributes.Name("System-Properties"), modePropertiesList.toString());
                    }
                }
                if (modeAttributes.isEmpty()) continue;
                manifestBuild.getEntries().put(mode.name, modeAttributes);
            }
        }
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        manifestBuild.write(dataStream);
        byte[] bytes = dataStream.toByteArray();
        ByteArrayInputStream manifestInputStream = new ByteArrayInputStream(bytes);
        this.printManifest(manifestBuild);
        this.addToJar("META-INF/MANIFEST.MF", manifestInputStream, jar);
    }

    private void addCapsuleClass(JarOutputStream jar) throws IOException {
        JarEntry entry;
        JarInputStream capsuleJarInputStream = new JarInputStream(new FileInputStream(this.resolveCapsule()));
        while ((entry = capsuleJarInputStream.getNextJarEntry()) != null) {
            if (!entry.getName().equals(DEFAULT_CAPSULE_CLASS)) continue;
            this.addToJar(DEFAULT_CAPSULE_CLASS, new ByteArrayInputStream(IOUtil.toByteArray((InputStream)capsuleJarInputStream)), jar);
        }
    }

    private void addCapletClasses(JarOutputStream jar) throws IOException {
        if (this.caplets != null && !this.caplets.isEmpty()) {
            for (Map.Entry<String, File> caplet : this.capletFiles.entrySet()) {
                String path = caplet.getValue().getPath();
                this.addToJar(path.substring(path.indexOf("classes") + 8), new FileInputStream(caplet.getValue()), jar);
                this.info("\t[Caplet] Embedded Caplet class " + caplet.getKey() + " from " + caplet.getValue());
            }
        }
    }

    private void addMavenCapletClasses(JarOutputStream jar) throws IOException {
        if (this.resolveApp || this.resolveCompileDep || this.resolveRuntimeDep || this.resolveProvidedDep || this.resolveSystemDep || this.resolveTestDep) {
            JarEntry entry;
            JarInputStream capsuleJarInputStream = new JarInputStream(new FileInputStream(this.resolveCapsuleMaven()));
            while ((entry = capsuleJarInputStream.getNextJarEntry()) != null) {
                if (!entry.getName().contains("capsule") && !entry.getName().equals(DEFAULT_CAPSULE_MAVEN_CLASS)) continue;
                this.addToJar(entry.getName(), new ByteArrayInputStream(IOUtil.toByteArray((InputStream)capsuleJarInputStream)), jar);
            }
            this.info("\t[Maven Caplet] Embedded Maven Caplet classes v" + this.capsuleMavenVersion + " (so capsule can resolve at launch)");
        }
    }

    private void addApp(final JarOutputStream jar) throws IOException {
        if (this.includeApp) {
            try {
                File mainJarFile = new File(this.buildDir, this.finalName + ".jar");
                this.addToJar(mainJarFile.getName(), new FileInputStream(mainJarFile), jar);
                this.info("\t[App] App jar embedded (" + mainJarFile.getName() + ")");
            }
            catch (FileNotFoundException e) {
                this.warn("\t[App] Couldn't add main jar file to fat capsule, adding the project classes directly instead.");
                File classesDir = new File(this.buildDir, "classes");
                Files.walkFileTree(classesDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        if (!(attrs.isDirectory() || path.endsWith(".DS_Store") || path.endsWith("MANIFEST.MF"))) {
                            CapsuleMojo.this.addToJar(path.toString().substring(path.toString().indexOf("classes") + 8), new FileInputStream(path.toFile()), jar);
                            CapsuleMojo.this.debug("\t\t[App] Adding Compile Project Class to Capsule: [" + path.toFile().getPath() + "]");
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                this.info("\t[App] App class files embedded.");
            }
        } else if (this.resolveApp) {
            this.info("\t[App] App jar NOT embedded and marked to be resolved at launch.");
        } else {
            this.warn("\t[App] App jar NOT embedded and NOT marked to be resolved at launch.");
        }
    }

    private void addDependencies(JarOutputStream jar) throws IOException {
        Set<Artifact> artifacts = this.includeTransitiveDep ? this.dependencyArtifacts() : this.directDependencyArtifacts();
        for (Artifact artifact : artifacts) {
            String scope = artifact.getScope() == null || artifact.getScope().isEmpty() ? "compile" : artifact.getScope();
            boolean optionalMatch = true;
            if (artifact.isOptional()) {
                optionalMatch = this.includeOptionalDep;
            }
            if (artifact.getFile() == null) {
                this.warn("\t[Dependency] " + this.coords(artifact) + "(" + artifact.getScope() + ") file not found, thus will not be added to capsule jar.");
            }
            if (artifact.getGroupId().equalsIgnoreCase(CAPSULE_GROUP) && artifact.getArtifactId().equalsIgnoreCase(DEFAULT_CAPSULE_NAME)) continue;
            if (this.includeCompileDep && scope.equals("compile") && optionalMatch || this.includeRuntimeDep && scope.equals("runtime") && optionalMatch || this.includeProvidedDep && scope.equals("provided") && optionalMatch || this.includeSystemDep && scope.equals("system") && optionalMatch || this.includeTestDep && scope.equals("test") && optionalMatch) {
                this.addToJar(artifact.getFile().getName(), new FileInputStream(artifact.getFile()), jar);
                this.info("\t[Embedded-Dependency] " + this.coords(artifact) + "(" + scope + ")");
                continue;
            }
            this.debug("\t[Dependency] " + this.coords(artifact) + "(" + artifact.getScope() + ") skipped, as it does not match any required scope");
        }
    }

    private void addFileSets(JarOutputStream jar) throws IOException {
        if (this.fileSets == null) {
            return;
        }
        for (FileSet fileSet : this.fileSets) {
            File directory;
            if (fileSet.directory == null || fileSet.directory.isEmpty()) continue;
            File fileSetDir = new File(fileSet.directory);
            if (fileSetDir.isAbsolute()) {
                directory = fileSetDir;
                this.debug("\t[FileSet]: Use absolute Path: " + directory.getPath());
            } else {
                directory = new File(this.baseDir.getPath() + File.separatorChar + fileSet.directory);
                this.debug("\t[FileSet]: Resolve relative Path: " + directory.getPath());
            }
            if (!directory.isDirectory()) {
                this.warn("[FileSet] Attempted to include file from non-directory [" + directory.getAbsolutePath() + "], skipping...");
                continue;
            }
            String outputDirectory = this.addDirectoryToJar(jar, fileSet.outputDirectory);
            for (String include : fileSet.includes) {
                FileInputStream fin = new FileInputStream(new File(directory, include));
                this.addToJar(outputDirectory + include, fin, jar);
                this.info("\t[FileSet]: Embedded " + outputDirectory + include + " from " + directory);
            }
        }
    }

    private void addDependencySets(JarOutputStream jar) throws IOException {
        if (this.dependencySets == null) {
            return;
        }
        for (DependencySet dependencySet : this.dependencySets) {
            for (Object artifactObject : this.project.getDependencyArtifacts()) {
                Artifact artifact = (Artifact)artifactObject;
                if (!dependencySet.groupId.equals(artifact.getGroupId()) || !dependencySet.artifactId.equals(artifact.getArtifactId())) continue;
                if (dependencySet.version == null || dependencySet.version.equals(artifact.getVersion())) {
                    if (artifact.getFile() == null) {
                        this.warn("Could not resolve dependency: " + dependencySet.groupId + ":" + dependencySet.artifactId + ":" + dependencySet.version);
                        continue;
                    }
                    JarFile jarFile = new JarFile(artifact.getFile());
                    String outputDirectory = this.addDirectoryToJar(jar, dependencySet.outputDirectory);
                    if (dependencySet.includes != null && dependencySet.includes.length > 0) {
                        for (String include : dependencySet.includes) {
                            ZipEntry entry = jarFile.getEntry(include);
                            if (entry != null) {
                                this.addToJar(outputDirectory + include, jarFile.getInputStream(entry), jar);
                                this.info("\t[DependencySet]: Embedded " + outputDirectory + include + " from " + artifact.getFile());
                                continue;
                            }
                            this.warn(include + " not found in " + artifact.getFile());
                        }
                        continue;
                    }
                    if (!dependencySet.unpack) {
                        this.info("\t[DependencySet]: Adding " + artifact.getFile().getName() + " to " + outputDirectory);
                        this.addToJar(outputDirectory + artifact.getFile().getName(), new FileInputStream(artifact.getFile()), jar);
                        continue;
                    }
                    if (artifact.getType() != null && artifact.getType().equals("jar")) {
                        this.info("\t[DependencySet]: Adding (unpacked) " + artifact.getFile().getName() + " to " + outputDirectory);
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            this.debug("\t\t[DependencySet]: Adding (unpacked) " + outputDirectory + entry.getName());
                            this.addToJar(outputDirectory + entry.getName(), jarFile.getInputStream(entry), jar);
                        }
                        continue;
                    }
                    this.warn("\t[DependencySet]: Cannot unpack " + artifact.getFile().getName() + " as it is not in jar format.");
                    continue;
                }
                this.warn("\t[DependencySet]: Artifact version mismatch: " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion());
            }
        }
    }

    private void addChmodCopy(File jar) throws IOException {
        if (this.chmod) {
            File file = this.createExecCopyProcess(jar, EXEC_PREFIX, ".x");
            this.info("[Capsule CHMOD]: " + file.getName());
        }
    }

    private void addTrampolineCopy(File jar) throws IOException {
        if (this.trampoline) {
            File file = this.createExecCopyProcess(jar, EXEC_TRAMPOLINE_PREFIX, ".tx");
            this.info("[Capsule Trampoline]: " + file.getName());
        }
    }

    private String buildInfoString() {
        StringBuilder builder = new StringBuilder();
        if (this.includeApp) {
            builder.append("includeApp ");
        }
        if (this.includeCompileDep) {
            builder.append("includeCompileDep ");
        }
        if (this.includeRuntimeDep) {
            builder.append("includeRuntimeDep ");
        }
        if (this.includeProvidedDep) {
            builder.append("includeProvidedDep ");
        }
        if (this.includeSystemDep) {
            builder.append("includeSystemDep ");
        }
        if (this.includeTestDep) {
            builder.append("includeTestDep ");
        }
        if (this.includeTransitiveDep) {
            builder.append("includeTransitiveDep ");
        }
        if (this.resolveApp) {
            builder.append("resolveApp ");
        }
        if (this.resolveCompileDep) {
            builder.append("resolveCompileDep ");
        }
        if (this.resolveRuntimeDep) {
            builder.append("resolveRuntimeDep ");
        }
        if (this.resolveProvidedDep) {
            builder.append("resolveProvidedDep ");
        }
        if (this.resolveSystemDep) {
            builder.append("resolveSystemDep ");
        }
        if (this.resolveTestDep) {
            builder.append("resolveTestDep ");
        }
        if (this.resolveTransitiveDep) {
            builder.append("resolveTransitiveDep ");
        }
        return builder.toString().trim();
    }

    private String repoString() {
        StringBuilder repoList = new StringBuilder();
        for (RemoteRepository repository : this.remoteRepos) {
            repoList.append(repository.getId()).append("(").append(repository.getUrl()).append(") ");
        }
        return repoList.toString();
    }

    private String artifactString() throws IOException {
        StringBuilder artifactList = new StringBuilder();
        if (this.includeApp) {
            artifactList.append(this.coords(this.project.getArtifact())).append(" ");
        }
        List<Dependency> dependencies = this.includeTransitiveDep ? this.dependencies() : this.directDependencies();
        for (Dependency dependency : dependencies) {
            String scope = dependency.getScope() == null || dependency.getScope().isEmpty() ? "compile" : dependency.getScope();
            boolean optionalMatch = true;
            if (dependency.isOptional()) {
                optionalMatch = this.includeOptionalDep;
            }
            if (dependency.getGroupId().equalsIgnoreCase(CAPSULE_GROUP) && dependency.getArtifactId().equalsIgnoreCase(DEFAULT_CAPSULE_NAME) || !(this.includeCompileDep && scope.equals("compile") && optionalMatch || this.includeRuntimeDep && scope.equals("runtime") && optionalMatch || this.includeProvidedDep && scope.equals("provided") && optionalMatch || this.includeSystemDep && scope.equals("system") && optionalMatch) && (!this.includeTestDep || !scope.equals("test") || !optionalMatch)) continue;
            artifactList.append(this.coordsWithExclusions(dependency)).append(" ");
        }
        return artifactList.toString();
    }

    private String dependencyString() throws IOException {
        StringBuilder dependenciesList = new StringBuilder();
        if (this.resolveApp) {
            dependenciesList.append(this.coords(this.project.getArtifact())).append(" ");
        }
        List<Dependency> dependencies = this.resolveTransitiveDep ? this.dependencies() : this.directDependencies();
        for (Dependency dependency : dependencies) {
            String scope = dependency.getScope() == null || dependency.getScope().isEmpty() ? "compile" : dependency.getScope();
            boolean optionalMatch = true;
            if (dependency.isOptional()) {
                optionalMatch = this.resolveOptionalDep;
            }
            if (dependency.getGroupId().equalsIgnoreCase(CAPSULE_GROUP) && dependency.getArtifactId().equalsIgnoreCase(DEFAULT_CAPSULE_NAME) || !(this.resolveCompileDep && scope.equals("compile") && optionalMatch || this.resolveRuntimeDep && scope.equals("runtime") && optionalMatch || this.resolveProvidedDep && scope.equals("provided") && optionalMatch || this.resolveSystemDep && scope.equals("system") && optionalMatch) && (!this.resolveTestDep || !scope.equals("test") || !optionalMatch)) continue;
            dependenciesList.append(this.coordsWithExclusions(dependency)).append(" ");
        }
        return dependenciesList.toString();
    }

    private String systemPropertiesString() {
        StringBuilder propertiesList;
        block6: {
            Xpp3Dom[] propertiesElements;
            block5: {
                propertiesList = null;
                if (this.properties == null) break block5;
                propertiesList = new StringBuilder();
                for (Pair<String, String> property : this.properties) {
                    if (property.key == null) continue;
                    propertiesList.append(property.key);
                    if (property.value != null && property.value instanceof String && !((String)property.value).isEmpty()) {
                        propertiesList.append("=").append(property.value);
                    }
                    propertiesList.append(" ");
                }
                break block6;
            }
            if (this.execConfig == null) break block6;
            propertiesList = new StringBuilder();
            Xpp3Dom propertiesElement = this.execConfig.getChild("systemProperties");
            if (propertiesElement != null && (propertiesElements = propertiesElement.getChildren()) != null && propertiesElements.length > 0) {
                for (Xpp3Dom propertyElement : propertiesElements) {
                    Xpp3Dom key = propertyElement.getChild("key");
                    Xpp3Dom value = propertyElement.getChild("value");
                    if (key == null || key.getValue() == null) continue;
                    propertiesList.append(key.getValue()).append("=");
                    if (value != null && value.getValue() != null && !value.getValue().isEmpty()) {
                        propertiesList.append("=").append(value.getValue());
                    }
                    propertiesList.append(" ");
                }
            }
        }
        return propertiesList == null ? null : propertiesList.toString().trim();
    }

    private String coords(String groupId, String artifactId, String classifier, String version) {
        StringBuilder coords = new StringBuilder();
        coords.append(groupId).append(":").append(artifactId);
        if (classifier != null && !classifier.isEmpty()) {
            coords.append(":").append(classifier);
        }
        coords.append(":").append(version);
        return coords.toString();
    }

    private String coords(Artifact artifact) {
        return this.coords(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getVersion());
    }

    private String coords(Dependency dependency) {
        return this.coords(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getVersion());
    }

    private String coordsWithExclusions(Dependency dependency) {
        StringBuilder coords = new StringBuilder(this.coords(dependency));
        if (dependency.getExclusions().size() > 0) {
            StringBuilder exclusionsList = new StringBuilder();
            int i = 0;
            for (Exclusion exclusion : dependency.getExclusions()) {
                if (i > 0) {
                    exclusionsList.append(",");
                }
                exclusionsList.append(exclusion.getGroupId()).append(":").append(exclusion.getArtifactId());
                ++i;
            }
            coords.append("(").append(exclusionsList.toString()).append(")");
        }
        return coords.toString();
    }

    private String addDirectoryToJar(JarOutputStream jar, String outputDirectory) throws IOException {
        String formattedOutputDirectory = "";
        if (outputDirectory != null && !outputDirectory.isEmpty()) {
            formattedOutputDirectory = !outputDirectory.endsWith("/") ? outputDirectory + File.separatorChar : outputDirectory;
        }
        if (!formattedOutputDirectory.isEmpty()) {
            try {
                jar.putNextEntry(new ZipEntry(formattedOutputDirectory));
                jar.closeEntry();
            }
            catch (ZipException zipException) {
                // empty catch block
            }
        }
        return formattedOutputDirectory;
    }

    private JarOutputStream addToJar(String name, InputStream input, JarOutputStream jar) throws IOException {
        try {
            this.debug("\t[Added to Jar]: " + name);
            jar.putNextEntry(new ZipEntry(name));
            IOUtil.copy((InputStream)input, (OutputStream)jar);
            jar.closeEntry();
        }
        catch (ZipException zipException) {
            // empty catch block
        }
        IOUtil.close((InputStream)input);
        return jar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createExecCopyProcess(File jar, String prefix, String extension) throws IOException {
        File x = new File(jar.getPath().replace(".jar", extension));
        if (x.exists()) {
            this.debug("EXISTS - " + x.getName());
            return x;
        }
        FileOutputStream out = null;
        FileInputStream in = null;
        try {
            out = new FileOutputStream(x);
            in = new FileInputStream(jar);
            out.write(prefix.getBytes("ASCII"));
            Files.copy(jar.toPath(), out);
            out.flush();
            boolean execResult = x.setExecutable(true, false);
            if (!execResult) {
                this.warn("Failed to mark file executable - " + x.getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close((OutputStream)out);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        IOUtil.close((OutputStream)out);
        return x;
    }

    private File resolveCapsule() throws IOException {
        if (this.resolvedCapsuleProjectFile == null) {
            ArtifactResult artifactResult;
            try {
                artifactResult = this.resolve(CAPSULE_GROUP, "capsule", null, this.capsuleVersion);
            }
            catch (ArtifactResolutionException e) {
                throw new IOException("Capsule not found from repos");
            }
            this.resolvedCapsuleProjectFile = artifactResult.getArtifact().getFile();
        }
        return this.resolvedCapsuleProjectFile;
    }

    private File resolveCapsuleMaven() throws IOException {
        if (this.resolvedCapsuleMavenProjectFile == null) {
            ArtifactResult artifactResult;
            try {
                artifactResult = this.resolve(CAPSULE_GROUP, "capsule-maven", null, this.capsuleMavenVersion);
            }
            catch (ArtifactResolutionException e) {
                throw new IOException("CapsuleMaven not found from repos");
            }
            this.resolvedCapsuleMavenProjectFile = artifactResult.getArtifact().getFile();
        }
        return this.resolvedCapsuleMavenProjectFile;
    }

    private ArtifactResult resolve(String groupId, String artifactId, String classifier, String version) throws ArtifactResolutionException {
        String coords = groupId + ":" + artifactId;
        if (classifier != null && !classifier.isEmpty()) {
            coords = coords + ":" + classifier;
        }
        if (version != null && !version.isEmpty()) {
            coords = coords + ":" + version;
        }
        return this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(coords), this.remoteRepos, null));
    }

    private List<Dependency> directDependencies() {
        return this.project.getDependencies();
    }

    private Set<Artifact> directDependencyArtifacts() {
        return this.project.getDependencyArtifacts();
    }

    private List<Dependency> dependencies() {
        return this.project.getTestDependencies();
    }

    private Set<Artifact> dependencyArtifacts() {
        return this.project.getArtifacts();
    }

    private void debug(String message) {
        this.getLog().debug((CharSequence)(this.LOG_PREFIX + message));
    }

    private void info(String message) {
        this.getLog().info((CharSequence)(this.LOG_PREFIX + message));
    }

    private void warn(String message) {
        this.getLog().warn((CharSequence)(this.LOG_PREFIX + message));
    }

    private void printManifest(Manifest manifest) {
        this.info("\t[Manifest]:");
        for (Map.Entry<Object, Object> entry : manifest.getMainAttributes().entrySet()) {
            this.info("\t\t" + entry.getKey().toString() + ": " + entry.getValue().toString());
        }
        for (Map.Entry<Object, Object> entry : manifest.getEntries().entrySet()) {
            this.info("");
            this.info("\t\tName:" + (String)entry.getKey());
            for (Map.Entry<Object, Object> attr : ((Attributes)entry.getValue()).entrySet()) {
                this.info("\t\t" + attr.getKey().toString() + ": " + attr.getValue().toString());
            }
        }
    }

    public static class FileSet {
        public String directory;
        public String outputDirectory;
        public String[] includes;
    }

    public static class DependencySet {
        public String groupId;
        public String artifactId;
        public String version;
        public String outputDirectory = "/";
        public String[] includes;
        public boolean unpack = false;
    }

    public static class Mode {
        private String name = null;
        private Pair<String, String>[] properties = null;
        private Pair<String, String>[] manifest = null;
    }

    public static enum Type {
        empty,
        thin,
        fat;

    }

    public static class Pair<K, V> {
        public K key;
        public V value;

        public Pair() {
        }

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

