/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisdchristo.capsule;

import com.github.chrisdchristo.capsule.Mojo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;

@org.apache.maven.plugins.annotations.Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class CapsuleMojo
extends Mojo {
    private static final String DEFAULT_CAPSULE_VERSION = "1.0.3";
    private static final String DEFAULT_CAPSULE_MAVEN_VERSION = "1.0.3";
    private static final String CAPSULE_GROUP = "co.paralleluniverse";
    private static final String DEFAULT_CAPSULE_NAME = "Capsule";
    private static final String DEFAULT_CAPSULE_CLASS = "Capsule.class";
    private static final String DEFAULT_CAPSULE_MAVEN_NAME = "MavenCapsule";
    private static final String DEFAULT_CAPSULE_MAVEN_CLASS = "MavenCapsule.class";
    private static final String EXEC_PREFIX = "#!/bin/sh\n\nexec java -jar \"$0\" \"$@\"\n\n";
    private static final String EXEC_TRAMPOLINE_PREFIX = "#!/bin/sh\n\nexec java -Dcapsule.trampoline -jar \"$0\" \"$@\"\n\n";
    private static final String EXEC_PLUGIN_KEY = "org.codehaus.mojo:exec-maven-plugin";
    @Parameter(property="capsule.outputDir", defaultValue="${project.build.directory}")
    private File outputDir = null;
    @Parameter(property="capsule.version")
    private String capsuleVersion = "1.0.3";
    @Parameter(property="capsule.maven.version")
    private String capsuleMavenVersion = "1.0.3";
    @Parameter(property="capsule.appClass")
    private String appClass = null;
    @Parameter(property="capsule.caplets")
    private String caplets;
    @Parameter(property="capsule.type")
    private Type type = null;
    @Parameter(property="capsule.chmod")
    private boolean chmod = false;
    @Parameter(property="capsule.trampoline")
    private boolean trampoline = false;
    @Parameter(property="capsule.setManifestRepos")
    private boolean setManifestRepos = false;
    @Parameter(property="capsule.includeApp")
    private boolean includeApp = true;
    @Parameter(property="capsule.includeAppDep")
    private boolean includeAppDep = false;
    @Parameter(property="capsule.includePluginDep")
    private boolean includePluginDep = false;
    @Parameter(property="capsule.includeTransitiveDep")
    private boolean includeTransitiveDep = false;
    @Parameter(property="capsule.includeCompileDep")
    private boolean includeCompileDep = false;
    @Parameter(property="capsule.includeRuntimeDep")
    private boolean includeRuntimeDep = false;
    @Parameter(property="capsule.includeProvidedDep")
    private boolean includeProvidedDep = false;
    @Parameter(property="capsule.includeSystemDep")
    private boolean includeSystemDep = false;
    @Parameter(property="capsule.includeTestDep")
    private boolean includeTestDep = false;
    @Parameter(property="capsule.includeOptionalDep")
    private boolean includeOptionalDep = false;
    @Parameter(property="capsule.resolveApp")
    private boolean resolveApp = false;
    @Parameter(property="capsule.resolveAppDep")
    private boolean resolveAppDep = false;
    @Parameter(property="capsule.resolvePluginDep")
    private boolean resolvePluginDep = false;
    @Parameter(property="capsule.resolveTransitiveDep")
    private boolean resolveTransitiveDep = false;
    @Parameter(property="capsule.resolveCompileDep")
    private boolean resolveCompileDep = false;
    @Parameter(property="capsule.resolveRuntimeDep")
    private boolean resolveRuntimeDep = false;
    @Parameter(property="capsule.resolveProvidedDep")
    private boolean resolveProvidedDep = false;
    @Parameter(property="capsule.resolveSystemDep")
    private boolean resolveSystemDep = false;
    @Parameter(property="capsule.resolveTestDep")
    private boolean resolveTestDep = false;
    @Parameter(property="capsule.resolveOptionalDep")
    private boolean resolveOptionalDep = false;
    @Parameter(property="capsule.execPluginConfig")
    private String execPluginConfig = null;
    @Parameter(property="capsule.fileName")
    private String fileName = null;
    @Parameter(property="capsule.fileDesc")
    private String fileDesc = "-capsule";
    @Parameter
    private Mojo.Pair<String, String>[] properties = null;
    @Parameter
    private Mojo.Pair<String, String>[] manifest = null;
    @Parameter
    private Mode[] modes = null;
    @Parameter
    private FileSet[] fileSets = null;
    @Parameter
    private DependencySet[] dependencySets = null;
    private Map<String, File> capletFiles = new HashMap<String, File>();
    private Xpp3Dom execConfig = null;
    private File resolvedCapsuleProjectFile = null;
    private File resolvedCapsuleMavenProjectFile = null;
    private String outputName;

    @Override
    public final String pluginKey() {
        return "com.github.chrisdchristo:capsule-maven-plugin";
    }

    @Override
    public final String logPrefix() {
        return "[CapsuleMavenPlugin] ";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean success;
        List<String> illegalOutputPaths;
        Xpp3Dom mainClassElement;
        if (this.type == Type.empty) {
            this.includeApp = false;
            this.includeAppDep = false;
            this.includePluginDep = false;
            this.includeTransitiveDep = false;
            this.includeCompileDep = false;
            this.includeRuntimeDep = false;
            this.includeProvidedDep = false;
            this.includeSystemDep = false;
            this.includeTestDep = false;
            this.includeOptionalDep = false;
            this.resolveApp = true;
            this.resolveAppDep = true;
            this.resolvePluginDep = true;
            this.resolveTransitiveDep = true;
            this.resolveCompileDep = true;
            this.resolveRuntimeDep = true;
            this.resolveProvidedDep = false;
            this.resolveSystemDep = false;
            this.resolveTestDep = false;
            this.resolveOptionalDep = false;
        } else if (this.type == Type.thin) {
            this.includeApp = true;
            this.includeAppDep = false;
            this.includePluginDep = false;
            this.includeTransitiveDep = false;
            this.includeCompileDep = false;
            this.includeRuntimeDep = false;
            this.includeProvidedDep = false;
            this.includeSystemDep = false;
            this.includeTestDep = false;
            this.includeOptionalDep = false;
            this.resolveApp = false;
            this.resolveAppDep = true;
            this.resolvePluginDep = true;
            this.resolveTransitiveDep = true;
            this.resolveCompileDep = true;
            this.resolveRuntimeDep = true;
            this.resolveProvidedDep = false;
            this.resolveSystemDep = false;
            this.resolveTestDep = false;
            this.resolveOptionalDep = false;
        } else if (this.type == Type.fat) {
            this.includeApp = true;
            this.includeAppDep = true;
            this.includePluginDep = true;
            this.includeTransitiveDep = true;
            this.includeCompileDep = true;
            this.includeRuntimeDep = true;
            this.includeProvidedDep = false;
            this.includeSystemDep = false;
            this.includeTestDep = false;
            this.includeOptionalDep = false;
            this.resolveApp = false;
            this.resolveAppDep = false;
            this.resolvePluginDep = false;
            this.resolveTransitiveDep = false;
            this.resolveCompileDep = false;
            this.resolveRuntimeDep = false;
            this.resolveProvidedDep = false;
            this.resolveSystemDep = false;
            this.resolveTestDep = false;
            this.resolveOptionalDep = false;
        }
        if (this.execPluginConfig != null && this.project.getPlugin(EXEC_PLUGIN_KEY) != null) {
            Plugin plugin = this.project.getPlugin(EXEC_PLUGIN_KEY);
            if (this.execPluginConfig.equals("root")) {
                this.execConfig = (Xpp3Dom)plugin.getConfiguration();
            } else {
                List executions = plugin.getExecutions();
                for (PluginExecution execution : executions) {
                    if (!execution.getId().equals(this.execPluginConfig)) continue;
                    this.execConfig = (Xpp3Dom)execution.getConfiguration();
                    break;
                }
            }
        }
        if (this.appClass == null && this.execConfig != null && (mainClassElement = this.execConfig.getChild("mainClass")) != null) {
            this.appClass = mainClassElement.getValue();
        }
        if (this.appClass == null) {
            throw new MojoFailureException(this.logPrefix() + " appClass not set (or could not be obtained from the exec plugin mainClass)");
        }
        String string = this.outputName = this.fileName != null ? this.fileName : this.finalName;
        if (this.fileDesc != null) {
            this.outputName = this.outputName + this.fileDesc;
        }
        if (this.caplets == null) {
            this.caplets = "";
        }
        if (!this.caplets.isEmpty()) {
            StringBuilder capletString = new StringBuilder();
            File classesDir = new File(this.buildDir, "classes");
            for (final String caplet : this.caplets.split(" ")) {
                try {
                    Files.walkFileTree(classesDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                            if (!attrs.isDirectory() && path.toString().contains(caplet)) {
                                CapsuleMojo.this.capletFiles.put(caplet, path.toFile());
                                return FileVisitResult.TERMINATE;
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (!this.capletFiles.containsKey(caplet) && !caplet.contains(":")) {
                    this.warn("Could not find caplet " + caplet + " class, skipping.");
                }
                if (capletString.length() > 0) {
                    capletString.append(" ");
                }
                capletString.append(caplet);
            }
            this.caplets = capletString.toString();
        }
        if (this.capsuleVersion == null) {
            DefaultArtifact artifact = new DefaultArtifact(CAPSULE_GROUP, "capsule", null, null, "[0,)");
            VersionRangeRequest request = new VersionRangeRequest().setRepositories(this.remoteRepos).setArtifact((org.eclipse.aether.artifact.Artifact)artifact);
            try {
                VersionRangeResult result = this.repoSystem.resolveVersionRange(this.repoSession, request);
                for (int i = result.getVersions().size() - 1; i >= 0; --i) {
                    String currentVersion = ((Version)result.getVersions().get(i)).toString();
                    if (currentVersion.contains("SNAPSHOT")) continue;
                    this.capsuleVersion = ((Version)result.getVersions().get(i)).toString();
                    break;
                }
            }
            catch (VersionRangeResolutionException e) {
                throw new MojoFailureException(e.getMessage());
            }
        }
        if ((illegalOutputPaths = Arrays.asList(this.buildDir.getPath() + File.separatorChar + "classes", this.buildDir.getPath() + File.separatorChar + "classes/")).contains(this.outputDir.getPath())) {
            this.outputDir = this.buildDir;
            this.debug("Output was an illegal path, resorting to default build directory.");
        }
        if (!this.outputDir.exists() && !(success = this.outputDir.mkdirs())) {
            throw new MojoFailureException("Failed to build outputDir path");
        }
        this.info("[Capsule Version]: " + this.capsuleVersion);
        this.info("[Output Directory]: " + this.outputDir.toString());
        this.info("[Build Info]: " + this.buildInfoString());
        try {
            this.build();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoFailureException(e.getMessage());
        }
    }

    public void build() throws IOException {
        File jarFile = new File(this.outputDir, this.outputName + ".jar");
        if (jarFile.exists()) {
            this.info("EXISTS - " + jarFile.getName() + " (WILL OVERWRITE)");
            boolean deleteResult = jarFile.delete();
            if (!deleteResult) {
                this.warn("FAILED TO DELETE - " + jarFile.getName());
            }
        }
        JarOutputStream jarStream = new JarOutputStream(new FileOutputStream(jarFile));
        this.info("[Capsule Jar File]: " + jarFile.getName());
        this.addManifest(jarStream);
        this.addCapsuleClass(jarStream);
        this.addCapletClasses(jarStream);
        this.addMavenCapletClasses(jarStream);
        this.addApp(jarStream);
        this.addDependencies(jarStream);
        this.addFileSets(jarStream);
        this.addDependencySets(jarStream);
        IOUtil.close((OutputStream)jarStream);
        this.addChmodCopy(jarFile);
        this.addTrampolineCopy(jarFile);
        this.info("[Maven Artifact]: Attached capsule artifact to maven (" + jarFile.getName() + ").");
        this.helper.attachArtifact(this.project, jarFile, "capsule");
    }

    private void addManifest(JarOutputStream jar) throws IOException {
        Xpp3Dom[] argsElements;
        Object[] argsElement;
        String repoString;
        String dependencyString;
        Manifest manifestBuild = new Manifest();
        Attributes mainAttributes = manifestBuild.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.put(Attributes.Name.MAIN_CLASS, DEFAULT_CAPSULE_NAME);
        mainAttributes.put(new Attributes.Name("Application-Class"), this.appClass);
        mainAttributes.put(new Attributes.Name("Application-Name"), this.outputName);
        mainAttributes.put(new Attributes.Name("Premain-Class"), DEFAULT_CAPSULE_NAME);
        mainAttributes.put(new Attributes.Name("Build-Info"), this.buildInfoString());
        String artifactsString = this.artifactString();
        if (!artifactsString.isEmpty()) {
            mainAttributes.put(new Attributes.Name("Embedded-Artifacts"), artifactsString);
        }
        if (!(dependencyString = this.dependencyString()).isEmpty()) {
            mainAttributes.put(new Attributes.Name("Dependencies"), dependencyString);
        }
        if (!(repoString = this.repoString().trim()).isEmpty() && this.setManifestRepos) {
            mainAttributes.put(new Attributes.Name("Repositories"), repoString);
        }
        if (this.resolveApp || this.resolveCompileDep || this.resolveRuntimeDep || this.resolveProvidedDep || this.resolveSystemDep || this.resolveTestDep) {
            mainAttributes.put(new Attributes.Name("Caplets"), ("MavenCapsule " + this.caplets).trim());
        } else if (this.caplets != null && !this.caplets.isEmpty()) {
            mainAttributes.put(new Attributes.Name("Caplets"), this.caplets.trim());
        }
        String propertiesString = this.systemPropertiesString();
        if (propertiesString != null) {
            mainAttributes.put(new Attributes.Name("System-Properties"), propertiesString);
        }
        if (this.execConfig != null && (argsElement = this.execConfig.getChild("arguments")) != null && (argsElements = argsElement.getChildren()) != null && argsElements.length > 0) {
            StringBuilder argsList = new StringBuilder();
            for (Xpp3Dom arg : argsElements) {
                if (arg == null || arg.getValue() == null) continue;
                argsList.append(arg.getValue().replace(" ", "")).append(" ");
            }
            mainAttributes.put(new Attributes.Name("Args"), argsList.toString());
        }
        if (this.manifest != null) {
            for (Mojo.Pair<String, String> entry : this.manifest) {
                mainAttributes.put(new Attributes.Name((String)entry.key), entry.value);
            }
        }
        if (this.modes != null) {
            for (Mode mode : this.modes) {
                if (mode.name == null) {
                    this.warn("Mode defined without name, ignoring.");
                    continue;
                }
                Attributes modeAttributes = new Attributes();
                if (mode.manifest != null) {
                    for (Mojo.Pair entry : mode.manifest) {
                        modeAttributes.put(new Attributes.Name((String)entry.key), entry.value);
                    }
                }
                if (mode.properties != null) {
                    StringBuilder modePropertiesList = new StringBuilder();
                    for (Mojo.Pair property : mode.properties) {
                        if (property.key == null || property.value == null) continue;
                        modePropertiesList.append(property.key).append("=").append(property.value).append(" ");
                    }
                    if (modePropertiesList.length() > 0) {
                        modeAttributes.put(new Attributes.Name("System-Properties"), modePropertiesList.toString());
                    }
                }
                if (modeAttributes.isEmpty()) continue;
                manifestBuild.getEntries().put(mode.name, modeAttributes);
            }
        }
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        manifestBuild.write(dataStream);
        byte[] bytes = dataStream.toByteArray();
        ByteArrayInputStream manifestInputStream = new ByteArrayInputStream(bytes);
        this.printManifest(manifestBuild);
        this.addToJar("META-INF/MANIFEST.MF", manifestInputStream, jar);
    }

    private void addCapsuleClass(JarOutputStream jar) throws IOException {
        JarEntry entry;
        JarInputStream capsuleJarInputStream = new JarInputStream(new FileInputStream(this.resolveCapsule()));
        while ((entry = capsuleJarInputStream.getNextJarEntry()) != null) {
            if (!entry.getName().equals(DEFAULT_CAPSULE_CLASS)) continue;
            this.addToJar(DEFAULT_CAPSULE_CLASS, new ByteArrayInputStream(IOUtil.toByteArray((InputStream)capsuleJarInputStream)), jar);
        }
    }

    private void addCapletClasses(JarOutputStream jar) throws IOException {
        if (this.caplets != null && !this.caplets.isEmpty()) {
            for (Map.Entry<String, File> caplet : this.capletFiles.entrySet()) {
                String path = caplet.getValue().getPath();
                this.addToJar(path.substring(path.indexOf("classes") + 8), new FileInputStream(caplet.getValue()), jar);
                this.info("\t[Caplet] Embedded Caplet class " + caplet.getKey() + " from " + caplet.getValue());
            }
        }
    }

    private void addMavenCapletClasses(JarOutputStream jar) throws IOException {
        if (this.resolveApp || this.resolveCompileDep || this.resolveRuntimeDep || this.resolveProvidedDep || this.resolveSystemDep || this.resolveTestDep) {
            JarEntry entry;
            JarInputStream capsuleJarInputStream = new JarInputStream(new FileInputStream(this.resolveCapsuleMaven()));
            while ((entry = capsuleJarInputStream.getNextJarEntry()) != null) {
                if (!entry.getName().contains("capsule") && !entry.getName().equals(DEFAULT_CAPSULE_MAVEN_CLASS)) continue;
                this.addToJar(entry.getName(), new ByteArrayInputStream(IOUtil.toByteArray((InputStream)capsuleJarInputStream)), jar);
            }
            this.info("\t[Maven Caplet] Embedded Maven Caplet classes v" + this.capsuleMavenVersion + " (so capsule can resolve at launch)");
        }
    }

    private void addApp(final JarOutputStream jar) throws IOException {
        if (this.includeApp) {
            try {
                File mainJarFile = new File(this.buildDir, this.finalName + ".jar");
                this.addToJar(mainJarFile.getName(), new FileInputStream(mainJarFile), jar);
                this.info("\t[App] App jar embedded (" + mainJarFile.getName() + ")");
            }
            catch (FileNotFoundException e) {
                this.warn("\t[App] Couldn't add main jar file to fat capsule, adding the project classes directly instead.");
                File classesDir = new File(this.buildDir, "classes");
                Files.walkFileTree(classesDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        if (!(attrs.isDirectory() || path.endsWith(".DS_Store") || path.endsWith("MANIFEST.MF"))) {
                            CapsuleMojo.this.addToJar(path.toString().substring(path.toString().indexOf("classes") + 8), new FileInputStream(path.toFile()), jar);
                            CapsuleMojo.this.debug("\t\t[App] Adding Compile Project Class to Capsule: [" + path.toFile().getPath() + "]");
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                this.info("\t[App] App class files embedded.");
            }
        } else if (this.resolveApp) {
            this.info("\t[App] App jar NOT embedded and marked to be resolved at launch.");
        } else {
            this.warn("\t[App] App jar NOT embedded and NOT marked to be resolved at launch.");
        }
    }

    private void addDependencies(JarOutputStream jar) throws IOException {
        Set<Artifact> artifacts = this.includeTransitiveDep ? this.includedDependencyArtifacts() : this.includedDirectDependencyArtifacts();
        for (Artifact artifact : artifacts) {
            String scope = artifact.getScope() == null || artifact.getScope().isEmpty() ? "compile" : artifact.getScope();
            boolean optionalMatch = true;
            if (artifact.isOptional()) {
                optionalMatch = this.includeOptionalDep;
            }
            if (artifact.getFile() == null) {
                this.warn("\t[Dependency] " + CapsuleMojo.coords(artifact) + "(" + artifact.getScope() + ") file not found, thus will not be added to capsule jar.");
            }
            if (artifact.getGroupId().equalsIgnoreCase(CAPSULE_GROUP) && artifact.getArtifactId().equalsIgnoreCase(DEFAULT_CAPSULE_NAME)) continue;
            if (this.includeCompileDep && scope.equals("compile") && optionalMatch || this.includeRuntimeDep && scope.equals("runtime") && optionalMatch || this.includeProvidedDep && scope.equals("provided") && optionalMatch || this.includeSystemDep && scope.equals("system") && optionalMatch || this.includeTestDep && scope.equals("test") && optionalMatch) {
                this.addToJar(artifact.getFile().getName(), new FileInputStream(artifact.getFile()), jar);
                this.info("\t[Embedded-Dependency] " + CapsuleMojo.coords(artifact) + "(" + scope + ")");
                continue;
            }
            this.debug("\t[Dependency] " + CapsuleMojo.coords(artifact) + "(" + artifact.getScope() + ") skipped, as it does not match any required scope");
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void addFileSets(JarOutputStream jar) throws IOException {
        if (this.fileSets == null) {
            return;
        }
        for (FileSet fileSet : this.fileSets) {
            if (fileSet.directory == null || fileSet.directory.isEmpty()) continue;
            File fileSetDir = new File(fileSet.directory);
            File directory = fileSetDir.isAbsolute() ? fileSetDir : new File(this.baseDir.getPath() + File.separatorChar + fileSet.directory);
            if (!directory.isDirectory()) {
                this.warn("[FileSet] Attempted to include file from non-directory [" + directory.getAbsolutePath() + "], skipping...");
                continue;
            }
            String outputDirectory = this.addDirectoryToJar(jar, fileSet.outputDirectory);
            HashSet<File> matchedEntries = new HashSet<File>();
            HashSet<Object> entries = new HashSet<Object>();
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) continue;
                    entries.add(file);
                }
            }
            for (File entry : entries) {
                System.out.println(entry.toString());
            }
            for (String include : fileSet.includes) {
                if (include.contains("*")) {
                    String toMatch;
                    int starCount = include.length() - include.replace("*", "").length();
                    if (starCount > 1) {
                        this.warn("\t[FileSet]: More than one asterisk (*) found in include, skipping... | " + (String)include);
                        continue;
                    }
                    if (include.startsWith("*")) {
                        toMatch = include.substring(1);
                        for (File entry : entries) {
                            if (!entry.getName().endsWith(toMatch)) continue;
                            matchedEntries.add(entry);
                        }
                    } else if (include.endsWith("*")) {
                        toMatch = include.substring(0, include.length() - 1);
                        for (File entry : entries) {
                            if (!entry.getName().startsWith(toMatch)) continue;
                            matchedEntries.add(entry);
                        }
                    } else {
                        String[] split = include.split("\\*");
                        for (File entry : entries) {
                            if (!entry.getName().startsWith(split[0]) || !entry.getName().endsWith(split[1])) continue;
                            matchedEntries.add(entry);
                        }
                    }
                } else {
                    matchedEntries.add(new File(directory, include));
                }
                if (!matchedEntries.isEmpty()) {
                    for (File entry : matchedEntries) {
                        this.addToJar(outputDirectory + entry.getName(), new FileInputStream(entry), jar);
                        this.info("\t[FileSet]: Embedded " + outputDirectory + entry.getName() + " from " + directory);
                    }
                    continue;
                }
                this.warn("\t[FileSet]: No matches found in " + directory);
            }
        }
    }

    private void addDependencySets(JarOutputStream jar) throws IOException {
        if (this.dependencySets == null) {
            return;
        }
        for (DependencySet dependencySet : this.dependencySets) {
            Artifact artifact = this.toArtifact(this.resolve(dependencySet.toString()));
            if (artifact == null || artifact.getFile() == null) {
                this.warn("\t[DependencySet]: Resolution Fail | " + dependencySet.toString());
                continue;
            }
            JarFile jarFile = new JarFile(artifact.getFile());
            Set<JarEntry> entries = CapsuleMojo.set(jarFile.entries());
            String outputDirectory = this.addDirectoryToJar(jar, dependencySet.outputDirectory);
            if (dependencySet.includes != null && dependencySet.includes.length > 0) {
                HashSet<ZipEntry> matchedEntries = new HashSet<ZipEntry>();
                for (String include : dependencySet.includes) {
                    if (include.contains("*")) {
                        String toMatch;
                        int starCount = include.length() - include.replace("*", "").length();
                        if (starCount > 1) {
                            this.warn("\t[DependencySet]: More than one asterisk (*) found in include, skipping... | " + include);
                            continue;
                        }
                        if (include.startsWith("*")) {
                            toMatch = include.substring(1);
                            for (ZipEntry zipEntry : entries) {
                                if (!zipEntry.getName().endsWith(toMatch)) continue;
                                matchedEntries.add(zipEntry);
                            }
                            continue;
                        }
                        if (include.endsWith("*")) {
                            toMatch = include.substring(0, include.length() - 1);
                            for (ZipEntry zipEntry : entries) {
                                if (!zipEntry.getName().startsWith(toMatch)) continue;
                                matchedEntries.add(zipEntry);
                            }
                            continue;
                        }
                        String[] split = include.split("\\*");
                        for (ZipEntry zipEntry : entries) {
                            if (!zipEntry.getName().startsWith(split[0]) || !zipEntry.getName().endsWith(split[1])) continue;
                            matchedEntries.add(zipEntry);
                        }
                        continue;
                    }
                    matchedEntries.add(jarFile.getEntry(include));
                }
                if (!matchedEntries.isEmpty()) {
                    for (ZipEntry entry : matchedEntries) {
                        this.addToJar(outputDirectory + entry.getName(), jarFile.getInputStream(entry), jar);
                        this.info("\t[DependencySet]: Embedded from " + CapsuleMojo.coords(artifact) + " > " + outputDirectory + entry.getName());
                    }
                    continue;
                }
                this.warn("\t[DependencySet]: No matches found in " + artifact.getFile());
                continue;
            }
            if (!dependencySet.unpack) {
                this.info("\t[DependencySet]: Adding " + artifact.getFile().getName() + " to " + outputDirectory);
                this.addToJar(outputDirectory + artifact.getFile().getName(), new FileInputStream(artifact.getFile()), jar);
                continue;
            }
            if (artifact.getType() != null && artifact.getType().equals("jar")) {
                this.info("\t[DependencySet]: Adding (unpacked) " + artifact.getFile().getName() + " to " + outputDirectory);
                for (ZipEntry zipEntry : entries) {
                    this.debug("\t\t[DependencySet]: Adding (unpacked) " + outputDirectory + zipEntry.getName());
                    this.addToJar(outputDirectory + zipEntry.getName(), jarFile.getInputStream(zipEntry), jar);
                }
                continue;
            }
            this.warn("\t[DependencySet]: Cannot unpack " + artifact.getFile().getName() + " as it is not in jar format.");
        }
    }

    private void addChmodCopy(File jar) throws IOException {
        if (this.chmod) {
            File file = this.createExecCopyProcess(jar, EXEC_PREFIX, ".x");
            this.info("[Capsule CHMOD]: " + file.getName());
        }
    }

    private void addTrampolineCopy(File jar) throws IOException {
        if (this.trampoline) {
            File file = this.createExecCopyProcess(jar, EXEC_TRAMPOLINE_PREFIX, ".tx");
            this.info("[Capsule Trampoline]: " + file.getName());
        }
    }

    private String buildInfoString() {
        StringBuilder builder = new StringBuilder();
        if (this.includeApp) {
            builder.append("includeApp ");
        }
        if (this.includeAppDep) {
            builder.append("includeAppDep ");
        }
        if (this.includePluginDep) {
            builder.append("includePluginDep ");
        }
        if (this.includeCompileDep) {
            builder.append("includeCompileDep ");
        }
        if (this.includeRuntimeDep) {
            builder.append("includeRuntimeDep ");
        }
        if (this.includeProvidedDep) {
            builder.append("includeProvidedDep ");
        }
        if (this.includeSystemDep) {
            builder.append("includeSystemDep ");
        }
        if (this.includeTestDep) {
            builder.append("includeTestDep ");
        }
        if (this.includeTransitiveDep) {
            builder.append("includeTransitiveDep ");
        }
        if (this.resolveApp) {
            builder.append("resolveApp ");
        }
        if (this.resolveAppDep) {
            builder.append("resolveAppDep ");
        }
        if (this.resolvePluginDep) {
            builder.append("resolvePluginDep ");
        }
        if (this.resolveCompileDep) {
            builder.append("resolveCompileDep ");
        }
        if (this.resolveRuntimeDep) {
            builder.append("resolveRuntimeDep ");
        }
        if (this.resolveProvidedDep) {
            builder.append("resolveProvidedDep ");
        }
        if (this.resolveSystemDep) {
            builder.append("resolveSystemDep ");
        }
        if (this.resolveTestDep) {
            builder.append("resolveTestDep ");
        }
        if (this.resolveTransitiveDep) {
            builder.append("resolveTransitiveDep ");
        }
        return builder.toString().trim();
    }

    private String repoString() {
        StringBuilder repoList = new StringBuilder();
        for (RemoteRepository repository : this.remoteRepos) {
            repoList.append(repository.getId()).append("(").append(repository.getUrl()).append(") ");
        }
        return repoList.toString();
    }

    private String artifactString() throws IOException {
        StringBuilder artifactList = new StringBuilder();
        if (this.includeApp) {
            artifactList.append(CapsuleMojo.coords(this.project.getArtifact())).append(" ");
        }
        Set<Dependency> dependencies = this.includeTransitiveDep ? this.includedDependencies() : this.includedDirectDependencies();
        for (Dependency dependency : dependencies) {
            String scope = dependency.getScope() == null || dependency.getScope().isEmpty() ? "compile" : dependency.getScope();
            boolean optionalMatch = true;
            if (dependency.isOptional()) {
                optionalMatch = this.includeOptionalDep;
            }
            if (dependency.getGroupId().equalsIgnoreCase(CAPSULE_GROUP) && dependency.getArtifactId().equalsIgnoreCase(DEFAULT_CAPSULE_NAME) || !(this.includeCompileDep && scope.equals("compile") && optionalMatch || this.includeRuntimeDep && scope.equals("runtime") && optionalMatch || this.includeProvidedDep && scope.equals("provided") && optionalMatch || this.includeSystemDep && scope.equals("system") && optionalMatch) && (!this.includeTestDep || !scope.equals("test") || !optionalMatch)) continue;
            artifactList.append(CapsuleMojo.coordsWithExclusions(dependency)).append(" ");
        }
        return artifactList.toString();
    }

    private String dependencyString() throws IOException {
        StringBuilder dependenciesList = new StringBuilder();
        if (this.resolveApp) {
            dependenciesList.append(CapsuleMojo.coords(this.project.getArtifact())).append(" ");
        }
        Set<Dependency> dependencies = this.resolveTransitiveDep ? this.resolvedDependencies() : this.resolvedDirectDependencies();
        for (Dependency dependency : dependencies) {
            String scope = dependency.getScope() == null || dependency.getScope().isEmpty() ? "compile" : dependency.getScope();
            boolean optionalMatch = true;
            if (dependency.isOptional()) {
                optionalMatch = this.resolveOptionalDep;
            }
            if (dependency.getGroupId().equalsIgnoreCase(CAPSULE_GROUP) && dependency.getArtifactId().equalsIgnoreCase(DEFAULT_CAPSULE_NAME) || !(this.resolveCompileDep && scope.equals("compile") && optionalMatch || this.resolveRuntimeDep && scope.equals("runtime") && optionalMatch || this.resolveProvidedDep && scope.equals("provided") && optionalMatch || this.resolveSystemDep && scope.equals("system") && optionalMatch) && (!this.resolveTestDep || !scope.equals("test") || !optionalMatch)) continue;
            dependenciesList.append(CapsuleMojo.coordsWithExclusions(dependency)).append(" ");
        }
        return dependenciesList.toString();
    }

    private String systemPropertiesString() {
        StringBuilder propertiesList;
        block6: {
            Xpp3Dom[] propertiesElements;
            block5: {
                propertiesList = null;
                if (this.properties == null) break block5;
                propertiesList = new StringBuilder();
                for (Mojo.Pair<String, String> property : this.properties) {
                    if (property.key == null) continue;
                    propertiesList.append(property.key);
                    if (property.value != null && property.value instanceof String && !((String)property.value).isEmpty()) {
                        propertiesList.append("=").append(property.value);
                    }
                    propertiesList.append(" ");
                }
                break block6;
            }
            if (this.execConfig == null) break block6;
            propertiesList = new StringBuilder();
            Xpp3Dom propertiesElement = this.execConfig.getChild("systemProperties");
            if (propertiesElement != null && (propertiesElements = propertiesElement.getChildren()) != null && propertiesElements.length > 0) {
                for (Xpp3Dom propertyElement : propertiesElements) {
                    Xpp3Dom key = propertyElement.getChild("key");
                    Xpp3Dom value = propertyElement.getChild("value");
                    if (key == null || key.getValue() == null) continue;
                    propertiesList.append(key.getValue()).append("=");
                    if (value != null && value.getValue() != null && !value.getValue().isEmpty()) {
                        propertiesList.append("=").append(value.getValue());
                    }
                    propertiesList.append(" ");
                }
            }
        }
        return propertiesList == null ? null : propertiesList.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createExecCopyProcess(File jar, String prefix, String extension) throws IOException {
        File x = new File(jar.getPath().replace(".jar", extension));
        if (x.exists()) {
            this.debug("EXISTS - " + x.getName());
            return x;
        }
        FileOutputStream out = null;
        FileInputStream in = null;
        try {
            out = new FileOutputStream(x);
            in = new FileInputStream(jar);
            out.write(prefix.getBytes("ASCII"));
            Files.copy(jar.toPath(), out);
            out.flush();
            boolean execResult = x.setExecutable(true, false);
            if (!execResult) {
                this.warn("Failed to mark file executable - " + x.getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            IOUtil.close((OutputStream)out);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        IOUtil.close((OutputStream)out);
        return x;
    }

    private File resolveCapsule() throws IOException {
        if (this.resolvedCapsuleProjectFile == null) {
            ArtifactResult artifactResult = this.resolve(CAPSULE_GROUP, "capsule", null, this.capsuleVersion);
            if (artifactResult == null) {
                throw new IOException("Capsule not found from repos");
            }
            this.resolvedCapsuleProjectFile = artifactResult.getArtifact().getFile();
        }
        return this.resolvedCapsuleProjectFile;
    }

    private File resolveCapsuleMaven() throws IOException {
        if (this.resolvedCapsuleMavenProjectFile == null) {
            ArtifactResult artifactResult = this.resolve(CAPSULE_GROUP, "capsule-maven", null, this.capsuleMavenVersion);
            if (artifactResult == null) {
                throw new IOException("CapsuleMaven not found from repos");
            }
            this.resolvedCapsuleMavenProjectFile = artifactResult.getArtifact().getFile();
        }
        return this.resolvedCapsuleMavenProjectFile;
    }

    private Set<Dependency> includedDependencies() {
        return CapsuleMojo.cleanDependencies(this.appDependencies(), this.includeAppDep, this.pluginDependencies(), this.includePluginDep);
    }

    private Set<Dependency> includedDirectDependencies() {
        return CapsuleMojo.cleanDependencies(this.appDirectDependencies(), this.includeAppDep, this.pluginDirectDependencies(), this.includePluginDep);
    }

    private Set<Artifact> includedDependencyArtifacts() {
        return CapsuleMojo.cleanArtifacts(this.appDependencyArtifacts(), this.includeAppDep, this.pluginDependencyArtifacts(), this.includePluginDep);
    }

    private Set<Artifact> includedDirectDependencyArtifacts() {
        return CapsuleMojo.cleanArtifacts(this.appDirectDependencyArtifacts(), this.includeAppDep, this.pluginDirectDependencyArtifacts(), this.includePluginDep);
    }

    private Set<Dependency> resolvedDependencies() {
        return CapsuleMojo.cleanDependencies(this.appDependencies(), this.resolveAppDep, this.pluginDependencies(), this.resolvePluginDep);
    }

    private Set<Dependency> resolvedDirectDependencies() {
        return CapsuleMojo.cleanDependencies(this.appDirectDependencies(), this.resolveAppDep, this.pluginDirectDependencies(), this.resolvePluginDep);
    }

    public static class FileSet {
        public String directory;
        public String outputDirectory;
        public String[] includes;
    }

    public static class DependencySet {
        public String groupId;
        public String artifactId;
        public String classifier;
        public String version;
        public String outputDirectory = "/";
        public String[] includes;
        public boolean unpack = false;

        public String toString() {
            return Mojo.coords(this.groupId, this.artifactId, this.classifier, this.version);
        }
    }

    public static class Mode {
        private String name = null;
        private Mojo.Pair<String, String>[] properties = null;
        private Mojo.Pair<String, String>[] manifest = null;
    }

    public static enum Type {
        empty,
        thin,
        fat;

    }
}

