/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisdchristo.capsule;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultMavenProjectHelper;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;

public abstract class Mojo
extends AbstractMojo {
    @Component
    RepositorySystem repoSystem = null;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession = null;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    List<RemoteRepository> remoteRepos = null;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    String finalName = null;
    @Parameter(defaultValue="${project.build.directory}")
    File buildDir = null;
    @Parameter(defaultValue="${project.basedir}")
    File baseDir = null;
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project = null;
    final MavenProjectHelper helper = new DefaultMavenProjectHelper();

    abstract String pluginKey();

    abstract String logPrefix();

    Set<Dependency> appDependencies() {
        return Mojo.set(this.project.getTestDependencies());
    }

    Set<Dependency> appDirectDependencies() {
        return Mojo.set(this.project.getDependencies());
    }

    Set<org.apache.maven.artifact.Artifact> appDependencyArtifacts() {
        return this.project.getArtifacts();
    }

    Set<org.apache.maven.artifact.Artifact> appDirectDependencyArtifacts() {
        return this.project.getDependencyArtifacts();
    }

    Set<Dependency> pluginDependencies() {
        return this.getDependenciesOf(Mojo.set(this.plugin().getDependencies()), true);
    }

    Set<Dependency> pluginDirectDependencies() {
        return Mojo.set(this.plugin().getDependencies());
    }

    Set<org.apache.maven.artifact.Artifact> pluginDependencyArtifacts() {
        return this.getDependencyArtifactsOf(Mojo.set(this.plugin().getDependencies()), true);
    }

    Set<org.apache.maven.artifact.Artifact> pluginDirectDependencyArtifacts() {
        return this.toArtifacts(Mojo.set(this.plugin().getDependencies()));
    }

    private Plugin plugin() {
        return this.project.getPlugin(this.pluginKey());
    }

    private ArtifactResult resolve(Dependency dependency) {
        return this.resolve(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getVersion());
    }

    ArtifactResult resolve(String groupId, String artifactId, String classifier, String version) {
        return this.resolve(Mojo.coords(groupId, artifactId, classifier, version));
    }

    ArtifactResult resolve(String coords) {
        try {
            return this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest((Artifact)new DefaultArtifact(coords), this.remoteRepos, null));
        }
        catch (ArtifactResolutionException e) {
            this.warn("\t\t[Resolve] Failed to resolve: [" + coords + "]");
            return null;
        }
    }

    private Set<ArtifactResult> resolveDependencies(Dependency dependency) {
        try {
            CollectRequest collectRequest = new CollectRequest(new org.eclipse.aether.graph.Dependency(this.resolve(dependency).getArtifact(), ""), this.remoteRepos);
            return Mojo.set(this.repoSystem.resolveDependencies(this.repoSession, new DependencyRequest(collectRequest, null)).getArtifactResults());
        }
        catch (DependencyResolutionException e) {
            this.warn("\t\t[Resolve] Failed to resolve: [" + Mojo.coords(dependency) + "]");
            return new HashSet<ArtifactResult>();
        }
    }

    org.apache.maven.artifact.Artifact toArtifact(ArtifactResult ar) {
        if (ar == null) {
            return null;
        }
        org.apache.maven.artifact.DefaultArtifact artifact = new org.apache.maven.artifact.DefaultArtifact(ar.getArtifact().getGroupId(), ar.getArtifact().getArtifactId(), ar.getArtifact().getVersion(), null, "jar", ar.getArtifact().getClassifier(), null);
        if (ar.getRequest().getDependencyNode() != null && ar.getRequest().getDependencyNode().getDependency() != null) {
            artifact.setScope(ar.getRequest().getDependencyNode().getDependency().getScope());
            artifact.setOptional(ar.getRequest().getDependencyNode().getDependency().isOptional());
        }
        if (artifact.getScope() == null || artifact.getScope().isEmpty()) {
            artifact.setScope("compile");
        }
        artifact.setFile(ar.getArtifact().getFile());
        return artifact;
    }

    private org.apache.maven.artifact.Artifact toArtifact(Dependency dependency) {
        if (dependency == null) {
            return null;
        }
        org.apache.maven.artifact.Artifact artifact = this.toArtifact(this.resolve(dependency));
        artifact.setScope(dependency.getScope());
        if (artifact.getScope() == null || artifact.getScope().isEmpty()) {
            artifact.setScope("compile");
        }
        return artifact;
    }

    private Dependency toDependency(org.apache.maven.artifact.Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifact.getGroupId());
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setVersion(artifact.getVersion());
        dependency.setScope(artifact.getScope());
        dependency.setClassifier(artifact.getClassifier());
        dependency.setOptional(artifact.isOptional());
        if (dependency.getScope() == null || dependency.getScope().isEmpty()) {
            dependency.setScope("compile");
        }
        return dependency;
    }

    private Dependency toDependency(ArtifactResult ar) {
        return this.toDependency(this.toArtifact(ar));
    }

    private Set<org.apache.maven.artifact.Artifact> getDependencyArtifactsOf(Dependency dependency, boolean includeRoot) {
        HashSet<org.apache.maven.artifact.Artifact> artifacts = new HashSet<org.apache.maven.artifact.Artifact>();
        if (includeRoot) {
            artifacts.add(this.toArtifact(dependency));
        }
        for (ArtifactResult ar : this.resolveDependencies(dependency)) {
            org.apache.maven.artifact.Artifact artifact = this.toArtifact(ar);
            if (artifact.getScope() == null || artifact.getScope().isEmpty()) {
                artifact.setScope("compile");
            }
            if (!artifact.getScope().equals("compile") && !artifact.getScope().equals("runtime")) continue;
            if (dependency.getScope().equals("provided")) {
                artifact.setScope("provided");
            }
            if (dependency.getScope().equals("system")) {
                artifact.setScope("system");
            }
            if (dependency.getScope().equals("test")) {
                artifact.setScope("test");
            }
            artifacts.add(this.toArtifact(ar));
        }
        return Mojo.cleanArtifacts(artifacts);
    }

    private Set<org.apache.maven.artifact.Artifact> getDependencyArtifactsOf(Set<Dependency> dependencies, boolean includeRoot) {
        HashSet<org.apache.maven.artifact.Artifact> artifacts = new HashSet<org.apache.maven.artifact.Artifact>();
        for (Dependency dependency : dependencies) {
            artifacts.addAll(this.getDependencyArtifactsOf(dependency, includeRoot));
        }
        return Mojo.cleanArtifacts(artifacts);
    }

    private Set<Dependency> getDependenciesOf(Dependency dependency, boolean includeRoot) {
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        if (includeRoot) {
            dependencies.add(dependency);
        }
        for (ArtifactResult ar : this.resolveDependencies(dependency)) {
            dependencies.add(this.toDependency(ar));
        }
        return Mojo.cleanDependencies(dependencies);
    }

    private Set<Dependency> getDependenciesOf(Set<Dependency> dependencies, boolean includeRoot) {
        HashSet<Dependency> dependenciesAll = new HashSet<Dependency>();
        for (Dependency dependency : dependencies) {
            dependenciesAll.addAll(this.getDependenciesOf(dependency, includeRoot));
        }
        return Mojo.cleanDependencies(dependenciesAll);
    }

    private Set<org.apache.maven.artifact.Artifact> toArtifacts(Set<Dependency> dependencies) {
        HashSet<org.apache.maven.artifact.Artifact> artifacts = new HashSet<org.apache.maven.artifact.Artifact>();
        for (Dependency dependency : dependencies) {
            artifacts.add(this.toArtifact(dependency));
        }
        return Mojo.cleanArtifacts(artifacts);
    }

    String addDirectoryToJar(JarOutputStream jar, String outputDirectory) throws IOException {
        String formattedOutputDirectory = "";
        if (outputDirectory != null && !outputDirectory.isEmpty()) {
            formattedOutputDirectory = !outputDirectory.endsWith("/") ? outputDirectory + File.separatorChar : outputDirectory;
        }
        if (!formattedOutputDirectory.isEmpty()) {
            try {
                jar.putNextEntry(new ZipEntry(formattedOutputDirectory));
                jar.closeEntry();
            }
            catch (ZipException zipException) {
                // empty catch block
            }
        }
        return formattedOutputDirectory;
    }

    JarOutputStream addToJar(String name, InputStream input, JarOutputStream jar) throws IOException {
        try {
            this.debug("\t[Added to Jar]: " + name);
            jar.putNextEntry(new ZipEntry(name));
            IOUtil.copy((InputStream)input, (OutputStream)jar);
            jar.closeEntry();
        }
        catch (ZipException zipException) {
            // empty catch block
        }
        IOUtil.close((InputStream)input);
        return jar;
    }

    void debug(String message) {
        this.getLog().debug((CharSequence)(this.logPrefix() + message));
    }

    void info(String message) {
        this.getLog().info((CharSequence)(this.logPrefix() + message));
    }

    void warn(String message) {
        this.getLog().warn((CharSequence)(this.logPrefix() + message));
    }

    void printManifest(Manifest manifest) {
        this.info("\t[Manifest]:");
        for (Map.Entry<Object, Object> entry : manifest.getMainAttributes().entrySet()) {
            this.info("\t\t" + entry.getKey().toString() + ": " + entry.getValue().toString());
        }
        for (Map.Entry<Object, Object> entry : manifest.getEntries().entrySet()) {
            this.info("");
            this.info("\t\tName:" + (String)entry.getKey());
            for (Map.Entry<Object, Object> attr : ((Attributes)entry.getValue()).entrySet()) {
                this.info("\t\t" + attr.getKey().toString() + ": " + attr.getValue().toString());
            }
        }
    }

    static <T> Set<T> set(List<T> list) {
        return new HashSet<T>(list);
    }

    static <T> Set<T> set(Enumeration<T> enumeration) {
        HashSet<T> set = new HashSet<T>();
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    static String coords(String groupId, String artifactId, String classifier, String version) {
        StringBuilder coords = new StringBuilder();
        coords.append(groupId).append(":").append(artifactId);
        if (classifier != null && !classifier.isEmpty()) {
            coords.append(":").append(classifier);
        }
        if (version != null && !version.isEmpty()) {
            coords.append(":").append(version);
        }
        return coords.toString();
    }

    static String coords(org.apache.maven.artifact.Artifact artifact) {
        return Mojo.coords(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getVersion());
    }

    static String coords(Dependency dependency) {
        return Mojo.coords(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getVersion());
    }

    static String coordsWithExclusions(Dependency dependency) {
        StringBuilder coords = new StringBuilder(Mojo.coords(dependency));
        if (dependency.getExclusions().size() > 0) {
            StringBuilder exclusionsList = new StringBuilder();
            int i = 0;
            for (Exclusion exclusion : dependency.getExclusions()) {
                if (i > 0) {
                    exclusionsList.append(",");
                }
                exclusionsList.append(exclusion.getGroupId()).append(":").append(exclusion.getArtifactId());
                ++i;
            }
            coords.append("(").append(exclusionsList.toString()).append(")");
        }
        return coords.toString();
    }

    static Set<Dependency> cleanDependencies(Set<Dependency> dependencies) {
        HashSet<Dependency> dependenciesClean = new HashSet<Dependency>();
        for (Dependency dependencyA : dependencies) {
            boolean found = false;
            for (Dependency dependencyB : dependenciesClean) {
                if (!Mojo.coords(dependencyA).equals(Mojo.coords(dependencyB))) continue;
                found = true;
                break;
            }
            if (found) continue;
            dependenciesClean.add(dependencyA);
        }
        return dependenciesClean;
    }

    static Set<org.apache.maven.artifact.Artifact> cleanArtifacts(Set<org.apache.maven.artifact.Artifact> artifacts) {
        HashSet<org.apache.maven.artifact.Artifact> artifactsClean = new HashSet<org.apache.maven.artifact.Artifact>();
        for (org.apache.maven.artifact.Artifact artifactA : artifacts) {
            boolean found = false;
            for (org.apache.maven.artifact.Artifact artifactB : artifactsClean) {
                if (!Mojo.coords(artifactA).equals(Mojo.coords(artifactB))) continue;
                found = true;
                break;
            }
            if (found) continue;
            artifactsClean.add(artifactA);
        }
        return artifactsClean;
    }

    static Set<Dependency> cleanDependencies(Set<Dependency> setA, boolean includeA, Set<Dependency> setB, boolean includeB) {
        HashSet<Dependency> set = new HashSet<Dependency>();
        if (includeA) {
            set.addAll(setA);
        }
        if (includeB) {
            set.addAll(setB);
        }
        return Mojo.cleanDependencies(set);
    }

    static Set<org.apache.maven.artifact.Artifact> cleanArtifacts(Set<org.apache.maven.artifact.Artifact> setA, boolean includeA, Set<org.apache.maven.artifact.Artifact> setB, boolean includeB) {
        HashSet<org.apache.maven.artifact.Artifact> set = new HashSet<org.apache.maven.artifact.Artifact>();
        if (includeA) {
            set.addAll(setA);
        }
        if (includeB) {
            set.addAll(setB);
        }
        return Mojo.cleanArtifacts(set);
    }

    public static class Pair<K, V> {
        public K key;
        public V value;

        public Pair() {
        }

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

