/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.behaim.builder;

import com.github.chrisgleissner.behaim.Behaim;
import com.github.chrisgleissner.behaim.BehaimException;
import com.github.chrisgleissner.behaim.builder.config.Config;
import com.github.chrisgleissner.behaim.builder.producer.Producer;
import com.github.chrisgleissner.behaim.builder.producer.ProducerFactory;
import com.github.chrisgleissner.behaim.builder.producer.ProducerVisitor;
import com.github.chrisgleissner.behaim.builder.producer.ProducerVisitorContext;
import com.github.chrisgleissner.behaim.explorer.Explorer;
import com.github.chrisgleissner.behaim.route.Route;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Builder<T> {
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    private static final Logger logger = LoggerFactory.getLogger(Behaim.class);
    private Config config;
    private final ProducerFactory<T> producerFactory = new ProducerFactory();
    private Route route;
    private Class<T> type;

    public Builder(Class<T> type) {
        this(type, Config.DEFAULT_CONFIG);
    }

    public Builder(Class<T> type, Config config) {
        this.type = type;
        this.config = config;
    }

    public T build() {
        return this.build(1).iterator().next();
    }

    public Collection<T> build(int numberOfInstances) {
        ArrayList<T> instances = new ArrayList<T>(numberOfInstances);
        instances.add(this.explore());
        if (numberOfInstances > 1) {
            instances.addAll(this.revisit(numberOfInstances - 1));
        }
        return instances;
    }

    private T explore() {
        T t;
        ProducerVisitorContext producerVisitorContext = new ProducerVisitorContext(this.config);
        ProducerVisitor visitor = new ProducerVisitor(producerVisitorContext);
        Explorer explorer = new Explorer(visitor, this.config.getRecursionDepth());
        try {
            t = this.type.newInstance();
        }
        catch (Exception e) {
            throw new BehaimException("Could not instantiate " + this.type, e);
        }
        this.route = explorer.explore(t);
        logger.trace("Exploration discovered route:\n{}", (Object)this.route);
        return t;
    }

    private Collection<T> revisit(int numberOfInstances) {
        try {
            Object instances = new ArrayList(numberOfInstances);
            List<Producer<T>> producers = this.producerFactory.createProducers(this.type, this.config, this.route, numberOfInstances);
            if (producers.size() > 1) {
                for (Future<T> future : executorService.invokeAll(producers)) {
                    instances.addAll((Collection)future.get());
                }
            } else {
                instances = producers.iterator().next().call();
            }
            return instances;
        }
        catch (Exception e) {
            throw new BehaimException("Population for instances of type " + this.type.getName() + " failed", e);
        }
    }
}

