/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.behaim.builder.adapter;

import com.github.chrisgleissner.behaim.BehaimException;
import com.github.chrisgleissner.behaim.builder.adapter.BigDecimalAdapter;
import com.github.chrisgleissner.behaim.builder.adapter.BigIntegerAdapter;
import com.github.chrisgleissner.behaim.builder.adapter.BooleanAdapter;
import com.github.chrisgleissner.behaim.builder.adapter.DateAdapter;
import com.github.chrisgleissner.behaim.builder.adapter.DoubleAdapter;
import com.github.chrisgleissner.behaim.builder.adapter.FloatAdapter;
import com.github.chrisgleissner.behaim.builder.adapter.IntegerAdapter;
import com.github.chrisgleissner.behaim.builder.adapter.LongAdapter;
import com.github.chrisgleissner.behaim.builder.adapter.SeedAdapter;
import com.github.chrisgleissner.behaim.builder.adapter.StringAdapter;
import java.util.ArrayList;
import java.util.Collection;

public class AdapterRegistry {
    private static final Class[] SEED_ADAPTER_CLASSES = new Class[]{BigDecimalAdapter.class, BigIntegerAdapter.class, BooleanAdapter.class, DateAdapter.class, DoubleAdapter.class, FloatAdapter.class, IntegerAdapter.class, LongAdapter.class, StringAdapter.class};

    public Collection<SeedAdapter> getSeedAdapters() {
        ArrayList<SeedAdapter> seedAdapters = new ArrayList<SeedAdapter>();
        for (Class seedAdapterClass : SEED_ADAPTER_CLASSES) {
            try {
                seedAdapters.add((SeedAdapter)seedAdapterClass.newInstance());
            }
            catch (Exception e) {
                throw new BehaimException("Could not instantiate seed adapter " + seedAdapterClass, e);
            }
        }
        return seedAdapters;
    }
}

