/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.behaim.builder.adapter;

import com.github.chrisgleissner.behaim.builder.adapter.AbstractSeedAdapter;
import com.github.chrisgleissner.behaim.builder.adapter.SeedAdapter;
import com.github.chrisgleissner.behaim.builder.seeder.Seeder;

public class EnumAdapter<E extends Enum<E>>
extends AbstractSeedAdapter<E> {
    private final Class<E> enumClass;

    public EnumAdapter(Class<E> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public E convert(Seeder seeder) {
        Enum[] enumValues = (Enum[])this.enumClass.getEnumConstants();
        if (enumValues.length == 0) {
            return null;
        }
        if (enumValues.length == 1) {
            return (E)enumValues[0];
        }
        return (E)enumValues[seeder.createIntSeed()];
    }

    @Override
    public Class<E> getValueClass() {
        return this.enumClass;
    }

    public static <E extends Enum<E>> SeedAdapter<E> forClass(Class<E> enumClass) {
        return new EnumAdapter<E>(enumClass);
    }
}

