/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.behaim.builder.adapter;

import com.github.chrisgleissner.behaim.builder.adapter.AbstractSeedAdapter;
import com.github.chrisgleissner.behaim.builder.config.FieldConfig;
import com.github.chrisgleissner.behaim.builder.seeder.Seeder;
import java.util.Random;

public class StringAdapter
extends AbstractSeedAdapter<String> {
    private final String CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private final Random random = new Random();

    @Override
    public String convert(Seeder seeder) {
        FieldConfig fieldConfig = seeder.getConfig();
        int length = this.random.nextInt(fieldConfig.getMaxLength() - fieldConfig.getMinLength()) + fieldConfig.getMinLength();
        StringBuilder sb = new StringBuilder(length);
        long seed = (long)seeder.createSeed();
        if (seed < 0L) {
            seed *= -1L;
        }
        long initialSeed = seed;
        for (int i = 0; i < length; ++i) {
            int charIndex = (int)(seed % (long)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length());
            sb.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt(charIndex));
            if ((seed /= (long)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length()) != 0L) continue;
            seed = initialSeed;
        }
        return sb.toString();
    }

    @Override
    public Class<String> getValueClass() {
        return String.class;
    }
}

