/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.behaim.builder.config;

import com.github.chrisgleissner.behaim.builder.config.FieldConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Config {
    private static final int DEFAULT_BATCH_SIZE = 1;
    private static final int DEFAULT_RECURSION_DEPTH = 2;
    public static final Config DEFAULT_CONFIG = new Config();
    private final int batchSize;
    private final int recursionDepth;
    private final List<String> excludedClassNames = new ArrayList<String>();
    private final Map<String, FieldConfig> fieldConfigs;
    private final FieldConfig globalFieldConfig = new FieldConfig();

    public Config() {
        this(1, 2, null);
    }

    public Config(int batchSize) {
        this(batchSize, 2, null);
    }

    public Config(int batchSize, int recursionDepth) {
        this(batchSize, recursionDepth, null);
    }

    public Config(int batchSize, int recursionDepth, Map<String, FieldConfig> fieldConfigs) {
        this.batchSize = batchSize;
        this.recursionDepth = recursionDepth;
        this.fieldConfigs = fieldConfigs != null ? fieldConfigs : new HashMap();
        this.excludedClassNames.add("java");
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public List<String> getExcludedClassNames() {
        return this.excludedClassNames;
    }

    public FieldConfig getFieldConfigFor(String fieldName) {
        FieldConfig fieldConfig = this.fieldConfigs.get(fieldName);
        if (fieldConfig == null) {
            fieldConfig = this.globalFieldConfig;
        }
        return fieldConfig;
    }

    public Map<String, FieldConfig> getFieldConfigs() {
        return this.fieldConfigs;
    }

    public int getRecursionDepth() {
        return this.recursionDepth;
    }
}

