/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.behaim.builder.producer;

import com.github.chrisgleissner.behaim.explorer.Visitor;
import com.github.chrisgleissner.behaim.route.Route;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public final class Producer<T>
implements Callable<List<T>> {
    private final int numberOfInstances;
    private final Route route;
    private final Class<T> type;
    private final Visitor visitor;

    public Producer(Route route, Visitor visitor, Class<T> type, int numberOfInstances) {
        this.numberOfInstances = numberOfInstances;
        this.type = type;
        this.route = route;
        this.visitor = visitor;
    }

    @Override
    public List<T> call() throws Exception {
        ArrayList<T> instances = new ArrayList<T>(this.numberOfInstances);
        for (int i = 0; i < this.numberOfInstances; ++i) {
            T t = this.type.newInstance();
            this.route.prepareTrip(t, this.visitor).perform();
            instances.add(t);
        }
        return instances;
    }
}

