/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.behaim.builder.producer;

import com.github.chrisgleissner.behaim.builder.config.Config;
import com.github.chrisgleissner.behaim.builder.producer.Producer;
import com.github.chrisgleissner.behaim.builder.producer.ProducerVisitor;
import com.github.chrisgleissner.behaim.builder.producer.ProducerVisitorContext;
import com.github.chrisgleissner.behaim.route.Route;
import java.util.ArrayList;
import java.util.List;

public class ProducerFactory<T> {
    private static final int MIN_NUMBER_OF_INSTANCES_FOR_CONCURRENT_PRODUCTION = 200;

    public List<Producer<T>> createProducers(Class<T> type, Config config, Route route, int numberOfInstances) {
        ArrayList<Producer<T>> producers = new ArrayList<Producer<T>>();
        ProducerVisitorContext producerVisitorContext = new ProducerVisitorContext(config);
        ProducerVisitor visitor = new ProducerVisitor(producerVisitorContext);
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int numberOfInstancesPerProducer = numberOfInstances;
        if (numberOfInstances > 200) {
            numberOfInstancesPerProducer = numberOfInstances / availableProcessors;
            for (int i = 0; i < availableProcessors; ++i) {
                int instances = numberOfInstancesPerProducer;
                if (i == availableProcessors - 1) {
                    instances += numberOfInstances - availableProcessors * numberOfInstancesPerProducer;
                }
                producers.add(new Producer<T>(route, visitor, type, numberOfInstancesPerProducer));
            }
        } else {
            producers.add(new Producer<T>(route, visitor, type, numberOfInstances));
        }
        return producers;
    }
}

