/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.behaim.builder.producer;

import com.github.chrisgleissner.behaim.builder.adapter.SeedAdapter;
import com.github.chrisgleissner.behaim.builder.producer.ProducerFieldContext;
import com.github.chrisgleissner.behaim.builder.producer.ProducerVisitorContext;
import com.github.chrisgleissner.behaim.builder.seeder.Seeder;
import com.github.chrisgleissner.behaim.explorer.FieldUtil;
import com.github.chrisgleissner.behaim.explorer.VisitationResult;
import com.github.chrisgleissner.behaim.explorer.Visitor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerVisitor
implements Visitor {
    private static final Map<Class<?>, Class<?>> CONCRETE_COLLECTION_CLASSES = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(ProducerVisitor.class);
    private final ProducerVisitorContext context;

    public ProducerVisitor(ProducerVisitorContext producerVisitorContext) {
        this.context = producerVisitorContext;
    }

    private CreationResult createObjectFor(Field field) {
        Object fieldValue = null;
        Class elementClass = null;
        int collectionSize = 3;
        try {
            if (this.isCollection(field)) {
                Class collectionSubclass = this.getConcreteCollectionClassFor(field.getType());
                if (collectionSubclass != null) {
                    Collection collection = (Collection)collectionSubclass.newInstance();
                    elementClass = this.getCollectionParameter(field);
                    for (int i = 0; i < collectionSize; ++i) {
                        collection.add(elementClass.newInstance());
                    }
                    fieldValue = collection;
                }
            } else if (this.isArray(field)) {
                Object[] array = new Object[collectionSize];
                Class<?> elementType = field.getType().getComponentType();
                for (int i = 0; i < collectionSize; ++i) {
                    array[i] = elementType.newInstance();
                }
                fieldValue = array;
            } else if (!field.getType().isEnum()) {
                fieldValue = field.getType().newInstance();
            }
        }
        catch (Exception e) {
            logger.warn("Could not instantiate field", (Object)FieldUtil.getNameAndTypeFor(field), (Object)e);
        }
        return new CreationResult(fieldValue, elementClass);
    }

    private Class getCollectionParameter(Field field) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        Class fieldParameterClass = null;
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()) != null && actualTypeArguments.length >= 1) {
            fieldParameterClass = (Class)actualTypeArguments[0];
        }
        return fieldParameterClass;
    }

    private Class getConcreteCollectionClassFor(Class<?> clazz) {
        Class<?> subclass = CONCRETE_COLLECTION_CLASSES.get(clazz);
        if (subclass == null && !Modifier.isAbstract(clazz.getModifiers()) && !Modifier.isInterface(clazz.getModifiers())) {
            subclass = clazz;
        }
        return subclass;
    }

    private boolean isArray(Field field) {
        return field.getType().isArray();
    }

    private boolean isClassExcluded(Class clazz) {
        boolean excluded = false;
        String className = clazz.getName();
        for (String excludedClassName : this.context.getConfig().getExcludedClassNames()) {
            if (!className.startsWith(excludedClassName)) continue;
            excluded = true;
            break;
        }
        return excluded;
    }

    private boolean isCollection(Field field) {
        return Collection.class.isAssignableFrom(field.getType());
    }

    @Override
    public VisitationResult visit(Object object, Field field) {
        Object fieldValue = null;
        Class<?> fieldClass = field.getType();
        ProducerFieldContext fieldContext = this.context.getFieldContextFor(field);
        Seeder seeder = fieldContext.getSeeder();
        SeedAdapter<?> seedAdapter = this.context.getSeedAdapterFor(field);
        boolean visitOfValueRequired = true;
        if (seedAdapter != null) {
            fieldValue = seedAdapter.convert(seeder);
            boolean bl = visitOfValueRequired = !this.isClassExcluded(fieldClass);
        }
        if (fieldValue == null) {
            CreationResult creationResult = this.createObjectFor(field);
            fieldValue = creationResult.createdObject;
        }
        try {
            field.setAccessible(true);
            field.set(object, fieldValue);
        }
        catch (Exception e) {
            logger.warn("Could not set " + FieldUtil.getNameFor(field) + "=" + fieldValue + " provided by " + seedAdapter + " on " + object, (Throwable)e);
        }
        return new VisitationResult(fieldContext, fieldValue, visitOfValueRequired);
    }

    static {
        CONCRETE_COLLECTION_CLASSES.put(Collection.class, ArrayList.class);
        CONCRETE_COLLECTION_CLASSES.put(List.class, ArrayList.class);
        CONCRETE_COLLECTION_CLASSES.put(Set.class, HashSet.class);
        CONCRETE_COLLECTION_CLASSES.put(Queue.class, ArrayBlockingQueue.class);
    }

    private static final class CreationResult {
        private final Object createdObject;
        private final Class elementClass;

        public CreationResult(Object createdObject, Class elementClass) {
            this.createdObject = createdObject;
            this.elementClass = elementClass;
        }
    }
}

