/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.behaim.builder.producer;

import com.github.chrisgleissner.behaim.builder.adapter.AdapterRegistry;
import com.github.chrisgleissner.behaim.builder.adapter.EnumAdapter;
import com.github.chrisgleissner.behaim.builder.adapter.SeedAdapter;
import com.github.chrisgleissner.behaim.builder.config.Config;
import com.github.chrisgleissner.behaim.builder.config.FieldConfig;
import com.github.chrisgleissner.behaim.builder.producer.ProducerFieldContext;
import com.github.chrisgleissner.behaim.builder.producer.TypeUtil;
import com.github.chrisgleissner.behaim.builder.seeder.Seeder;
import com.github.chrisgleissner.behaim.builder.seeder.SeederFactory;
import com.github.chrisgleissner.behaim.explorer.FieldUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ProducerVisitorContext {
    private final Config config;
    private final ConcurrentMap<Field, ProducerFieldContext> producerFieldContexts = new ConcurrentHashMap<Field, ProducerFieldContext>();
    private final Map<Class, SeedAdapter> seedAdapters = new HashMap<Class, SeedAdapter>();
    private final SeederFactory seederFactory = new SeederFactory();

    public ProducerVisitorContext() {
        this(Config.DEFAULT_CONFIG);
    }

    public ProducerVisitorContext(Config config) {
        this.config = config;
        AdapterRegistry valueFactoryRegistry = new AdapterRegistry();
        for (SeedAdapter seedAdapter : valueFactoryRegistry.getSeedAdapters()) {
            this.seedAdapters.put(seedAdapter.getValueClass(), seedAdapter);
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public ProducerFieldContext getFieldContextFor(Field field) {
        ProducerFieldContext producerFieldContext = (ProducerFieldContext)this.producerFieldContexts.get(field);
        if (producerFieldContext == null) {
            Seeder seeder;
            ProducerFieldContext existingFieldContext;
            FieldConfig fieldConfig = this.config.getFieldConfigFor(FieldUtil.getNameFor(field));
            if (field.getType().isEnum()) {
                int maxValue = field.getType().getEnumConstants().length;
                fieldConfig = new FieldConfig(fieldConfig.isRandom(), 0, maxValue, 0, 0);
            }
            if ((existingFieldContext = this.producerFieldContexts.putIfAbsent(field, producerFieldContext = new ProducerFieldContext(field, seeder = this.seederFactory.createSeeder(fieldConfig)))) != null) {
                producerFieldContext = existingFieldContext;
            }
        }
        return producerFieldContext;
    }

    public SeedAdapter<?> getSeedAdapterFor(Field field) {
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            type = TypeUtil.wrap(type);
        }
        if (field.getType().isEnum()) {
            return EnumAdapter.forClass(field.getType().asSubclass(Enum.class));
        }
        return this.seedAdapters.get(type);
    }
}

