/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.behaim.builder.seeder;

import com.github.chrisgleissner.behaim.builder.config.FieldConfig;
import com.github.chrisgleissner.behaim.builder.seeder.AbstractSeeder;

public class SequentialSeeder
extends AbstractSeeder {
    private int nextSeed;

    public SequentialSeeder(FieldConfig fieldConfig) {
        super(fieldConfig);
        this.nextSeed = fieldConfig.getMinValue();
    }

    @Override
    public int createIntSeed() {
        FieldConfig fieldConfig = this.getConfig();
        if (fieldConfig.isConstantValue()) {
            return fieldConfig.getMinValue();
        }
        int seed = this.nextSeed++;
        if (this.nextSeed > fieldConfig.getMaxValue()) {
            this.nextSeed = fieldConfig.getMinValue();
        }
        return seed;
    }

    @Override
    public double createSeed() {
        return this.createIntSeed();
    }
}

