/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.behaim.explorer;

import com.github.chrisgleissner.behaim.BehaimException;
import com.github.chrisgleissner.behaim.explorer.Trace;
import com.github.chrisgleissner.behaim.explorer.VisitationResult;
import com.github.chrisgleissner.behaim.explorer.Visitor;
import com.github.chrisgleissner.behaim.route.LegType;
import com.github.chrisgleissner.behaim.route.Route;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;

public class Explorer {
    private final int recursionDepth;
    private final Visitor visitor;

    public Explorer(Visitor visitor, int recursionDepth) {
        this.visitor = visitor;
        this.recursionDepth = recursionDepth;
    }

    public Route explore(Object object) {
        Route route = new Route();
        Trace trace = new Trace();
        this.explore(route, object, trace);
        return route;
    }

    private void explore(Route route, Object object, Trace trace) {
        for (Field field : object.getClass().getDeclaredFields()) {
            if (!this.visitable(field)) continue;
            trace.add(field);
            VisitationResult visitationResult = this.visitor.visit(object, field);
            if (this.isExplorable(visitationResult, trace)) {
                route.addLeg(visitationResult.getFieldContext(), LegType.RECURSE);
                try {
                    Object fieldValue = visitationResult.getValue();
                    if (fieldValue != null) {
                        int elementIndex;
                        if (fieldValue instanceof Collection) {
                            route.addLeg(visitationResult.getFieldContext(), LegType.ITERATE_OVER_COLLECTION);
                            elementIndex = 0;
                            for (Object fieldElement : (Collection)fieldValue) {
                                this.explore(route, fieldElement, trace.add(field, elementIndex++));
                                trace.remove();
                            }
                        } else if (fieldValue.getClass().isArray()) {
                            route.addLeg(visitationResult.getFieldContext(), LegType.ITERATE_OVER_ARRAY);
                            elementIndex = 0;
                            for (Object fieldElement : (Object[])fieldValue) {
                                this.explore(route, fieldElement, trace.add(field, elementIndex++));
                                trace.remove();
                            }
                        } else {
                            this.explore(route, fieldValue, trace);
                        }
                    }
                }
                catch (Exception e) {
                    throw new BehaimException("Could not explore " + field.getDeclaringClass().getName() + "." + field.getName() + " on " + object, e);
                }
                route.addLeg(null, LegType.RETURN);
            } else {
                route.addLeg(visitationResult.getFieldContext(), LegType.NORMAL);
            }
            trace.remove();
        }
    }

    private boolean hasComplexType(Field field) {
        return !field.isEnumConstant() && !field.getType().isPrimitive();
    }

    private boolean isDescendable(Field field, Trace trace) {
        return trace.getNumberOfOccurrences(field.getType()) < this.recursionDepth;
    }

    private boolean isExplorable(VisitationResult visitationResult, Trace trace) {
        Field field = visitationResult.getFieldContext().getField();
        return visitationResult.isVisitOfValueRequired() && this.hasComplexType(field) && this.isDescendable(field, trace);
    }

    private boolean modifiable(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers);
    }

    private boolean visitable(Field field) {
        return this.modifiable(field);
    }
}

