/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.behaim.explorer;

import java.lang.reflect.Field;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Trace {
    private static final Logger logger = LoggerFactory.getLogger(Trace.class);
    private final Stack<Breadcrumb> breadcrumbs = new Stack();

    public Trace add(Field field) {
        this.breadcrumbs.push(new Breadcrumb(field));
        logger.trace("+{}", (Object)this);
        return this;
    }

    public Trace add(Field field, int elementIndex) {
        this.breadcrumbs.push(new Breadcrumb(elementIndex));
        logger.trace("+{}", (Object)this);
        return this;
    }

    public int getNumberOfOccurrences(Class type) {
        int numberOfOccurrences = 0;
        for (Breadcrumb breadcrumb : this.breadcrumbs) {
            if (!type.equals(breadcrumb.getType())) continue;
            ++numberOfOccurrences;
        }
        return numberOfOccurrences;
    }

    public Breadcrumb remove() {
        Breadcrumb breadcrumb = this.breadcrumbs.pop();
        logger.trace("-{}", (Object)this);
        return breadcrumb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Breadcrumb breadcrumb : this.breadcrumbs) {
            if (first) {
                first = false;
            } else {
                sb.append("/");
            }
            sb.append(breadcrumb.getName());
        }
        return sb.toString();
    }

    private static final class Breadcrumb {
        private final String name;
        private final Class type;

        public Breadcrumb(Field field) {
            this.type = field.getType();
            this.name = field.getName();
        }

        private Breadcrumb(int elementIndex) {
            this.name = "[" + elementIndex + "]";
            this.type = null;
        }

        private String getName() {
            return this.name;
        }

        private Class getType() {
            return this.type;
        }
    }
}

