/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.behaim.route;

import com.github.chrisgleissner.behaim.explorer.FieldContext;
import com.github.chrisgleissner.behaim.explorer.Visitor;
import com.github.chrisgleissner.behaim.route.Leg;
import com.github.chrisgleissner.behaim.route.LegType;
import com.github.chrisgleissner.behaim.route.Trip;
import com.github.chrisgleissner.behaim.utils.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Route {
    private final List<Leg> legs = new ArrayList<Leg>();

    public void addLeg(FieldContext fieldContext, LegType legType) {
        if (LegType.RETURN.equals((Object)legType)) {
            this.legs.add(Leg.RETURN_LEG);
        } else {
            for (int i = 0; i < this.legs.size(); ++i) {
                Leg leg = this.legs.get(i);
                if (!Objects.equals((Object)leg.getType(), (Object)legType) || !Objects.equals(leg.getFieldContext(), fieldContext)) continue;
                this.legs.add(leg);
                return;
            }
            this.legs.add(new Leg(fieldContext, legType));
        }
    }

    private void append(StringBuilder sb, String s, int recursionLevel) {
        for (int i = 0; i < recursionLevel; ++i) {
            sb.append("  ");
        }
        sb.append(s);
        sb.append("\n");
    }

    public Collection<Leg> getLegs() {
        return this.legs;
    }

    public Trip prepareTrip(Object startingLocation, Visitor visitor) {
        return new Trip(this, startingLocation, visitor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(4096);
        int recursionLevel = 0;
        for (Leg leg : this.legs) {
            switch (leg.getType()) {
                case ITERATE_OVER_ARRAY: {
                    this.append(sb, "[]", recursionLevel);
                    break;
                }
                case ITERATE_OVER_COLLECTION: {
                    this.append(sb, "collection", recursionLevel);
                    break;
                }
                case RECURSE: {
                    this.append(sb, leg.toString(), ++recursionLevel);
                    break;
                }
                case NORMAL: {
                    this.append(sb, leg.toString(), recursionLevel);
                    break;
                }
                case RETURN: {
                    --recursionLevel;
                }
            }
        }
        return sb.toString();
    }
}

