/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.behaim.route;

import com.github.chrisgleissner.behaim.explorer.VisitationResult;
import com.github.chrisgleissner.behaim.explorer.Visitor;
import com.github.chrisgleissner.behaim.route.Leg;
import com.github.chrisgleissner.behaim.route.Route;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Trip {
    private static final Logger logger = LoggerFactory.getLogger(Trip.class);
    private final Iterator<Leg> legIterator;
    private final Object startingLocation;
    private final Visitor visitor;

    public Trip(Route route, Object startingLocation, Visitor visitor) {
        this.startingLocation = startingLocation;
        this.visitor = visitor;
        this.legIterator = route.getLegs().iterator();
    }

    public void perform() {
        this.visit(this.startingLocation);
    }

    private void visit(Object location) {
        while (this.legIterator.hasNext()) {
            Leg leg = this.legIterator.next();
            switch (leg.getType()) {
                case ITERATE_OVER_ARRAY: {
                    for (Object value : (Object[])location) {
                        this.visit(value);
                    }
                    break;
                }
                case ITERATE_OVER_COLLECTION: {
                    for (Object value : (Collection)location) {
                        this.visit(value);
                    }
                    break;
                }
                case RECURSE: {
                    Field field = leg.getFieldContext().getField();
                    VisitationResult result = this.visitor.visit(location, field);
                    logger.trace("{}={}", (Object)leg, result.getValue());
                    this.visit(result.getValue());
                    break;
                }
                case NORMAL: {
                    Field field = leg.getFieldContext().getField();
                    VisitationResult result = this.visitor.visit(location, field);
                    logger.trace("{}={}", (Object)leg, result.getValue());
                    break;
                }
                case RETURN: {
                    return;
                }
            }
        }
    }
}

