/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.behaim.stats;

import com.github.chrisgleissner.behaim.explorer.FieldContext;
import com.github.chrisgleissner.behaim.explorer.VisitationResult;
import com.github.chrisgleissner.behaim.explorer.Visitor;
import com.github.chrisgleissner.behaim.utils.Objects;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class StatisticsVisitor
implements Visitor {
    private final HashMap<String, Integer> counters = new HashMap();
    private final Set<Value> visited = new HashSet<Value>();

    @Override
    public VisitationResult visit(Object object, final Field field) {
        Value valueObj = new Value(object, null);
        if (!this.visited.contains(valueObj)) {
            this.visited.add(valueObj);
            this.incrementCounter(object);
        }
        Value value = new Value(object, field);
        boolean alreadySeen = this.visited.contains(value);
        boolean visitable = false;
        Object fieldValue = null;
        Class<?> type = field.getType();
        if (!alreadySeen) {
            this.visited.add(value);
            fieldValue = this.getFieldValue(object, field);
            visitable = this.isVisitable(type);
            this.incrementCounter(fieldValue);
        }
        boolean visitOfValueRequired = !alreadySeen && visitable;
        return new VisitationResult(new FieldContext(){

            @Override
            public Field getField() {
                return field;
            }
        }, fieldValue, visitOfValueRequired);
    }

    public SortedSet<String> getClasses() {
        return new TreeSet<String>(this.counters.keySet());
    }

    public int getCount(Class<?> clazz) {
        Integer counter = this.counters.get(this.getKey(clazz));
        return counter == null ? 0 : counter;
    }

    private boolean isVisitable(Class<?> type) {
        String packageName;
        boolean visitable = type.isPrimitive() || type.isEnum() && type.getEnumConstants().length == 0 ? false : !(packageName = type.getPackage().getName()).startsWith("java.") && !packageName.startsWith("javax.");
        return visitable | Collection.class.isAssignableFrom(type);
    }

    private void incrementCounter(Object object) {
        if (object != null) {
            String key;
            Integer count = this.counters.get(key = this.getKey(object.getClass()));
            this.counters.put(key, count == null ? 1 : count + 1);
        }
    }

    private String getKey(Class clazz) {
        return clazz.getName();
    }

    private Object getFieldValue(Object object, Field field) {
        Object fieldValue = null;
        if (object != null) {
            boolean wasAccessible = field.isAccessible();
            try {
                if (!wasAccessible) {
                    field.setAccessible(true);
                }
                fieldValue = field.get(object);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (!wasAccessible) {
                    field.setAccessible(false);
                }
            }
        }
        return fieldValue;
    }

    private static class Value {
        private final Object object;
        private final Field field;

        private Value(Object object, Field field) {
            this.object = object;
            this.field = field;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value = (Value)o;
            return Objects.equals(this.object, value.object) && Objects.equals(this.field, value.field);
        }

        public int hashCode() {
            return Objects.hash(this.object, this.field);
        }
    }
}

