/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.jutil.table;

import com.github.chrisgleissner.jutil.table.format.AsciiTableFormat;
import com.github.chrisgleissner.jutil.table.format.TableFormat;
import com.github.chrisgleissner.jutil.table.provider.SimpleTableProvider;
import com.github.chrisgleissner.jutil.table.provider.TableProvider;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class TablePrinter {
    public static TablePrinter DefaultTablePrinter = TablePrinter.builder().build();
    private String nullValue;
    private TableFormat tableFormat;
    private int maxCellWidth;
    private boolean wraparound;
    private int startRow;
    private int endRow;
    private boolean horizontalDividers;
    private boolean rowNumbers;

    private int cellLength(String s) {
        return Math.min(this.maxCellWidth, (s == null ? this.nullValue : s).length());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String print(TableProvider tableProvider) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.print(tableProvider, baos);
            String string = baos.toString("UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to print table", e);
        }
    }

    public String print(Iterable<String> headers, Iterable<? extends Iterable<String>> data) {
        return this.print(new SimpleTableProvider(headers, data));
    }

    public void print(TableProvider tableProvider, OutputStream os) {
        new TableString().write(tableProvider, os);
    }

    public void print(Iterable<String> headers, Iterable<? extends Iterable<String>> data, OutputStream os) {
        this.print(new SimpleTableProvider(headers, data), os);
    }

    private static String $default$nullValue() {
        return "";
    }

    private static TableFormat $default$tableFormat() {
        return new AsciiTableFormat();
    }

    private static int $default$maxCellWidth() {
        return 100;
    }

    private static boolean $default$wraparound() {
        return true;
    }

    private static int $default$startRow() {
        return 0;
    }

    private static int $default$endRow() {
        return Integer.MAX_VALUE;
    }

    private static boolean $default$horizontalDividers() {
        return false;
    }

    private static boolean $default$rowNumbers() {
        return false;
    }

    TablePrinter(String nullValue, TableFormat tableFormat, int maxCellWidth, boolean wraparound, int startRow, int endRow, boolean horizontalDividers, boolean rowNumbers) {
        this.nullValue = nullValue;
        this.tableFormat = tableFormat;
        this.maxCellWidth = maxCellWidth;
        this.wraparound = wraparound;
        this.startRow = startRow;
        this.endRow = endRow;
        this.horizontalDividers = horizontalDividers;
        this.rowNumbers = rowNumbers;
    }

    public static TablePrinterBuilder builder() {
        return new TablePrinterBuilder();
    }

    public static class TablePrinterBuilder {
        private boolean nullValue$set;
        private String nullValue;
        private boolean tableFormat$set;
        private TableFormat tableFormat;
        private boolean maxCellWidth$set;
        private int maxCellWidth;
        private boolean wraparound$set;
        private boolean wraparound;
        private boolean startRow$set;
        private int startRow;
        private boolean endRow$set;
        private int endRow;
        private boolean horizontalDividers$set;
        private boolean horizontalDividers;
        private boolean rowNumbers$set;
        private boolean rowNumbers;

        TablePrinterBuilder() {
        }

        public TablePrinterBuilder nullValue(String nullValue) {
            this.nullValue = nullValue;
            this.nullValue$set = true;
            return this;
        }

        public TablePrinterBuilder tableFormat(TableFormat tableFormat) {
            this.tableFormat = tableFormat;
            this.tableFormat$set = true;
            return this;
        }

        public TablePrinterBuilder maxCellWidth(int maxCellWidth) {
            this.maxCellWidth = maxCellWidth;
            this.maxCellWidth$set = true;
            return this;
        }

        public TablePrinterBuilder wraparound(boolean wraparound) {
            this.wraparound = wraparound;
            this.wraparound$set = true;
            return this;
        }

        public TablePrinterBuilder startRow(int startRow) {
            this.startRow = startRow;
            this.startRow$set = true;
            return this;
        }

        public TablePrinterBuilder endRow(int endRow) {
            this.endRow = endRow;
            this.endRow$set = true;
            return this;
        }

        public TablePrinterBuilder horizontalDividers(boolean horizontalDividers) {
            this.horizontalDividers = horizontalDividers;
            this.horizontalDividers$set = true;
            return this;
        }

        public TablePrinterBuilder rowNumbers(boolean rowNumbers) {
            this.rowNumbers = rowNumbers;
            this.rowNumbers$set = true;
            return this;
        }

        public TablePrinter build() {
            String nullValue = this.nullValue;
            if (!this.nullValue$set) {
                nullValue = TablePrinter.$default$nullValue();
            }
            TableFormat tableFormat = this.tableFormat;
            if (!this.tableFormat$set) {
                tableFormat = TablePrinter.$default$tableFormat();
            }
            int maxCellWidth = this.maxCellWidth;
            if (!this.maxCellWidth$set) {
                maxCellWidth = TablePrinter.$default$maxCellWidth();
            }
            boolean wraparound = this.wraparound;
            if (!this.wraparound$set) {
                wraparound = TablePrinter.$default$wraparound();
            }
            int startRow = this.startRow;
            if (!this.startRow$set) {
                startRow = TablePrinter.$default$startRow();
            }
            int endRow = this.endRow;
            if (!this.endRow$set) {
                endRow = TablePrinter.$default$endRow();
            }
            boolean horizontalDividers = this.horizontalDividers;
            if (!this.horizontalDividers$set) {
                horizontalDividers = TablePrinter.$default$horizontalDividers();
            }
            boolean rowNumbers = this.rowNumbers;
            if (!this.rowNumbers$set) {
                rowNumbers = TablePrinter.$default$rowNumbers();
            }
            return new TablePrinter(nullValue, tableFormat, maxCellWidth, wraparound, startRow, endRow, horizontalDividers, rowNumbers);
        }

        public String toString() {
            return "TablePrinter.TablePrinterBuilder(nullValue=" + this.nullValue + ", tableFormat=" + this.tableFormat + ", maxCellWidth=" + this.maxCellWidth + ", wraparound=" + this.wraparound + ", startRow=" + this.startRow + ", endRow=" + this.endRow + ", horizontalDividers=" + this.horizontalDividers + ", rowNumbers=" + this.rowNumbers + ")";
        }
    }

    private class TableData {
        private final Map<Integer, Integer> cellWidths = new TreeMap<Integer, Integer>();
        private final List<Cell> headers;
        private final List<List<Cell>> rows;

        private TableData(TableProvider tableProvider) {
            this.rows = this.prepareRows(tableProvider);
            this.updateCellWidthsForRows();
            this.headers = this.prepareHeaders(tableProvider);
            this.updateCellWidthsForHeaders();
        }

        private List<Cell> prepareHeaders(TableProvider tableProvider) {
            Iterable<String> headerIteratable = tableProvider.getHeaders();
            ArrayList<Cell> headers = new ArrayList<Cell>();
            if (TablePrinter.this.rowNumbers) {
                headers.add(new Cell("#"));
            }
            if (headerIteratable != null) {
                headerIteratable.iterator().forEachRemaining(h -> headers.add(new Cell((String)h)));
            }
            for (int i = headers.size(); i < this.cellWidths.size(); ++i) {
                headers.add(new Cell("" + i));
            }
            return headers;
        }

        private void updateCellWidthsForRows() {
            for (Iterable iterable : this.rows) {
                int i = 0;
                for (Cell cell : iterable) {
                    this.setCellWidth(i++, cell.lines.stream().mapToInt(l -> TablePrinter.this.cellLength(l)).max().orElse(0));
                }
            }
        }

        private void updateCellWidthsForHeaders() {
            int i = 0;
            for (Cell cell : this.headers) {
                this.setCellWidth(i++, cell.lines.stream().mapToInt(l -> TablePrinter.this.cellLength(l)).max().orElse(0));
            }
        }

        private void setCellWidth(int index, int length) {
            this.cellWidths.put(index, Math.max(this.cellWidths.getOrDefault(index, 0), length));
        }

        private int numberOfCellWidths() {
            return this.cellWidths.size();
        }

        private int getCellWidth(int index) {
            return this.cellWidths.get(index);
        }

        private List<List<Cell>> prepareRows(TableProvider tableProvider) {
            ArrayList<List<Cell>> rows = new ArrayList<List<Cell>>();
            if (tableProvider.getRows() != null) {
                int i = 0;
                for (Iterable<String> iterable : tableProvider.getRows()) {
                    if (i >= TablePrinter.this.startRow && i <= TablePrinter.this.endRow) {
                        ArrayList<Cell> cells = new ArrayList<Cell>();
                        cells.addAll(StreamSupport.stream(iterable.spliterator(), true).map(x$0 -> new Cell((String)x$0)).collect(Collectors.toList()));
                        if (TablePrinter.this.rowNumbers) {
                            cells.add(0, new Cell(Integer.toString(i)));
                        }
                        rows.add(cells);
                    }
                    ++i;
                }
            }
            return rows;
        }

        private boolean exists() {
            return !this.headers.isEmpty() || !this.rows.isEmpty();
        }

        public Map<Integer, Integer> getCellWidths() {
            return this.cellWidths;
        }

        public List<Cell> getHeaders() {
            return this.headers;
        }

        public List<List<Cell>> getRows() {
            return this.rows;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableData)) {
                return false;
            }
            TableData other = (TableData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<Integer, Integer> this$cellWidths = this.getCellWidths();
            Map<Integer, Integer> other$cellWidths = other.getCellWidths();
            if (this$cellWidths == null ? other$cellWidths != null : !((Object)this$cellWidths).equals(other$cellWidths)) {
                return false;
            }
            List<Cell> this$headers = this.getHeaders();
            List<Cell> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            List<List<Cell>> this$rows = this.getRows();
            List<List<Cell>> other$rows = other.getRows();
            return !(this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TableData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<Integer, Integer> $cellWidths = this.getCellWidths();
            result = result * 59 + ($cellWidths == null ? 43 : ((Object)$cellWidths).hashCode());
            List<Cell> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            List<List<Cell>> $rows = this.getRows();
            result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
            return result;
        }

        public String toString() {
            return "TablePrinter.TableData(cellWidths=" + this.getCellWidths() + ", headers=" + this.getHeaders() + ", rows=" + this.getRows() + ")";
        }

        private class Cell {
            private List<String> lines = new ArrayList<String>();

            public Cell(String s) {
                if (s == null) {
                    s = TablePrinter.this.nullValue;
                }
                s = s.replace("\t", "        ");
                if (TablePrinter.this.wraparound) {
                    StringBuilder sb = new StringBuilder();
                    for (char c : s.toCharArray()) {
                        if (c == '\n' || sb.length() == TablePrinter.this.maxCellWidth) {
                            this.lines.add(sb.toString());
                            sb = new StringBuilder();
                        }
                        if (c == '\n') continue;
                        sb.append(c);
                    }
                    if (sb.length() > 0) {
                        this.lines.add(sb.toString());
                    }
                } else {
                    s = s.replace("\n", "");
                    this.lines.add(s.substring(0, Math.min(TablePrinter.this.maxCellWidth, s.length())));
                }
            }

            public String getLine(int i) {
                return i < this.lines.size() ? this.lines.get(i) : "";
            }

            public List<String> getLines() {
                return this.lines;
            }

            public void setLines(List<String> lines) {
                this.lines = lines;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cell)) {
                    return false;
                }
                Cell other = (Cell)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$lines = this.getLines();
                List<String> other$lines = other.getLines();
                return !(this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Cell;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $lines = this.getLines();
                result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
                return result;
            }

            public String toString() {
                return "TablePrinter.TableData.Cell(lines=" + this.getLines() + ")";
            }
        }
    }

    private class TableString {
        private TableData tableData;
        private PrintWriter pw;

        private TableString() {
        }

        public void write(TableProvider tableProvider, OutputStream os) {
            this.pw = new PrintWriter(os);
            this.tableData = new TableData(tableProvider);
            if (this.tableData.exists()) {
                this.printTopEdge();
                this.printHeaders(this.tableData.getHeaders());
                this.printUnderHeaders(this.tableData.getRows().isEmpty());
                if (!this.tableData.getRows().isEmpty()) {
                    for (int i = 0; i < this.tableData.getRows().size(); ++i) {
                        if (i > 0 && TablePrinter.this.horizontalDividers) {
                            this.printHorizontalDivider();
                        }
                        this.printRow(this.tableData.getRows().get(i));
                    }
                    this.printBottomEdge();
                }
            }
            this.pw.flush();
        }

        private void printRow(List<TableData.Cell> row) {
            this.print(TablePrinter.this.tableFormat.getVerticalBorderFill(true), TablePrinter.this.tableFormat.getVerticalBorderFill(false), TablePrinter.this.tableFormat.getVerticalBorderFill(true), row);
        }

        private void printHeaders(List<TableData.Cell> headers) {
            this.print(TablePrinter.this.tableFormat.getVerticalBorderFill(true), TablePrinter.this.tableFormat.getVerticalBorderFill(false), TablePrinter.this.tableFormat.getVerticalBorderFill(true), headers);
        }

        private void print(char left, char divider, char right, List<TableData.Cell> cells) {
            int maxLines = cells.stream().mapToInt(c -> c.getLines().size()).max().orElse(0);
            for (int lineIndex = 0; lineIndex < maxLines; ++lineIndex) {
                this.pw.append(left);
                for (int cellIndex = 0; cellIndex < this.tableData.numberOfCellWidths(); ++cellIndex) {
                    if (cellIndex > 0) {
                        this.pw.append(divider);
                    }
                    this.pw.append(' ');
                    String line = "";
                    if (cellIndex < cells.size()) {
                        line = cells.get(cellIndex).getLine(lineIndex);
                    }
                    this.pw.append(line, 0, Math.min(TablePrinter.this.maxCellWidth, line.length()));
                    for (int k = 0; k < this.tableData.getCellWidth(cellIndex) - TablePrinter.this.cellLength(line); ++k) {
                        this.pw.append(' ');
                    }
                    this.pw.append(' ');
                }
                this.pw.append(right);
                this.pw.append('\n');
            }
        }

        private void printHorizontalDivider() {
            this.printHorizontalLine(TablePrinter.this.tableFormat.getLeftEdgeBorderDivider(false), TablePrinter.this.tableFormat.getCross(false, false), TablePrinter.this.tableFormat.getHorizontalBorderFill(false, false), TablePrinter.this.tableFormat.getRightEdgeBorderDivider(false));
        }

        private void printUnderHeaders(boolean emptyData) {
            if (emptyData) {
                this.printHorizontalLine(TablePrinter.this.tableFormat.getBottomLeftCorner(), TablePrinter.this.tableFormat.getCross(true, emptyData), TablePrinter.this.tableFormat.getHorizontalBorderFill(false, true), TablePrinter.this.tableFormat.getBottomRightCorner());
            } else {
                this.printHorizontalLine(TablePrinter.this.tableFormat.getLeftEdgeBorderDivider(true), TablePrinter.this.tableFormat.getCross(true, emptyData), TablePrinter.this.tableFormat.getHorizontalBorderFill(false, true), TablePrinter.this.tableFormat.getRightEdgeBorderDivider(true));
            }
        }

        private void printTopEdge() {
            this.printHorizontalLine(TablePrinter.this.tableFormat.getTopLeftCorner(), TablePrinter.this.tableFormat.getTopEdgeBorderDivider(), TablePrinter.this.tableFormat.getHorizontalBorderFill(true, false), TablePrinter.this.tableFormat.getTopRightCorner());
        }

        private void printBottomEdge() {
            this.printHorizontalLine(TablePrinter.this.tableFormat.getBottomLeftCorner(), TablePrinter.this.tableFormat.getBottomEdgeBorderDivider(), TablePrinter.this.tableFormat.getHorizontalBorderFill(true, false), TablePrinter.this.tableFormat.getBottomRightCorner());
        }

        private void printHorizontalLine(char left, char divider, char middle, char right) {
            this.pw.append(left);
            for (int i = 0; i < this.tableData.numberOfCellWidths(); ++i) {
                if (i > 0) {
                    this.pw.append(divider);
                }
                for (int j = 0; j < this.tableData.getCellWidth(i) + 2; ++j) {
                    this.pw.append(middle);
                }
            }
            this.pw.append(right);
            this.pw.append('\n');
        }
    }
}

