/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.jutil.table.provider;

import com.github.chrisgleissner.jutil.table.provider.TableProvider;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class BeanTableProvider
implements TableProvider {
    private final Iterable<? extends Object> beans;
    private Map<String, Method> readMethodsByPropertyName = new HashMap<String, Method>();

    public BeanTableProvider(Iterable<? extends Object> beans) {
        this.beans = beans;
        try {
            if (beans.iterator().hasNext()) {
                Object bean = beans.iterator().next();
                BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
                this.readMethodsByPropertyName = Arrays.stream(beanInfo.getPropertyDescriptors()).filter(pd -> !pd.getName().equals("class")).collect(LinkedHashMap::new, (map, pd) -> {
                    pd.getReadMethod().setAccessible(true);
                    map.put(pd.getName(), pd.getReadMethod());
                }, Map::putAll);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can't get Bean properties", e);
        }
    }

    @Override
    public Iterable<String> getHeaders() {
        return this.readMethodsByPropertyName.keySet();
    }

    @Override
    public Iterable<? extends Iterable<String>> getRows() {
        return () -> StreamSupport.stream(this.beans.spliterator(), false).map(bean -> this.readMethodsByPropertyName.values().stream().map(method -> {
            try {
                return "" + method.invoke(bean, null);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Can't access bean property method %s for bean %s", method, bean), e);
            }
        }).collect(Collectors.toList())).iterator();
    }
}

