/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.jutil.table.provider;

import com.github.chrisgleissner.jutil.table.provider.TableProvider;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;

public class ResultSetTableProvider
implements TableProvider {
    private ResultSet rs;
    private final int columnCount;

    public ResultSetTableProvider(ResultSet resultSet) {
        try {
            this.rs = resultSet;
            this.columnCount = this.rs.getMetaData().getColumnCount();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get column count from ResultSet", e);
        }
    }

    @Override
    public Iterable<String> getHeaders() {
        try {
            ArrayList<String> headers = new ArrayList<String>(this.columnCount);
            for (int i = 1; i <= this.columnCount; ++i) {
                headers.add(this.rs.getMetaData().getColumnName(i));
            }
            return headers;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get headers from ResultSet", e);
        }
    }

    @Override
    public Iterable<? extends Iterable<String>> getRows() {
        return () -> new Iterator<Iterable<String>>(){

            @Override
            public boolean hasNext() {
                try {
                    return ResultSetTableProvider.this.rs.next();
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't get next row from ResultSet", e);
                }
            }

            @Override
            public Iterable<String> next() {
                try {
                    ArrayList<String> cells = new ArrayList<String>(ResultSetTableProvider.this.columnCount);
                    for (int i = 1; i <= ResultSetTableProvider.this.columnCount; ++i) {
                        cells.add(ResultSetTableProvider.this.rs.getString(i));
                    }
                    return cells;
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't get next row from ResultSet", e);
                }
            }
        };
    }
}

