/*
 * Decompiled with CFR 0.152.
 */
package com.github.chrisgleissner.jutil.table.provider;

import com.github.chrisgleissner.jutil.table.provider.TableProvider;
import com.univocity.parsers.common.IterableResult;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.record.Record;
import java.util.Arrays;
import java.util.stream.StreamSupport;

public class UnivocityTableProvider {
    public static TableProvider of(IterableResult<Record, ParsingContext> records) {
        return new IterableTableProvider(records);
    }

    public static TableProvider of(Iterable<Record> records) {
        return new ListTableProvider(records);
    }

    private static class ListTableProvider
    implements TableProvider {
        private final Iterable<Record> records;

        private ListTableProvider(Iterable<Record> records) {
            this.records = records;
        }

        @Override
        public Iterable<String> getHeaders() {
            return Arrays.asList(this.records.iterator().next().getMetaData().headers());
        }

        @Override
        public Iterable<? extends Iterable<String>> getRows() {
            return () -> StreamSupport.stream(this.records.spliterator(), false).map(record -> Arrays.asList(record.getValues())).iterator();
        }
    }

    private static class IterableTableProvider
    implements TableProvider {
        private final IterableResult<Record, ParsingContext> records;

        private IterableTableProvider(IterableResult<Record, ParsingContext> records) {
            this.records = records;
        }

        @Override
        public Iterable<String> getHeaders() {
            return Arrays.asList(((ParsingContext)this.records.iterator().getContext()).headers());
        }

        @Override
        public Iterable<? extends Iterable<String>> getRows() {
            return () -> StreamSupport.stream(this.records.spliterator(), false).map(record -> Arrays.asList(record.getValues())).iterator();
        }
    }
}

