/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import stormpot.BSlot;
import stormpot.BlazePool;
import stormpot.Completion;
import stormpot.Config;
import stormpot.DisregardBPile;
import stormpot.Expiration;
import stormpot.LatchCompletion;
import stormpot.MetricsRecorder;
import stormpot.Poolable;
import stormpot.PreciseLeakDetector;
import stormpot.QueueFactory;
import stormpot.Reallocator;

final class BAllocThread<T extends Poolable>
implements Runnable {
    private static final long shutdownPauseNanos = TimeUnit.MILLISECONDS.toNanos(10L);
    private final BlockingQueue<BSlot<T>> live;
    private final DisregardBPile<T> disregardPile;
    private final Reallocator<T> allocator;
    private final BSlot<T> poisonPill;
    private final MetricsRecorder metricsRecorder;
    private final Expiration<? super T> expiration;
    private final boolean backgroundExpirationEnabled;
    private final PreciseLeakDetector leakDetector;
    private final CountDownLatch completionLatch;
    private final BlockingQueue<BSlot<T>> dead;
    private final AtomicInteger poisonedSlots;
    private volatile int targetSize;
    private volatile boolean shutdown;
    private volatile long allocationCount;
    private volatile long failedAllocationCount;
    private int size;

    public BAllocThread(BlockingQueue<BSlot<T>> live, DisregardBPile<T> disregardPile, Config<T> config, BSlot<T> poisonPill) {
        this.live = live;
        this.disregardPile = disregardPile;
        this.allocator = config.getAdaptedReallocator();
        this.targetSize = config.getSize();
        this.metricsRecorder = config.getMetricsRecorder();
        this.poisonPill = poisonPill;
        this.expiration = config.getExpiration();
        this.backgroundExpirationEnabled = config.isBackgroundExpirationEnabled();
        this.leakDetector = config.isPreciseLeakDetectionEnabled() ? new PreciseLeakDetector() : null;
        this.completionLatch = new CountDownLatch(1);
        this.dead = QueueFactory.createUnboundedBlockingQueue();
        this.poisonedSlots = new AtomicInteger();
        this.size = 0;
    }

    @Override
    public void run() {
        this.continuouslyReplenishPool();
        this.shutPoolDown();
        this.completionLatch.countDown();
    }

    private void continuouslyReplenishPool() {
        try {
            while (!this.shutdown) {
                this.replenishPool();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.poisonPill.dead2live();
        this.live.offer(this.poisonPill);
    }

    private void replenishPool() throws InterruptedException {
        long deadPollTimeout;
        boolean weHaveWorkToDo = this.size != this.targetSize || this.poisonedSlots.get() > 0;
        long l = deadPollTimeout = weHaveWorkToDo ? 0L : 50L;
        if (this.size < this.targetSize) {
            this.increaseSizeByAllocating();
        }
        BSlot<T> slot = this.dead.poll(deadPollTimeout, TimeUnit.MILLISECONDS);
        if (this.size > this.targetSize) {
            this.reduceSizeByDeallocating(slot);
        } else if (slot != null) {
            this.reallocateDeadSlot(slot);
        }
        if (this.shutdown) {
            return;
        }
        if (this.poisonedSlots.get() > 0) {
            this.proactivelyHealPoison();
        } else if (this.backgroundExpirationEnabled && !weHaveWorkToDo) {
            this.backgroundExpirationCheck();
        }
    }

    private void increaseSizeByAllocating() {
        BSlot<T> slot = new BSlot<T>(this.live, this.poisonedSlots);
        this.alloc(slot);
        this.registerWithLeakDetector(slot);
    }

    private void reduceSizeByDeallocating(BSlot<T> slot) {
        BSlot bSlot = slot = slot == null ? (BSlot)this.live.poll() : slot;
        if (slot != null) {
            if (slot.isDead() || slot.live2dead()) {
                this.dealloc(slot);
                this.unregisterWithLeakDetector(slot);
            } else {
                this.live.offer(slot);
            }
        }
    }

    private void registerWithLeakDetector(BSlot<T> slot) {
        if (this.leakDetector != null) {
            this.leakDetector.register(slot);
        }
    }

    private void unregisterWithLeakDetector(BSlot<T> slot) {
        if (this.leakDetector != null) {
            this.leakDetector.unregister(slot);
        }
    }

    private void reallocateDeadSlot(BSlot<T> slot) {
        this.realloc(slot);
    }

    private void proactivelyHealPoison() {
        BSlot slot = (BSlot)this.live.poll();
        if (slot != null) {
            if (slot.poison != null && (slot.isDead() || slot.live2dead())) {
                this.realloc(slot);
            } else {
                this.live.offer(slot);
            }
        }
    }

    private void backgroundExpirationCheck() {
        BSlot slot = (BSlot)this.live.poll();
        if (slot != null) {
            if (slot.isLive() && slot.live2claim()) {
                boolean expired;
                try {
                    expired = slot.poison != null || this.expiration.hasExpired(slot);
                }
                catch (Exception ignore) {
                    expired = true;
                }
                if (expired) {
                    slot.claim2dead();
                    this.dead.offer(slot);
                } else {
                    slot.claim2live();
                    this.live.offer(slot);
                }
            } else {
                this.live.offer(slot);
            }
        }
    }

    private void shutPoolDown() {
        while (this.size > 0) {
            BSlot slot = (BSlot)this.dead.poll();
            if (slot == null) {
                slot = (BSlot)this.live.poll();
            }
            if (slot == this.poisonPill) {
                this.live.offer(this.poisonPill);
                slot = null;
            }
            if (slot == null) {
                if (this.disregardPile.refillQueue()) continue;
                LockSupport.parkNanos(shutdownPauseNanos);
                continue;
            }
            if (slot.isDead() || slot.live2dead()) {
                this.dealloc(slot);
                this.unregisterWithLeakDetector(slot);
                continue;
            }
            this.live.offer(slot);
        }
    }

    private void alloc(BSlot<T> slot) {
        try {
            slot.obj = this.allocator.allocate(slot);
            if (slot.obj == null) {
                this.poisonedSlots.getAndIncrement();
                ++this.failedAllocationCount;
                slot.poison = new NullPointerException("Allocation returned null");
            } else {
                ++this.allocationCount;
            }
        }
        catch (Exception e) {
            this.poisonedSlots.getAndIncrement();
            ++this.failedAllocationCount;
            slot.poison = e;
        }
        ++this.size;
        this.resetSlot(slot, System.currentTimeMillis());
        this.live.offer(slot);
    }

    private void resetSlot(BSlot<T> slot, long now) {
        slot.created = now;
        slot.claims = 0L;
        slot.stamp = 0L;
        slot.dead2live();
    }

    private void dealloc(BSlot<T> slot) {
        --this.size;
        try {
            if (slot.poison == null) {
                long now = System.currentTimeMillis();
                this.recordObjectLifetimeSample(now - slot.created);
                this.allocator.deallocate(slot.obj);
            } else {
                this.poisonedSlots.getAndDecrement();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        slot.poison = null;
        slot.obj = null;
    }

    private void realloc(BSlot<T> slot) {
        if (slot.poison == BlazePool.EXPLICIT_EXPIRE_POISON) {
            slot.poison = null;
        }
        if (slot.poison == null) {
            try {
                slot.obj = this.allocator.reallocate(slot, slot.obj);
                if (slot.obj == null) {
                    this.poisonedSlots.getAndIncrement();
                    ++this.failedAllocationCount;
                    slot.poison = new NullPointerException("Reallocation returned null");
                } else {
                    ++this.allocationCount;
                }
            }
            catch (Exception e) {
                this.poisonedSlots.getAndIncrement();
                ++this.failedAllocationCount;
                slot.poison = e;
            }
            long now = System.currentTimeMillis();
            this.recordObjectLifetimeSample(now - slot.created);
            this.resetSlot(slot, now);
            this.live.offer(slot);
        } else {
            this.dealloc(slot);
            this.alloc(slot);
        }
    }

    private void recordObjectLifetimeSample(long milliseconds) {
        if (this.metricsRecorder != null) {
            this.metricsRecorder.recordObjectLifetimeSampleMillis(milliseconds);
        }
    }

    void setTargetSize(int size) {
        this.targetSize = size;
    }

    int getTargetSize() {
        return this.targetSize;
    }

    Completion shutdown(Thread allocatorThread) {
        this.shutdown = true;
        allocatorThread.interrupt();
        return new LatchCompletion(this.completionLatch);
    }

    public long getAllocationCount() {
        return this.allocationCount;
    }

    public long getFailedAllocationCount() {
        return this.failedAllocationCount;
    }

    public long countLeakedObjects() {
        if (this.leakDetector != null) {
            return this.leakDetector.countLeakedObjects();
        }
        return -1L;
    }

    public void offerDeadSlot(BSlot<T> slot) {
        this.dead.offer(slot);
    }
}

