/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import stormpot.Allocator;
import stormpot.Expiration;
import stormpot.MetricsRecorder;
import stormpot.Poolable;
import stormpot.ReallocatingAdaptor;
import stormpot.Reallocator;
import stormpot.StormpotThreadFactory;
import stormpot.TimeSpreadExpiration;
import stormpot.TimingReallocatingAdaptor;
import stormpot.TimingReallocatorAdaptor;

public class Config<T extends Poolable>
implements Cloneable {
    private int size = 10;
    private Expiration<? super T> expiration = new TimeSpreadExpiration<T>(480000L, 600000L, TimeUnit.MILLISECONDS);
    private Allocator<?> allocator;
    private MetricsRecorder metricsRecorder;
    private ThreadFactory threadFactory = StormpotThreadFactory.INSTANCE;
    private boolean preciseLeakDetectionEnabled = true;
    private boolean backgroundExpirationEnabled = false;

    public synchronized Config<T> setSize(int size) {
        this.size = size;
        return this;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized <X extends Poolable> Config<X> setAllocator(Allocator<X> allocator) {
        this.allocator = allocator;
        return this;
    }

    public synchronized Allocator<T> getAllocator() {
        return this.allocator;
    }

    public synchronized Reallocator<T> getReallocator() {
        if (this.allocator == null) {
            return null;
        }
        if (this.allocator instanceof Reallocator) {
            return (Reallocator)this.allocator;
        }
        return new ReallocatingAdaptor(this.allocator);
    }

    public synchronized Config<T> setExpiration(Expiration<? super T> expiration) {
        this.expiration = expiration;
        return this;
    }

    public synchronized Expiration<? super T> getExpiration() {
        return this.expiration;
    }

    public synchronized Config<T> setMetricsRecorder(MetricsRecorder metricsRecorder) {
        this.metricsRecorder = metricsRecorder;
        return this;
    }

    public synchronized MetricsRecorder getMetricsRecorder() {
        return this.metricsRecorder;
    }

    public synchronized ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public synchronized Config<T> setThreadFactory(ThreadFactory factory) {
        this.threadFactory = factory;
        return this;
    }

    public synchronized boolean isPreciseLeakDetectionEnabled() {
        return this.preciseLeakDetectionEnabled;
    }

    public synchronized Config<T> setPreciseLeakDetectionEnabled(boolean enabled) {
        this.preciseLeakDetectionEnabled = enabled;
        return this;
    }

    public synchronized boolean isBackgroundExpirationEnabled() {
        return this.backgroundExpirationEnabled;
    }

    public synchronized Config<T> setBackgroundExpirationEnabled(boolean enabled) {
        this.backgroundExpirationEnabled = enabled;
        return this;
    }

    public final synchronized Config<T> clone() {
        try {
            return (Config)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Deprecated
    public synchronized void validate() throws IllegalArgumentException {
        if (this.size < 1) {
            throw new IllegalArgumentException("Size must be at least 1, but was " + this.size);
        }
        if (this.allocator == null) {
            throw new IllegalArgumentException("Allocator cannot be null");
        }
        if (this.expiration == null) {
            throw new IllegalArgumentException("Expiration cannot be null");
        }
        if (this.threadFactory == null) {
            throw new IllegalArgumentException("ThreadFactory cannot be null");
        }
    }

    Reallocator<T> getAdaptedReallocator() {
        if (this.allocator == null) {
            return null;
        }
        if (this.metricsRecorder == null) {
            if (this.allocator instanceof Reallocator) {
                return (Reallocator)this.allocator;
            }
            return new ReallocatingAdaptor(this.allocator);
        }
        if (this.allocator instanceof Reallocator) {
            return new TimingReallocatorAdaptor((Reallocator)this.allocator, this.metricsRecorder);
        }
        return new TimingReallocatingAdaptor(this.allocator, this.metricsRecorder);
    }
}

