/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import stormpot.Config;
import stormpot.Expiration;
import stormpot.LatchCompletion;
import stormpot.MetricsRecorder;
import stormpot.Poolable;
import stormpot.PreciseLeakDetector;
import stormpot.QSlot;
import stormpot.Reallocator;

final class QAllocThread<T extends Poolable>
implements Runnable {
    private static final long shutdownPauseNanos = TimeUnit.MILLISECONDS.toNanos(10L);
    private final CountDownLatch completionLatch;
    private final BlockingQueue<QSlot<T>> live;
    private final BlockingQueue<QSlot<T>> dead;
    private final Reallocator<T> allocator;
    private final QSlot<T> poisonPill;
    private final MetricsRecorder metricsRecorder;
    private final boolean backgroundExpirationEnabled;
    private final Expiration<? super T> expiration;
    private final PreciseLeakDetector leakDetector;
    private final AtomicInteger poisonedSlots;
    private volatile int targetSize;
    private volatile boolean shutdown;
    private volatile long allocationCount;
    private volatile long failedAllocationCount;
    private int size;

    public QAllocThread(BlockingQueue<QSlot<T>> live, BlockingQueue<QSlot<T>> dead, Config<T> config, QSlot<T> poisonPill) {
        this.targetSize = config.getSize();
        this.completionLatch = new CountDownLatch(1);
        this.allocator = config.getAdaptedReallocator();
        this.size = 0;
        this.live = live;
        this.dead = dead;
        this.poisonPill = poisonPill;
        this.metricsRecorder = config.getMetricsRecorder();
        this.backgroundExpirationEnabled = config.isBackgroundExpirationEnabled();
        this.expiration = config.getExpiration();
        this.leakDetector = config.isPreciseLeakDetectionEnabled() ? new PreciseLeakDetector() : null;
        this.poisonedSlots = new AtomicInteger();
    }

    @Override
    public void run() {
        this.continuouslyReplenishPool();
        this.shutPoolDown();
        this.completionLatch.countDown();
    }

    private void continuouslyReplenishPool() {
        block4: while (true) {
            try {
                while (true) {
                    QSlot slot;
                    long deadPollTimeout;
                    boolean weHaveWorkToDo = this.size != this.targetSize || this.poisonedSlots.get() > 0;
                    long l = deadPollTimeout = weHaveWorkToDo ? 0L : 50L;
                    if (this.size < this.targetSize) {
                        slot = new QSlot<T>(this.live, this.poisonedSlots);
                        this.alloc(slot);
                        this.registerWithLeakDetector(slot);
                    }
                    slot = this.dead.poll(deadPollTimeout, TimeUnit.MILLISECONDS);
                    if (this.size > this.targetSize) {
                        QSlot qSlot = slot = slot == null ? (QSlot)this.live.poll() : slot;
                        if (slot != null) {
                            this.dealloc(slot);
                            this.unregisterWithLeakDetector(slot);
                        }
                    } else if (slot != null) {
                        this.realloc(slot);
                    }
                    if (this.shutdown) break block4;
                    if (this.poisonedSlots.get() > 0) {
                        slot = (QSlot)this.live.poll();
                        if (slot == null) continue;
                        if (slot.poison == null && !slot.expired) {
                            this.live.offer(slot);
                            continue;
                        }
                        this.realloc(slot);
                        continue;
                    }
                    if (!this.backgroundExpirationEnabled || weHaveWorkToDo) continue;
                    slot = (QSlot)this.live.poll();
                    try {
                        if (slot == null) continue block4;
                        if (slot.expired || this.expiration.hasExpired(slot)) {
                            this.dead.offer(slot);
                            continue block4;
                        }
                        this.live.offer(slot);
                        continue block4;
                    }
                    catch (Exception e) {
                        this.dead.offer(slot);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        this.live.offer(this.poisonPill);
    }

    private void registerWithLeakDetector(QSlot<T> slot) {
        if (this.leakDetector != null) {
            this.leakDetector.register(slot);
        }
    }

    private void unregisterWithLeakDetector(QSlot<T> slot) {
        if (this.leakDetector != null) {
            this.leakDetector.unregister(slot);
        }
    }

    private void shutPoolDown() {
        while (this.size > 0) {
            QSlot slot = (QSlot)this.dead.poll();
            if (slot == null) {
                slot = (QSlot)this.live.poll();
            }
            if (slot == this.poisonPill) {
                this.live.offer(this.poisonPill);
                slot = null;
            }
            if (slot == null) {
                LockSupport.parkNanos(shutdownPauseNanos);
                continue;
            }
            this.dealloc(slot);
            this.unregisterWithLeakDetector(slot);
        }
    }

    private void alloc(QSlot<T> slot) {
        try {
            slot.obj = this.allocator.allocate(slot);
            if (slot.obj == null) {
                this.poisonedSlots.getAndIncrement();
                ++this.failedAllocationCount;
                slot.poison = new NullPointerException("Allocation returned null");
            } else {
                ++this.allocationCount;
            }
        }
        catch (Exception e) {
            this.poisonedSlots.getAndIncrement();
            ++this.failedAllocationCount;
            slot.poison = e;
        }
        ++this.size;
        slot.created = System.currentTimeMillis();
        slot.claims = 0L;
        slot.stamp = 0L;
        slot.expired = false;
        slot.claimed.set(true);
        slot.release((Poolable)slot.obj);
    }

    private void dealloc(QSlot<T> slot) {
        --this.size;
        try {
            if (slot.poison == null) {
                this.recordObjectLifetimeSample(System.currentTimeMillis() - slot.created);
                this.allocator.deallocate(slot.obj);
            } else {
                this.poisonedSlots.getAndDecrement();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        slot.poison = null;
        slot.obj = null;
    }

    private void realloc(QSlot<T> slot) {
        if (slot.poison == null) {
            try {
                slot.obj = this.allocator.reallocate(slot, slot.obj);
                if (slot.obj == null) {
                    this.poisonedSlots.getAndIncrement();
                    ++this.failedAllocationCount;
                    slot.poison = new NullPointerException("Reallocation returned null");
                } else {
                    ++this.allocationCount;
                }
            }
            catch (Exception e) {
                this.poisonedSlots.getAndIncrement();
                ++this.failedAllocationCount;
                slot.poison = e;
            }
            long now = System.currentTimeMillis();
            this.recordObjectLifetimeSample(now - slot.created);
            slot.created = now;
            slot.claims = 0L;
            slot.stamp = 0L;
            slot.expired = false;
            this.live.offer(slot);
        } else {
            this.dealloc(slot);
            this.alloc(slot);
        }
    }

    private void recordObjectLifetimeSample(long milliseconds) {
        if (this.metricsRecorder != null) {
            this.metricsRecorder.recordObjectLifetimeSampleMillis(milliseconds);
        }
    }

    void setTargetSize(int size) {
        this.targetSize = size;
    }

    int getTargetSize() {
        return this.targetSize;
    }

    LatchCompletion shutdown(Thread allocatorThread) {
        this.shutdown = true;
        allocatorThread.interrupt();
        return new LatchCompletion(this.completionLatch);
    }

    public long getAllocationCount() {
        return this.allocationCount;
    }

    public long getFailedAllocationCount() {
        return this.failedAllocationCount;
    }

    public long countLeakedObjects() {
        if (this.leakDetector != null) {
            return this.leakDetector.countLeakedObjects();
        }
        return -1L;
    }
}

