/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import stormpot.Allocator;
import stormpot.MetricsRecorder;
import stormpot.Poolable;
import stormpot.ReallocatingAdaptor;
import stormpot.Reallocator;
import stormpot.Slot;

class TimingReallocatingAdaptor<T extends Poolable>
extends ReallocatingAdaptor<T>
implements Reallocator<T> {
    protected final MetricsRecorder metricsRecorder;

    public TimingReallocatingAdaptor(Allocator<T> allocator, MetricsRecorder metricsRecorder) {
        super(allocator);
        this.metricsRecorder = metricsRecorder;
    }

    @Override
    public T allocate(Slot slot) throws Exception {
        long start = System.currentTimeMillis();
        try {
            Object obj = super.allocate(slot);
            long elapsed = System.currentTimeMillis() - start;
            this.metricsRecorder.recordAllocationLatencySampleMillis(elapsed);
            return obj;
        }
        catch (Exception e) {
            long elapsed = System.currentTimeMillis() - start;
            this.metricsRecorder.recordAllocationFailureLatencySampleMillis(elapsed);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deallocate(T poolable) throws Exception {
        long start = System.currentTimeMillis();
        try {
            super.deallocate(poolable);
        }
        finally {
            long elapsed = System.currentTimeMillis() - start;
            this.metricsRecorder.recordDeallocationLatencySampleMillis(elapsed);
        }
    }
}

