/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import stormpot.MetricsRecorder;
import stormpot.Poolable;
import stormpot.Reallocator;
import stormpot.Slot;
import stormpot.TimingReallocatingAdaptor;

final class TimingReallocatorAdaptor<T extends Poolable>
extends TimingReallocatingAdaptor<T>
implements Reallocator<T> {
    public TimingReallocatorAdaptor(Reallocator<T> allocator, MetricsRecorder metricsRecorder) {
        super(allocator, metricsRecorder);
    }

    @Override
    public T reallocate(Slot slot, T poolable) throws Exception {
        long start = System.currentTimeMillis();
        try {
            T obj = ((Reallocator)this.allocator).reallocate(slot, poolable);
            long elapsed = System.currentTimeMillis() - start;
            this.metricsRecorder.recordReallocationLatencySampleMillis(elapsed);
            return obj;
        }
        catch (Exception e) {
            long elapsed = System.currentTimeMillis() - start;
            this.metricsRecorder.recordReallocationFailureLatencySampleMillis(elapsed);
            throw e;
        }
    }
}

