/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.LinkedTransferQueue;
import stormpot.AllocationController;
import stormpot.AllocationProcessMode;
import stormpot.BSlot;
import stormpot.DirectAllocationController;
import stormpot.InlineAllocationController;
import stormpot.PoolBuilder;
import stormpot.Poolable;
import stormpot.RefillPile;
import stormpot.ThreadedAllocationController;

abstract class AllocationProcess {
    private final AllocationProcessMode mode;

    public static AllocationProcess threaded() {
        return new AllocationProcess(AllocationProcessMode.THREADED){

            @Override
            <T extends Poolable> AllocationController<T> buildAllocationController(LinkedTransferQueue<BSlot<T>> live, RefillPile<T> disregardPile, RefillPile<T> newAllocations, PoolBuilder<T> builder, BSlot<T> poisonPill) {
                return new ThreadedAllocationController<T>(live, disregardPile, newAllocations, builder, poisonPill);
            }
        };
    }

    static AllocationProcess inline() {
        return new AllocationProcess(AllocationProcessMode.INLINE){

            @Override
            <T extends Poolable> AllocationController<T> buildAllocationController(LinkedTransferQueue<BSlot<T>> live, RefillPile<T> disregardPile, RefillPile<T> newAllocations, PoolBuilder<T> builder, BSlot<T> poisonPill) {
                return new InlineAllocationController<T>(live, disregardPile, newAllocations, builder, poisonPill);
            }
        };
    }

    static AllocationProcess direct() {
        return new AllocationProcess(AllocationProcessMode.DIRECT){

            @Override
            <T extends Poolable> AllocationController<T> buildAllocationController(LinkedTransferQueue<BSlot<T>> live, RefillPile<T> disregardPile, RefillPile<T> newAllocations, PoolBuilder<T> builder, BSlot<T> poisonPill) {
                return new DirectAllocationController<T>(live, disregardPile, builder, poisonPill);
            }
        };
    }

    protected AllocationProcess(AllocationProcessMode mode) {
        this.mode = mode;
    }

    AllocationProcessMode getMode() {
        return this.mode;
    }

    abstract <T extends Poolable> AllocationController<T> buildAllocationController(LinkedTransferQueue<BSlot<T>> var1, RefillPile<T> var2, RefillPile<T> var3, PoolBuilder<T> var4, BSlot<T> var5);
}

