/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.Objects;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import stormpot.AllocationController;
import stormpot.AllocationProcess;
import stormpot.BSlot;
import stormpot.BSlotCache;
import stormpot.BlazePoolThreadLocalTap;
import stormpot.Completion;
import stormpot.Expiration;
import stormpot.ManagedPool;
import stormpot.MetricsRecorder;
import stormpot.NanoClock;
import stormpot.Pool;
import stormpot.PoolBuilder;
import stormpot.PoolException;
import stormpot.PoolTap;
import stormpot.Poolable;
import stormpot.RefillPile;
import stormpot.ThreadLocalBSlotCache;
import stormpot.Timeout;

final class BlazePool<T extends Poolable>
extends Pool<T>
implements ManagedPool {
    private static final Exception SHUTDOWN_POISON = new Exception("Stormpot Poison: Shutdown");
    static final Exception EXPLICIT_EXPIRE_POISON = new Exception("Stormpot Poison: Expired");
    private final LinkedTransferQueue<BSlot<T>> live = new LinkedTransferQueue();
    private final RefillPile<T> disregardPile = new RefillPile<T>(this.live);
    private final RefillPile<T> newAllocations = new RefillPile<T>(this.live);
    private final AllocationController<T> allocator;
    private final ThreadLocal<BSlotCache<T>> tlr = new ThreadLocalBSlotCache();
    private final Expiration<? super T> deallocRule;
    private final MetricsRecorder metricsRecorder;
    private final BSlot<T> poisonPill = new BSlot<T>(this.live, null);
    private volatile boolean shutdown;

    BlazePool(PoolBuilder<T> builder, AllocationProcess factory) {
        this.poisonPill.poison = SHUTDOWN_POISON;
        this.deallocRule = builder.getExpiration();
        this.metricsRecorder = builder.getMetricsRecorder();
        this.allocator = factory.buildAllocationController(this.live, this.disregardPile, this.newAllocations, builder, this.poisonPill);
    }

    @Override
    public T claim(Timeout timeout) throws PoolException, InterruptedException {
        return this.tlrClaim(timeout, this.tlr.get());
    }

    T tlrClaim(Timeout timeout, BSlotCache<T> cache) throws PoolException, InterruptedException {
        Objects.requireNonNull(timeout, "Timeout cannot be null.");
        BSlot slot = cache.slot;
        if (slot != null && slot.live2claimTlr() && !this.isInvalid(slot, cache, true)) {
            slot.incrementClaims();
            return (T)slot.obj;
        }
        return this.slowClaim(timeout, cache);
    }

    private T slowClaim(Timeout timeout, BSlotCache<T> cache) throws PoolException, InterruptedException {
        BSlot<T> slot;
        long timeoutNanos;
        long startNanos = NanoClock.nanoTime();
        long timeoutLeft = timeoutNanos = timeout.getTimeoutInBaseUnit();
        TimeUnit baseUnit = timeout.getBaseUnit();
        long maxWaitQuantum = baseUnit.convert(100L, TimeUnit.MILLISECONDS);
        while (true) {
            if ((slot = this.newAllocations.pop()) == null) {
                long pollWait = Math.min(timeoutLeft, maxWaitQuantum);
                slot = this.live.poll(pollWait, baseUnit);
            }
            if (slot == null) {
                if (timeoutLeft <= 0L) {
                    return null;
                }
                timeoutLeft = NanoClock.timeoutLeft(startNanos, timeoutNanos);
                this.disregardPile.refill();
                continue;
            }
            if (slot.live2claim()) {
                if (!this.isInvalid(slot, cache, false)) break;
                timeoutLeft = NanoClock.timeoutLeft(startNanos, timeoutNanos);
                if (timeoutLeft > 0L) continue;
                return null;
            }
            this.disregardPile.push(slot);
        }
        slot.incrementClaims();
        cache.slot = slot;
        return (T)slot.obj;
    }

    private boolean isInvalid(BSlot<T> slot, BSlotCache<T> cache, boolean isTlr) {
        if (this.isUncommonlyInvalid(slot)) {
            return this.handleUncommonInvalidation(slot, cache, isTlr);
        }
        try {
            return this.deallocRule.hasExpired(slot) && this.handleCommonInvalidation(slot, cache, null);
        }
        catch (Throwable ex) {
            return this.handleCommonInvalidation(slot, cache, ex);
        }
    }

    private boolean isUncommonlyInvalid(BSlot<T> slot) {
        return this.shutdown | slot.poison != null;
    }

    private boolean handleUncommonInvalidation(BSlot<T> slot, BSlotCache<T> cache, boolean isTlr) {
        Exception poison = slot.poison;
        if (poison != null) {
            return this.dealWithSlotPoison(slot, cache, isTlr, poison);
        }
        this.kill(slot, cache);
        throw new IllegalStateException("Pool has been shut down");
    }

    private boolean handleCommonInvalidation(BSlot<T> slot, BSlotCache<T> cache, Throwable exception) {
        this.kill(slot, cache);
        if (exception != null) {
            String msg = "Got exception when checking whether an object had expired";
            throw new PoolException(msg, exception);
        }
        return true;
    }

    private boolean dealWithSlotPoison(BSlot<T> slot, BSlotCache<T> cache, boolean isTlr, Exception poison) {
        if (poison == SHUTDOWN_POISON) {
            slot.claim2live();
            this.live.offer(this.poisonPill);
            throw new IllegalStateException("Pool has been shut down");
        }
        this.kill(slot, cache);
        if (isTlr || poison == EXPLICIT_EXPIRE_POISON) {
            return true;
        }
        throw new PoolException("Allocation failed", poison);
    }

    private void kill(BSlot<T> slot, BSlotCache<T> cache) {
        if (slot.isClaimed()) {
            slot.claim2dead();
            this.allocator.offerDeadSlot(slot);
        } else {
            slot.claimTlr2live();
            cache.slot = null;
        }
    }

    @Override
    public Completion shutdown() {
        this.shutdown = true;
        return this.allocator.shutdown();
    }

    @Override
    public void setTargetSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Target pool size must be positive");
        }
        if (this.shutdown) {
            return;
        }
        this.allocator.setTargetSize(size);
    }

    @Override
    public int getTargetSize() {
        return this.allocator.getTargetSize();
    }

    @Override
    public ManagedPool getManagedPool() {
        return this;
    }

    @Override
    public PoolTap<T> getThreadLocalTap() {
        return new BlazePoolThreadLocalTap(this);
    }

    @Override
    public long getAllocationCount() {
        return this.allocator.getAllocationCount();
    }

    @Override
    public long getFailedAllocationCount() {
        return this.allocator.getFailedAllocationCount();
    }

    @Override
    public boolean isShutDown() {
        return this.shutdown;
    }

    @Override
    public double getObjectLifetimePercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getObjectLifetimePercentile(percentile);
    }

    @Override
    public double getAllocationLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getAllocationLatencyPercentile(percentile);
    }

    @Override
    public double getAllocationFailureLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getAllocationFailureLatencyPercentile(percentile);
    }

    @Override
    public double getReallocationLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getReallocationLatencyPercentile(percentile);
    }

    @Override
    public double getReallocationFailureLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getReallocationFailurePercentile(percentile);
    }

    @Override
    public double getDeallocationLatencyPercentile(double percentile) {
        if (this.metricsRecorder == null) {
            return Double.NaN;
        }
        return this.metricsRecorder.getDeallocationLatencyPercentile(percentile);
    }

    @Override
    public long getLeakedObjectsCount() {
        return this.allocator.countLeakedObjects();
    }
}

