/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.Objects;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import stormpot.AllocationController;
import stormpot.Allocator;
import stormpot.BSlot;
import stormpot.Completion;
import stormpot.NanoClock;
import stormpot.PoolBuilder;
import stormpot.Poolable;
import stormpot.RefillPile;

class DirectAllocationController<T extends Poolable>
extends AllocationController<T> {
    private final LinkedTransferQueue<BSlot<T>> live;
    private final RefillPile<T> disregardPile;
    private final BSlot<T> poisonPill;
    private final int size;
    private final AtomicInteger shutdownState;
    private final AtomicInteger poisonedSlots;

    DirectAllocationController(LinkedTransferQueue<BSlot<T>> live, RefillPile<T> disregardPile, PoolBuilder<T> builder, BSlot<T> poisonPill) {
        this.live = live;
        this.disregardPile = disregardPile;
        this.poisonPill = poisonPill;
        this.size = builder.getSize();
        this.poisonedSlots = new AtomicInteger();
        Allocator<T> allocator = builder.getAllocator();
        for (int i = 0; i < this.size; ++i) {
            BSlot<T> slot = new BSlot<T>(live, this.poisonedSlots);
            try {
                slot.obj = allocator.allocate(slot);
                slot.createdNanos = System.nanoTime();
                slot.dead2live();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected exception.", e);
            }
            live.offer(slot);
        }
        this.shutdownState = new AtomicInteger(this.size);
    }

    @Override
    Completion shutdown() {
        this.poisonPill.dead2live();
        this.live.offer(this.poisonPill);
        return timeout -> {
            BSlot<T> slot;
            long timeoutNanos;
            Objects.requireNonNull(timeout, "Timeout cannot be null.");
            if (Thread.interrupted()) {
                throw new InterruptedException("Interrupted while waiting for pool shut down to complete.");
            }
            TimeUnit unit = timeout.getBaseUnit();
            long startNanos = NanoClock.nanoTime();
            long timeoutLeft = timeoutNanos = timeout.getTimeoutInBaseUnit();
            this.disregardPile.refill();
            while (this.shutdownState.get() > 0 && (slot = this.live.poll(timeoutLeft, unit)) != null) {
                if (slot != this.poisonPill) {
                    this.shutdownState.getAndDecrement();
                }
                this.disregardPile.refill();
                timeoutLeft = NanoClock.timeoutLeft(startNanos, timeoutNanos);
            }
            this.live.offer(this.poisonPill);
            return this.shutdownState.get() == 0;
        };
    }

    @Override
    void offerDeadSlot(BSlot<T> slot) {
        if (slot.poison != null) {
            slot.poison = null;
            this.poisonedSlots.getAndDecrement();
        }
        slot.dead2live();
        this.live.offer(slot);
    }

    @Override
    void setTargetSize(int size) {
        throw new UnsupportedOperationException("Target size cannot be changed. This pool was created with a fixed set of objects using the Pool.of(...) method. Attempted to set target size to " + size + ".");
    }

    @Override
    int getTargetSize() {
        return this.size;
    }

    @Override
    long getAllocationCount() {
        return this.size;
    }

    @Override
    long getFailedAllocationCount() {
        return 0L;
    }

    @Override
    long countLeakedObjects() {
        return -1L;
    }
}

