/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.TimeUnit;
import stormpot.Expiration;
import stormpot.Poolable;
import stormpot.SlotInfo;
import stormpot.TimeSpreadExpiration;

final class EveryExpiration<T extends Poolable>
implements Expiration<T> {
    private final Expiration<T> innerExpiration;
    private final TimeSpreadExpiration<T> timeExpiration;

    EveryExpiration(Expiration<T> innerExpiration, long fromTime, long toTime, TimeUnit unit) {
        this.innerExpiration = innerExpiration;
        this.timeExpiration = new TimeSpreadExpiration(fromTime, toTime, unit);
    }

    @Override
    public boolean hasExpired(SlotInfo<? extends T> info) throws Exception {
        if (this.timeExpiration.hasExpired(info)) {
            info.setStamp(info.getStamp() + this.timeExpiration.computeExpirationDeadline());
            return this.innerExpiration.hasExpired(info);
        }
        return false;
    }
}

