/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import stormpot.AllocationProcess;
import stormpot.Allocator;
import stormpot.Completion;
import stormpot.ManagedPool;
import stormpot.PoolBuilder;
import stormpot.PoolException;
import stormpot.PoolTap;
import stormpot.Poolable;
import stormpot.Pooled;
import stormpot.Slot;
import stormpot.Timeout;

public abstract class Pool<T extends Poolable>
extends PoolTap<T> {
    Pool() {
    }

    public static <T extends Poolable> PoolBuilder<T> from(Allocator<T> allocator) {
        return Pool.fromThreaded(allocator);
    }

    public static <T extends Poolable> PoolBuilder<T> fromThreaded(Allocator<T> allocator) {
        return new PoolBuilder<T>(AllocationProcess.threaded(), allocator);
    }

    public static <T extends Poolable> PoolBuilder<T> fromInline(Allocator<T> allocator) {
        return new PoolBuilder<T>(AllocationProcess.inline(), allocator);
    }

    @SafeVarargs
    public static <T> Pool<Pooled<T>> of(final T ... objects) {
        Allocator allocator = new Allocator<Pooled<T>>(){
            private int index;

            @Override
            public Pooled<T> allocate(Slot slot) {
                return new Pooled<Object>(slot, objects[this.index++]);
            }

            @Override
            public void deallocate(Pooled<T> poolable) {
            }
        };
        PoolBuilder builder = new PoolBuilder(AllocationProcess.direct(), allocator);
        builder.setSize(objects.length);
        return builder.build();
    }

    public abstract Completion shutdown();

    public abstract void setTargetSize(int var1);

    public abstract int getTargetSize();

    public abstract ManagedPool getManagedPool();

    public final PoolTap<T> getThreadSafeTap() {
        return new PoolTap<T>(){

            @Override
            public T claim(Timeout timeout) throws PoolException, InterruptedException {
                return Pool.this.claim(timeout);
            }
        };
    }

    public abstract PoolTap<T> getThreadLocalTap();
}

