/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import stormpot.Allocator;
import stormpot.Poolable;
import stormpot.Reallocator;
import stormpot.Slot;

class ReallocatingAdaptor<T extends Poolable>
implements Reallocator<T> {
    final Allocator<T> allocator;

    ReallocatingAdaptor(Allocator<T> allocator) {
        this.allocator = allocator;
    }

    @Override
    public T reallocate(Slot slot, T poolable) throws Exception {
        try {
            this.allocator.deallocate(poolable);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.allocator.allocate(slot);
    }

    @Override
    public T allocate(Slot slot) throws Exception {
        return this.allocator.allocate(slot);
    }

    @Override
    public void deallocate(T poolable) throws Exception {
        this.allocator.deallocate(poolable);
    }

    Allocator<T> unwrap() {
        return this.allocator;
    }
}

