/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import stormpot.BSlot;
import stormpot.Poolable;
import stormpot.RefillSlot;

final class RefillPile<T extends Poolable>
extends AtomicReference<RefillSlot<T>> {
    private static final long serialVersionUID = 2374582348576873465L;
    private static final RefillSlot<Poolable> STACK_END = new RefillSlot(null);
    private final BlockingQueue<BSlot<T>> refillQueue;

    RefillPile(BlockingQueue<BSlot<T>> refillQueue) {
        this.refillQueue = refillQueue;
        this.set(STACK_END);
    }

    void push(BSlot<T> slot) {
        RefillSlot<T> element = new RefillSlot<T>(slot);
        element.next = this.getAndSet(element);
    }

    BSlot<T> pop() {
        RefillSlot element;
        RefillSlot next;
        do {
            if ((element = (RefillSlot)this.get()) != STACK_END) continue;
            return null;
        } while ((next = element.next) == null && this.pause() || !this.compareAndSet(element, next));
        return element.slot;
    }

    private boolean pause() {
        Thread.onSpinWait();
        return true;
    }

    boolean refill() {
        RefillSlot<Poolable> stack = this.getAndSet(STACK_END);
        int count = 0;
        while (stack != STACK_END) {
            RefillSlot next;
            ++count;
            this.refillQueue.offer(stack.slot);
            while ((next = stack.next) == null) {
            }
            stack = next;
        }
        return count > 0;
    }

    @Override
    public String toString() {
        RefillSlot currentValue = (RefillSlot)this.get();
        return "RefillPile[" + (currentValue == STACK_END ? "EMPTY" : currentValue) + "]";
    }
}

