/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import stormpot.Expiration;
import stormpot.Poolable;
import stormpot.SlotInfo;

final class TimeExpiration<T extends Poolable>
implements Expiration<T> {
    private final long maxPermittedAgeMillis;
    private final TimeUnit unit;

    TimeExpiration(long maxPermittedAge, TimeUnit unit) {
        Objects.requireNonNull(unit, "TimeUnit cannot be null.");
        if (maxPermittedAge < 1L) {
            throw new IllegalArgumentException("Max permitted age cannot be less than 1");
        }
        this.maxPermittedAgeMillis = unit.toMillis(maxPermittedAge);
        this.unit = unit;
    }

    @Override
    public boolean hasExpired(SlotInfo<? extends T> info) {
        return info.getAgeMillis() > this.maxPermittedAgeMillis;
    }

    public String toString() {
        long time = this.unit.convert(this.maxPermittedAgeMillis, TimeUnit.MILLISECONDS);
        return "TimeExpiration(" + time + " " + this.unit + ")";
    }
}

