/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import stormpot.NanoClock;

public final class Timeout {
    private final long timeout;
    private final TimeUnit unit;
    private final long timeoutBase;

    public Timeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull(unit, "The TimeUnit cannot be null.");
        this.timeout = timeout;
        this.unit = unit;
        this.timeoutBase = this.getBaseUnit().convert(timeout, unit);
    }

    public Timeout(Duration duration) {
        Objects.requireNonNull(duration, "Duration cannot be null.");
        this.timeout = duration.toNanos();
        this.unit = TimeUnit.NANOSECONDS;
        this.timeoutBase = this.timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    @Deprecated(forRemoval=true)
    public long getDeadline() {
        return NanoClock.nanoTime() + this.timeoutBase;
    }

    public long getTimeoutInBaseUnit() {
        return this.timeoutBase;
    }

    @Deprecated(forRemoval=true)
    public long getTimeLeft(long deadline) {
        return deadline - NanoClock.nanoTime();
    }

    public TimeUnit getBaseUnit() {
        return TimeUnit.NANOSECONDS;
    }

    public int hashCode() {
        return 31 * (1 + (int)(this.timeoutBase ^ this.timeoutBase >>> 32));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Timeout)) {
            return false;
        }
        Timeout that = (Timeout)obj;
        return this.timeoutBase == that.timeoutBase;
    }
}

