/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import stormpot.BSlot;
import stormpot.BlazePool;
import stormpot.Completion;
import stormpot.Expiration;
import stormpot.LatchCompletion;
import stormpot.MetricsRecorder;
import stormpot.NanoClock;
import stormpot.PoolBuilder;
import stormpot.Poolable;
import stormpot.PreciseLeakDetector;
import stormpot.Reallocator;
import stormpot.RefillPile;

final class BAllocThread<T extends Poolable>
implements Runnable {
    private static final long shutdownPauseNanos = TimeUnit.MILLISECONDS.toNanos(10L);
    private final LinkedTransferQueue<BSlot<T>> live;
    private final RefillPile<T> disregardPile;
    private final RefillPile<T> newAllocations;
    private final Reallocator<T> allocator;
    private final BSlot<T> poisonPill;
    private final MetricsRecorder metricsRecorder;
    private final Expiration<? super T> expiration;
    private final boolean backgroundExpirationEnabled;
    private final PreciseLeakDetector leakDetector;
    private final CountDownLatch completionLatch;
    private final BlockingQueue<BSlot<T>> dead;
    private final AtomicInteger poisonedSlots;
    private final long defaultDeadPollTimeout;
    private volatile int targetSize;
    private volatile boolean shutdown;
    private volatile long allocationCount;
    private volatile long failedAllocationCount;
    private int size;
    private boolean didAnythingLastIteration;
    private long consecutiveAllocationFailures;

    BAllocThread(LinkedTransferQueue<BSlot<T>> live, RefillPile<T> disregardPile, RefillPile<T> newAllocations, PoolBuilder<T> builder, BSlot<T> poisonPill) {
        this.live = live;
        this.disregardPile = disregardPile;
        this.newAllocations = newAllocations;
        this.allocator = builder.getAdaptedReallocator();
        this.targetSize = builder.getSize();
        this.metricsRecorder = builder.getMetricsRecorder();
        this.poisonPill = poisonPill;
        this.expiration = builder.getExpiration();
        this.backgroundExpirationEnabled = builder.isBackgroundExpirationEnabled();
        this.leakDetector = builder.isPreciseLeakDetectionEnabled() ? new PreciseLeakDetector() : null;
        this.completionLatch = new CountDownLatch(1);
        this.dead = new LinkedTransferQueue<BSlot<T>>();
        this.poisonedSlots = new AtomicInteger();
        this.defaultDeadPollTimeout = builder.getBackgroundExpirationCheckDelay();
        this.size = 0;
        this.didAnythingLastIteration = true;
    }

    @Override
    public void run() {
        this.continuouslyReplenishPool();
        this.shutPoolDown();
        this.completionLatch.countDown();
    }

    private void continuouslyReplenishPool() {
        try {
            while (!this.shutdown) {
                this.replenishPool();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.poisonPill.dead2live();
        this.live.offer(this.poisonPill);
    }

    private void replenishPool() throws InterruptedException {
        BSlot<T> slot;
        long deadPollTimeout = this.computeDeadPollTimeout();
        BSlot<T> bSlot = slot = deadPollTimeout == 0L ? (BSlot<T>)this.dead.poll() : this.dead.poll(deadPollTimeout, TimeUnit.MILLISECONDS);
        if (this.size < this.targetSize) {
            this.increaseSizeByAllocating();
        }
        if (this.size > this.targetSize) {
            this.reduceSizeByDeallocating(slot);
        } else if (slot != null) {
            this.reallocateDeadSlot(slot);
        }
        if (this.shutdown) {
            return;
        }
        if (this.poisonedSlots.get() > 0) {
            this.proactivelyHealPoison();
        } else if (this.backgroundExpirationEnabled && this.size == this.targetSize) {
            this.backgroundExpirationCheck();
        }
    }

    private long computeDeadPollTimeout() {
        long deadPollTimeout = this.defaultDeadPollTimeout;
        if (this.size != this.targetSize || this.poisonedSlots.get() > 0) {
            deadPollTimeout = this.didAnythingLastIteration ? 0 : 10;
            deadPollTimeout += Math.min(this.consecutiveAllocationFailures, this.defaultDeadPollTimeout - deadPollTimeout);
        }
        this.didAnythingLastIteration = false;
        return deadPollTimeout;
    }

    private void increaseSizeByAllocating() {
        BSlot<T> slot = new BSlot<T>(this.live, this.poisonedSlots);
        this.alloc(slot);
        this.registerWithLeakDetector(slot);
    }

    private void reduceSizeByDeallocating(BSlot<T> slot) {
        if (slot == null || !this.didAnythingLastIteration) {
            this.disregardPile.refill();
            this.newAllocations.refill();
        }
        BSlot<T> bSlot = slot = slot == null ? this.live.poll() : slot;
        if (slot != null) {
            if (slot.isDead() || slot.live2dead()) {
                this.dealloc(slot);
                this.unregisterWithLeakDetector(slot);
            } else {
                this.live.offer(slot);
            }
        }
    }

    private void registerWithLeakDetector(BSlot<T> slot) {
        if (this.leakDetector != null) {
            this.leakDetector.register(slot);
        }
    }

    private void unregisterWithLeakDetector(BSlot<T> slot) {
        if (this.leakDetector != null) {
            this.leakDetector.unregister(slot);
        }
    }

    private void reallocateDeadSlot(BSlot<T> slot) {
        this.realloc(slot);
    }

    private void proactivelyHealPoison() {
        BSlot<T> slot = this.live.poll();
        if (slot != null) {
            if (slot.poison != null && (slot.isDead() || slot.live2dead())) {
                this.realloc(slot);
            } else {
                this.live.offer(slot);
            }
        }
    }

    private void backgroundExpirationCheck() {
        BSlot<T> slot;
        this.disregardPile.refill();
        if (!this.didAnythingLastIteration) {
            this.newAllocations.refill();
        }
        if ((slot = this.live.poll()) == null) {
            this.newAllocations.refill();
            slot = this.live.poll();
        }
        if (slot != null) {
            if (slot.isLive() && slot.live2claim()) {
                boolean expired;
                try {
                    expired = slot.poison != null || this.expiration.hasExpired(slot);
                }
                catch (Exception ignore) {
                    expired = true;
                }
                if (expired) {
                    slot.claim2dead();
                    this.dead.offer(slot);
                    this.didAnythingLastIteration = true;
                } else {
                    slot.claim2live();
                    this.live.offer(slot);
                }
            } else {
                this.live.offer(slot);
            }
        }
    }

    private void shutPoolDown() {
        while (this.size > 0) {
            BSlot<T> slot = (BSlot<T>)this.dead.poll();
            if (slot == null) {
                slot = this.live.poll();
            }
            if (slot == this.poisonPill) {
                this.live.offer(this.poisonPill);
                slot = null;
            }
            if (slot == null) {
                if (this.disregardPile.refill() || this.newAllocations.refill()) continue;
                LockSupport.parkNanos(shutdownPauseNanos);
                continue;
            }
            if (slot.isDead() || slot.live2dead()) {
                this.dealloc(slot);
                this.unregisterWithLeakDetector(slot);
                continue;
            }
            this.live.offer(slot);
        }
    }

    private void alloc(BSlot<T> slot) {
        boolean success = false;
        try {
            slot.obj = this.allocator.allocate(slot);
            if (slot.obj == null) {
                this.poisonedSlots.getAndIncrement();
                slot.poison = new NullPointerException("Allocation returned null.");
            } else {
                success = true;
            }
        }
        catch (Exception e) {
            this.poisonedSlots.getAndIncrement();
            slot.poison = e;
        }
        ++this.size;
        this.publishSlot(slot, success, NanoClock.nanoTime());
        this.didAnythingLastIteration = true;
    }

    private void publishSlot(BSlot<T> slot, boolean success, long now) {
        this.resetSlot(slot, now);
        if (success && !this.live.hasWaitingConsumer()) {
            this.newAllocations.push(slot);
        } else {
            this.live.offer(slot);
        }
        this.incrementAllocationCounts(success);
    }

    private void incrementAllocationCounts(boolean success) {
        if (success) {
            ++this.allocationCount;
            this.consecutiveAllocationFailures = 0L;
        } else {
            ++this.failedAllocationCount;
            ++this.consecutiveAllocationFailures;
        }
    }

    private void resetSlot(BSlot<T> slot, long now) {
        slot.createdNanos = now;
        slot.claims = 0L;
        slot.stamp = 0L;
        slot.dead2live();
    }

    private void dealloc(BSlot<T> slot) {
        --this.size;
        try {
            if (slot.poison == BlazePool.EXPLICIT_EXPIRE_POISON) {
                slot.poison = null;
                this.poisonedSlots.getAndDecrement();
            }
            if (slot.poison == null) {
                this.recordObjectLifetimeSample(NanoClock.elapsed(slot.createdNanos));
                this.allocator.deallocate(slot.obj);
            } else {
                this.poisonedSlots.getAndDecrement();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        slot.poison = null;
        slot.obj = null;
        this.didAnythingLastIteration = true;
    }

    private void realloc(BSlot<T> slot) {
        if (slot.poison == BlazePool.EXPLICIT_EXPIRE_POISON) {
            slot.poison = null;
            this.poisonedSlots.getAndDecrement();
        }
        if (slot.poison == null) {
            boolean success = false;
            try {
                slot.obj = this.allocator.reallocate(slot, slot.obj);
                if (slot.obj == null) {
                    this.poisonedSlots.getAndIncrement();
                    slot.poison = new NullPointerException("Reallocation returned null.");
                } else {
                    success = true;
                }
            }
            catch (Exception e) {
                this.poisonedSlots.getAndIncrement();
                slot.poison = e;
            }
            long now = NanoClock.nanoTime();
            this.recordObjectLifetimeSample(now - slot.createdNanos);
            this.publishSlot(slot, success, now);
        } else {
            this.dealloc(slot);
            this.alloc(slot);
        }
        this.didAnythingLastIteration = true;
    }

    private void recordObjectLifetimeSample(long nanoseconds) {
        if (this.metricsRecorder != null) {
            long milliseconds = TimeUnit.NANOSECONDS.toMillis(nanoseconds);
            this.metricsRecorder.recordObjectLifetimeSampleMillis(milliseconds);
        }
    }

    void setTargetSize(int size) {
        this.targetSize = size;
    }

    int getTargetSize() {
        return this.targetSize;
    }

    Completion shutdown(Thread allocatorThread) {
        this.shutdown = true;
        allocatorThread.interrupt();
        return new LatchCompletion(this.completionLatch);
    }

    long getAllocationCount() {
        return this.allocationCount;
    }

    long getFailedAllocationCount() {
        return this.failedAllocationCount;
    }

    long countLeakedObjects() {
        if (this.leakDetector != null) {
            return this.leakDetector.countLeakedObjects();
        }
        return -1L;
    }

    void offerDeadSlot(BSlot<T> slot) {
        this.dead.offer(slot);
    }

    int allocatedSize() {
        return this.size;
    }

    int inUse() {
        int inUse = 0;
        int liveSize = 0;
        for (BSlot<T> slot : this.live) {
            ++liveSize;
            if (!slot.isClaimedOrThreadLocal()) continue;
            ++inUse;
        }
        return this.size - liveSize + inUse;
    }
}

