/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import stormpot.BSlotColdFields;
import stormpot.BlazePool;
import stormpot.NanoClock;
import stormpot.PoolException;
import stormpot.Poolable;

final class BSlot<T extends Poolable>
extends BSlotColdFields<T> {
    private static final int CLAIMED = 1;
    private static final int TLR_CLAIMED = 2;
    private static final int LIVING = 3;
    private static final int DEAD = 4;

    BSlot(BlockingQueue<BSlot<T>> live, AtomicInteger poisonedSlots) {
        super(4, live, poisonedSlots);
    }

    @Override
    public void release(Poolable obj) {
        if (this.poison == BlazePool.EXPLICIT_EXPIRE_POISON) {
            this.poisonedSlots.getAndIncrement();
        }
        int slotState = this.getClaimState();
        this.lazySet(3);
        if (slotState == 1) {
            this.live.offer(this);
        }
    }

    private int getClaimState() {
        int slotState = this.get();
        if (slotState > 2) {
            throw this.badStateOnTransitionToLive(slotState);
        }
        return slotState;
    }

    private PoolException badStateOnTransitionToLive(int slotState) {
        Object state;
        switch (slotState) {
            case 4: {
                state = "DEAD";
                break;
            }
            case 3: {
                state = "LIVING";
                break;
            }
            default: {
                state = "STATE[" + slotState + "]";
            }
        }
        return new PoolException("Slot release from bad state: " + (String)state + ". You most likely called release() twice on the same object.");
    }

    void claim2live() {
        this.lazySet(3);
    }

    void claimTlr2live() {
        this.lazySet(3);
    }

    void dead2live() {
        this.lazySet(3);
    }

    void claim2dead() {
        this.lazySet(4);
    }

    boolean live2claim() {
        return this.compareAndSet(3, 1);
    }

    boolean live2claimTlr() {
        return this.compareAndSet(3, 2);
    }

    boolean live2dead() {
        return this.compareAndSet(3, 4);
    }

    @Override
    public long getAgeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(NanoClock.elapsed(this.createdNanos));
    }

    @Override
    public long getClaimCount() {
        return this.claims;
    }

    @Override
    public T getPoolable() {
        return (T)this.obj;
    }

    boolean isDead() {
        return this.get() == 4;
    }

    boolean isLive() {
        return this.get() == 3;
    }

    boolean isClaimed() {
        return this.get() == 1;
    }

    boolean isClaimedOrThreadLocal() {
        int state = this.get();
        return state == 1 || state == 2;
    }

    void incrementClaims() {
        ++this.claims;
    }

    @Override
    public long getStamp() {
        return this.stamp;
    }

    @Override
    public void setStamp(long stamp) {
        this.stamp = stamp;
    }

    public String toString() {
        int state = this.get();
        Object s = state == 1 ? "CLAIMED" : (state == 2 ? "TLR_CLAIMED" : (state == 3 ? "LIVING" : (state == 4 ? "DEAD" : "UnknownState(" + state + ")")));
        return "BSolt[" + (String)s + ", obj = " + this.obj + ", poison = " + this.poison + "]";
    }
}

