/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import stormpot.AllocationController;
import stormpot.BSlot;
import stormpot.BlazePool;
import stormpot.Completion;
import stormpot.MetricsRecorder;
import stormpot.NanoClock;
import stormpot.PoolBuilder;
import stormpot.Poolable;
import stormpot.PreciseLeakDetector;
import stormpot.Reallocator;
import stormpot.RefillPile;
import stormpot.Timeout;

class InlineAllocationController<T extends Poolable>
extends AllocationController<T> {
    private static final VarHandle SIZE;
    private static final VarHandle ALLOC_COUNT;
    private static final VarHandle FAILED_ALLOC_COUNT;
    private final LinkedTransferQueue<BSlot<T>> live;
    private final RefillPile<T> disregardPile;
    private final RefillPile<T> newAllocations;
    private final BSlot<T> poisonPill;
    private final MetricsRecorder metricsRecorder;
    private final AtomicInteger poisonedSlots;
    private final PreciseLeakDetector leakDetector;
    private final Reallocator<T> allocator;
    private volatile int targetSize;
    private volatile int size;
    private volatile boolean shutdown;
    private volatile long allocationCount;
    private volatile long failedAllocationCount;

    InlineAllocationController(LinkedTransferQueue<BSlot<T>> live, RefillPile<T> disregardPile, RefillPile<T> newAllocations, PoolBuilder<T> builder, BSlot<T> poisonPill) {
        this.live = live;
        this.disregardPile = disregardPile;
        this.newAllocations = newAllocations;
        this.poisonPill = poisonPill;
        this.metricsRecorder = builder.getMetricsRecorder();
        this.poisonedSlots = new AtomicInteger();
        this.allocator = builder.getAdaptedReallocator();
        this.leakDetector = builder.isPreciseLeakDetectionEnabled() ? new PreciseLeakDetector() : null;
        this.setTargetSize(builder.getSize());
    }

    @Override
    void offerDeadSlot(BSlot<T> slot) {
        if (this.shutdown) {
            this.dealloc(slot);
        } else {
            int s = this.size;
            while (s > this.targetSize) {
                if (!SIZE.compareAndSet(this, s, s - 1)) continue;
                this.deallocSlot(slot);
                return;
            }
            this.realloc(slot);
        }
    }

    @Override
    synchronized Completion shutdown() {
        if (!this.shutdown) {
            BSlot<T> slot;
            this.shutdown = true;
            this.disregardPile.refill();
            this.newAllocations.refill();
            ArrayList<BSlot<T>> deferredSlots = new ArrayList<BSlot<T>>();
            while ((slot = this.live.poll()) != null) {
                if (slot.isDead() || slot.live2dead()) {
                    this.dealloc(slot);
                    this.unregisterWithLeakDetector(slot);
                    this.disregardPile.refill();
                    continue;
                }
                deferredSlots.add(slot);
            }
            for (BSlot bSlot : deferredSlots) {
                this.live.offer(bSlot);
            }
            this.poisonPill.dead2live();
            this.live.offer(this.poisonPill);
        }
        return this::shutdownCompletion;
    }

    private boolean shutdownCompletion(Timeout timeout) throws InterruptedException {
        long timeoutNanos;
        Objects.requireNonNull(timeout);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.size == 0) {
            return true;
        }
        long startNanos = NanoClock.nanoTime();
        long timeoutLeft = timeoutNanos = timeout.getTimeoutInBaseUnit();
        TimeUnit baseUnit = timeout.getBaseUnit();
        long maxWaitQuantum = baseUnit.convert(100L, TimeUnit.MILLISECONDS);
        this.disregardPile.refill();
        while (this.size > 0) {
            if (timeoutLeft <= 0L) {
                return false;
            }
            long pollWait = Math.min(timeoutLeft, maxWaitQuantum);
            BSlot<T> slot = this.live.poll(pollWait, baseUnit);
            if (slot == this.poisonPill) {
                slot = this.live.poll(pollWait, baseUnit);
                this.live.offer(this.poisonPill);
            }
            timeoutLeft = NanoClock.timeoutLeft(startNanos, timeoutNanos);
            if (slot == null) {
                this.disregardPile.refill();
                continue;
            }
            if (slot.isDead() || slot.live2dead()) {
                this.dealloc(slot);
                this.unregisterWithLeakDetector(slot);
                continue;
            }
            this.live.offer(slot);
        }
        return true;
    }

    @Override
    synchronized void setTargetSize(int targetSize) {
        if (this.shutdown) {
            return;
        }
        this.targetSize = targetSize;
        this.changePoolSize(targetSize);
    }

    @Override
    int getTargetSize() {
        return this.targetSize;
    }

    @Override
    long getAllocationCount() {
        return this.allocationCount;
    }

    @Override
    long getFailedAllocationCount() {
        return this.failedAllocationCount;
    }

    @Override
    long countLeakedObjects() {
        if (this.leakDetector != null) {
            return this.leakDetector.countLeakedObjects();
        }
        return -1L;
    }

    private void registerWithLeakDetector(BSlot<T> slot) {
        if (this.leakDetector != null) {
            this.leakDetector.register(slot);
        }
    }

    private void unregisterWithLeakDetector(BSlot<T> slot) {
        if (this.leakDetector != null) {
            this.leakDetector.unregister(slot);
        }
    }

    private void changePoolSize(int targetSize) {
        while (this.size != targetSize) {
            if (this.size < targetSize) {
                this.allocate();
                continue;
            }
            if (this.tryDeallocate()) continue;
            return;
        }
    }

    private void allocate() {
        BSlot<T> slot = new BSlot<T>(this.live, this.poisonedSlots);
        this.alloc(slot);
        this.registerWithLeakDetector(slot);
    }

    private void alloc(BSlot<T> slot) {
        boolean success = false;
        try {
            slot.obj = this.allocator.allocate(slot);
            if (slot.obj == null) {
                this.poisonedSlots.getAndIncrement();
                slot.poison = new NullPointerException("Allocation returned null.");
            } else {
                success = true;
            }
        }
        catch (Exception e) {
            this.poisonedSlots.getAndIncrement();
            slot.poison = e;
        }
        SIZE.getAndAdd(this, 1);
        this.publishSlot(slot, success, NanoClock.nanoTime());
    }

    private void publishSlot(BSlot<T> slot, boolean success, long now) {
        this.resetSlot(slot, now);
        if (success && !this.live.hasWaitingConsumer()) {
            this.newAllocations.push(slot);
        } else {
            this.live.offer(slot);
        }
        this.incrementAllocationCounts(success);
    }

    private void incrementAllocationCounts(boolean success) {
        if (success) {
            ALLOC_COUNT.getAndAdd(this, 1);
        } else {
            FAILED_ALLOC_COUNT.getAndAdd(this, 1);
        }
    }

    private void resetSlot(BSlot<T> slot, long now) {
        slot.createdNanos = now;
        slot.claims = 0L;
        slot.stamp = 0L;
        slot.dead2live();
    }

    private boolean tryDeallocate() {
        BSlot<T> slot = this.live.poll();
        if (slot == null) {
            if (!this.disregardPile.refill()) {
                this.newAllocations.refill();
            }
            slot = this.live.poll();
        }
        boolean firstIteration = true;
        while (slot != null) {
            if (slot.isDead() || slot.live2dead()) {
                this.dealloc(slot);
                this.unregisterWithLeakDetector(slot);
                return true;
            }
            if (firstIteration) {
                this.disregardPile.refill();
                this.newAllocations.refill();
                firstIteration = false;
            }
            this.disregardPile.push(slot);
            slot = this.live.poll();
        }
        return false;
    }

    private void dealloc(BSlot<T> slot) {
        SIZE.getAndAdd(this, -1);
        this.deallocSlot(slot);
    }

    private void deallocSlot(BSlot<T> slot) {
        try {
            if (slot.poison == BlazePool.EXPLICIT_EXPIRE_POISON) {
                slot.poison = null;
                this.poisonedSlots.getAndDecrement();
            }
            if (slot.poison == null) {
                this.recordObjectLifetimeSample(NanoClock.elapsed(slot.createdNanos));
                this.allocator.deallocate(slot.obj);
            } else {
                this.poisonedSlots.getAndDecrement();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        slot.poison = null;
        slot.obj = null;
    }

    private void realloc(BSlot<T> slot) {
        if (slot.poison == BlazePool.EXPLICIT_EXPIRE_POISON) {
            slot.poison = null;
            this.poisonedSlots.getAndDecrement();
        }
        if (slot.poison == null) {
            boolean success = false;
            try {
                slot.obj = this.allocator.reallocate(slot, slot.obj);
                if (slot.obj == null) {
                    this.poisonedSlots.getAndIncrement();
                    slot.poison = new NullPointerException("Reallocation returned null.");
                } else {
                    success = true;
                }
            }
            catch (Exception e) {
                this.poisonedSlots.getAndIncrement();
                slot.poison = e;
            }
            long now = NanoClock.nanoTime();
            this.recordObjectLifetimeSample(now - slot.createdNanos);
            this.publishSlot(slot, success, now);
        } else {
            this.dealloc(slot);
            this.alloc(slot);
        }
    }

    private void recordObjectLifetimeSample(long nanoseconds) {
        if (this.metricsRecorder != null) {
            long milliseconds = TimeUnit.NANOSECONDS.toMillis(nanoseconds);
            this.metricsRecorder.recordObjectLifetimeSampleMillis(milliseconds);
        }
    }

    @Override
    public int allocatedSize() {
        return this.live.size() - this.poisonedSlots.get();
    }

    @Override
    int inUse() {
        int inUse = 0;
        int liveSize = 0;
        for (BSlot<T> slot : this.live) {
            ++liveSize;
            if (!slot.isClaimedOrThreadLocal()) continue;
            ++inUse;
        }
        return this.size - liveSize + inUse;
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<InlineAllocationController> receiver = InlineAllocationController.class;
            SIZE = lookup.findVarHandle(receiver, "size", Integer.TYPE);
            ALLOC_COUNT = lookup.findVarHandle(receiver, "allocationCount", Long.TYPE);
            FAILED_ALLOC_COUNT = lookup.findVarHandle(receiver, "failedAllocationCount", Long.TYPE);
        }
        catch (Exception e) {
            throw new LinkageError("Failed to create VarHandle.", e);
        }
    }
}

