/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import stormpot.AllocationProcess;
import stormpot.AllocationProcessMode;
import stormpot.Allocator;
import stormpot.BlazePool;
import stormpot.Expiration;
import stormpot.MetricsRecorder;
import stormpot.Pool;
import stormpot.PoolBuilderDefaults;
import stormpot.PoolBuilderPermissions;
import stormpot.Poolable;
import stormpot.ReallocatingAdaptor;
import stormpot.Reallocator;
import stormpot.StormpotThreadFactory;
import stormpot.TimingReallocatingAdaptor;
import stormpot.TimingReallocatorAdaptor;

public final class PoolBuilder<T extends Poolable>
implements Cloneable {
    static final Map<AllocationProcessMode, PoolBuilderDefaults> DEFAULTS = Map.of(AllocationProcessMode.THREADED, new PoolBuilderDefaults(Expiration.after(8L, 10L, TimeUnit.MINUTES), StormpotThreadFactory.INSTANCE, true, true, 1000), AllocationProcessMode.INLINE, new PoolBuilderDefaults(Expiration.after(8L, 10L, TimeUnit.MINUTES), StormpotThreadFactory.INSTANCE, true, false, 0), AllocationProcessMode.DIRECT, new PoolBuilderDefaults(Expiration.never(), StormpotThreadFactory.INSTANCE, false, false, 0));
    static final Map<AllocationProcessMode, PoolBuilderPermissions> PERMISSIONS = Map.of(AllocationProcessMode.THREADED, new PoolBuilderPermissions(true, true, true, true, true), AllocationProcessMode.INLINE, new PoolBuilderPermissions(true, true, true, false, false), AllocationProcessMode.DIRECT, new PoolBuilderPermissions(false, true, false, false, false));
    private final AllocationProcess allocationProcess;
    private final PoolBuilderPermissions permissions;
    private Allocator<T> allocator;
    private int size = 10;
    private Expiration<? super T> expiration;
    private MetricsRecorder metricsRecorder;
    private ThreadFactory threadFactory;
    private boolean preciseLeakDetectionEnabled;
    private boolean backgroundExpirationEnabled;
    private int backgroundExpirationCheckDelay;

    PoolBuilder(AllocationProcess allocationProcess, Allocator<T> allocator) {
        Objects.requireNonNull(allocator, "The Allocator cannot be null.");
        Objects.requireNonNull(allocationProcess, "The AllocationProcess cannot be null.");
        this.allocator = allocator;
        this.allocationProcess = allocationProcess;
        this.permissions = PERMISSIONS.get((Object)allocationProcess.getMode());
        PoolBuilderDefaults defaults = DEFAULTS.get((Object)allocationProcess.getMode());
        this.expiration = defaults.expiration;
        this.threadFactory = defaults.threadFactory;
        this.preciseLeakDetectionEnabled = defaults.preciseLeakDetectionEnabled;
        this.backgroundExpirationEnabled = defaults.backgroundExpirationEnabled;
        this.backgroundExpirationCheckDelay = defaults.backgroundExpirationCheckDelay;
    }

    public synchronized PoolBuilder<T> setSize(int size) {
        this.checkPermission(this.permissions.setSize, "size");
        if (size < 0) {
            throw new IllegalArgumentException("Size must be at least 0, but was " + size + ".");
        }
        this.size = size;
        return this;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized <X extends Poolable> PoolBuilder<X> setAllocator(Allocator<X> allocator) {
        this.checkPermission(this.permissions.setAllocator, "allocator");
        Objects.requireNonNull(allocator, "The Allocator cannot be null.");
        this.allocator = allocator;
        return this;
    }

    public synchronized Allocator<T> getAllocator() {
        return this.allocator;
    }

    public synchronized Reallocator<T> getReallocator() {
        if (this.allocator instanceof Reallocator) {
            return (Reallocator)this.allocator;
        }
        return new ReallocatingAdaptor<T>(this.allocator);
    }

    public synchronized PoolBuilder<T> setExpiration(Expiration<? super T> expiration) {
        this.checkPermission(this.permissions.setExpiration, "expiration");
        Objects.requireNonNull(expiration, "Expiration cannot be null.");
        this.expiration = expiration;
        return this;
    }

    public synchronized Expiration<? super T> getExpiration() {
        return this.expiration;
    }

    public synchronized PoolBuilder<T> setMetricsRecorder(MetricsRecorder metricsRecorder) {
        this.metricsRecorder = metricsRecorder;
        return this;
    }

    public synchronized MetricsRecorder getMetricsRecorder() {
        return this.metricsRecorder;
    }

    public synchronized ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public synchronized PoolBuilder<T> setThreadFactory(ThreadFactory factory) {
        this.checkPermission(this.permissions.setThreadFactory, "thread factory");
        Objects.requireNonNull(factory, "ThreadFactory cannot be null.");
        this.threadFactory = factory;
        return this;
    }

    public synchronized boolean isPreciseLeakDetectionEnabled() {
        return this.preciseLeakDetectionEnabled;
    }

    public synchronized PoolBuilder<T> setPreciseLeakDetectionEnabled(boolean enabled) {
        this.preciseLeakDetectionEnabled = enabled;
        return this;
    }

    public synchronized boolean isBackgroundExpirationEnabled() {
        return this.backgroundExpirationEnabled;
    }

    public synchronized PoolBuilder<T> setBackgroundExpirationEnabled(boolean enabled) {
        this.checkPermission(this.permissions.setBackgroundExpiration, "background expiration enabled/disabled");
        this.backgroundExpirationEnabled = enabled;
        return this;
    }

    public synchronized int getBackgroundExpirationCheckDelay() {
        return this.backgroundExpirationCheckDelay;
    }

    public synchronized PoolBuilder<T> setBackgroundExpirationCheckDelay(int delay) {
        this.checkPermission(this.permissions.setBackgroundExpiration, "background expiration check delay");
        if (delay < 0) {
            throw new IllegalArgumentException("Background expiration check delay cannot be negative.");
        }
        this.backgroundExpirationCheckDelay = delay;
        return this;
    }

    public final synchronized PoolBuilder<T> clone() {
        try {
            return (PoolBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public synchronized Pool<T> build() {
        return new BlazePool(this, this.allocationProcess);
    }

    synchronized Reallocator<T> getAdaptedReallocator() {
        if (this.metricsRecorder == null) {
            if (this.allocator instanceof Reallocator) {
                return (Reallocator)this.allocator;
            }
            return new ReallocatingAdaptor<T>(this.allocator);
        }
        if (this.allocator instanceof Reallocator) {
            return new TimingReallocatorAdaptor((Reallocator)this.allocator, this.metricsRecorder);
        }
        return new TimingReallocatingAdaptor<T>(this.allocator, this.metricsRecorder);
    }

    private void checkPermission(boolean permission, String fieldDescription) {
        if (!permission) {
            String message = "The " + this.allocationProcess.getMode() + " allocation process does not support configuring the " + fieldDescription + ".";
            throw new IllegalStateException(message);
        }
    }
}

