/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import stormpot.PoolException;
import stormpot.Poolable;
import stormpot.Timeout;

public abstract class PoolTap<T extends Poolable> {
    private static final Timeout ZERO_TIMEOUT = new Timeout(Duration.ZERO);

    PoolTap() {
    }

    public abstract T claim(Timeout var1) throws PoolException, InterruptedException;

    public T tryClaim() throws PoolException {
        try {
            return this.claim(ZERO_TIMEOUT);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> Optional<R> apply(Timeout timeout, Function<T, R> function) throws InterruptedException {
        Objects.requireNonNull(function, "Function cannot be null.");
        T obj = this.claim(timeout);
        if (obj == null) {
            return Optional.empty();
        }
        try {
            Optional<R> optional = Optional.ofNullable(function.apply(obj));
            return optional;
        }
        finally {
            obj.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean supply(Timeout timeout, Consumer<T> consumer) throws InterruptedException {
        Objects.requireNonNull(consumer, "Consumer cannot be null.");
        T obj = this.claim(timeout);
        if (obj == null) {
            return false;
        }
        try {
            consumer.accept(obj);
            boolean bl = true;
            return bl;
        }
        finally {
            obj.release();
        }
    }
}

