/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.lang.ref.WeakReference;

final class PreciseLeakDetector {
    private static final int branchPower = Integer.getInteger("stormpot.PreciseLeakDetector.branchPower", 5);
    private static final int branchFactor = 1 << branchPower;
    private static final int branchMask = branchFactor - 1;
    private final Object[] probes = new Object[branchFactor];
    private int leakedObjectCount;

    PreciseLeakDetector() {
    }

    synchronized void register(Object obj) {
        int hash1 = System.identityHashCode(obj) & branchMask;
        Object current = this.probes[hash1];
        if (current == null) {
            this.probes[hash1] = new WeakRef(obj);
            return;
        }
        if (current instanceof WeakRef) {
            WeakRef currentRef = (WeakRef)current;
            if (this.chainShorterThan(4, current)) {
                WeakRef ref = new WeakRef(obj);
                ref.next = currentRef;
                this.probes[hash1] = ref;
            } else {
                WeakRef[] level2 = new WeakRef[branchFactor];
                WeakRef ref = new WeakRef(obj);
                ref.next = currentRef;
                this.assocLevel2(level2, ref);
                this.probes[hash1] = level2;
            }
            return;
        }
        WeakRef[] level2 = (WeakRef[])current;
        this.assocLevel2(level2, new WeakRef(obj));
    }

    private void assocLevel2(WeakRef[] level2, WeakRef chain) {
        while (chain != null) {
            WeakRef next = chain.next;
            Object obj = chain.get();
            if (obj != null) {
                int hash2 = System.identityHashCode(obj) >> branchPower & branchMask;
                chain.next = level2[hash2];
                level2[hash2] = chain;
            } else {
                ++this.leakedObjectCount;
            }
            chain = next;
        }
    }

    private boolean chainShorterThan(int length, Object weakRef) {
        WeakRef ref = (WeakRef)weakRef;
        while (ref != null) {
            if (length == 0) {
                return false;
            }
            --length;
            ref = ref.next;
        }
        return true;
    }

    synchronized void unregister(Object obj) {
        int hash0 = System.identityHashCode(obj);
        int hash1 = hash0 & branchMask;
        Object current = this.probes[hash1];
        if (current instanceof WeakRef) {
            WeakRef ref = (WeakRef)current;
            this.probes[hash1] = this.removeFromChain(ref, obj);
            return;
        }
        int hash2 = hash0 >> branchPower & branchMask;
        WeakRef[] level2 = (WeakRef[])current;
        level2[hash2] = this.removeFromChain(level2[hash2], obj);
    }

    private WeakRef removeFromChain(WeakRef chain, Object obj) {
        WeakRef newChain = null;
        while (chain != null) {
            WeakRef next = chain.next;
            Object current = chain.get();
            if (current == null) {
                ++this.leakedObjectCount;
            } else if (current == obj) {
                chain.clear();
            } else {
                chain.next = newChain;
                newChain = chain;
            }
            chain = next;
        }
        return newChain;
    }

    synchronized long countLeakedObjects() {
        for (int i = 0; i < this.probes.length; ++i) {
            Object current = this.probes[i];
            if (current instanceof WeakRef) {
                this.probes[i] = this.pruneChain((WeakRef)current);
                continue;
            }
            if (!(current instanceof WeakRef[])) continue;
            WeakRef[] level2 = (WeakRef[])current;
            for (int j = 0; j < level2.length; ++j) {
                level2[j] = this.pruneChain(level2[j]);
            }
        }
        return this.leakedObjectCount;
    }

    private WeakRef pruneChain(WeakRef chain) {
        WeakRef newChain = null;
        while (chain != null) {
            WeakRef next = chain.next;
            if (chain.get() == null) {
                ++this.leakedObjectCount;
            } else {
                chain.next = newChain;
                newChain = chain;
            }
            chain = next;
        }
        return newChain;
    }

    private static class WeakRef
    extends WeakReference<Object> {
        WeakRef next;

        WeakRef(Object referent) {
            super(referent);
        }
    }
}

