/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadFactory;
import stormpot.AllocationController;
import stormpot.BAllocThread;
import stormpot.BSlot;
import stormpot.Completion;
import stormpot.PoolBuilder;
import stormpot.Poolable;
import stormpot.RefillPile;

class ThreadedAllocationController<T extends Poolable>
extends AllocationController<T> {
    private final BAllocThread<T> allocator;
    private final Thread allocatorThread;

    ThreadedAllocationController(LinkedTransferQueue<BSlot<T>> live, RefillPile<T> disregardPile, RefillPile<T> newAllocations, PoolBuilder<T> builder, BSlot<T> poisonPill) {
        this.allocator = new BAllocThread<T>(live, disregardPile, newAllocations, builder, poisonPill);
        ThreadFactory factory = builder.getThreadFactory();
        this.allocatorThread = factory.newThread(this.allocator);
        this.allocatorThread.start();
    }

    @Override
    public Completion shutdown() {
        return this.allocator.shutdown(this.allocatorThread);
    }

    @Override
    public void offerDeadSlot(BSlot<T> slot) {
        this.allocator.offerDeadSlot(slot);
    }

    @Override
    public void setTargetSize(int size) {
        this.allocator.setTargetSize(size);
    }

    @Override
    public int getTargetSize() {
        return this.allocator.getTargetSize();
    }

    @Override
    public long getAllocationCount() {
        return this.allocator.getAllocationCount();
    }

    @Override
    public long getFailedAllocationCount() {
        return this.allocator.getFailedAllocationCount();
    }

    @Override
    public long countLeakedObjects() {
        return this.allocator.countLeakedObjects();
    }

    @Override
    public int allocatedSize() {
        return this.allocator.allocatedSize();
    }

    @Override
    public int inUse() {
        return this.allocator.inUse();
    }
}

