/*
 * Decompiled with CFR 0.152.
 */
package gratum.csv;

import gratum.csv.CSVReader;
import gratum.csv.HaltPipelineException;
import gratum.util.Utilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.BOMInputStream;

public class CSVFile {
    private File file;
    private Reader reader;
    private String separator;
    private PrintWriter writer;
    private String lastLine;
    private int rows = 0;
    private List<String> columnHeaders;
    private HashSet<String> rowHashes = new HashSet();
    private boolean allowDuplicateRows = true;

    public CSVFile(String filename, String separator) {
        this(new File(filename), separator);
    }

    public CSVFile(File file, String separator) {
        this.file = file;
        this.separator = separator;
    }

    public CSVFile(Reader reader, String separator) {
        this.reader = reader;
        this.separator = separator;
    }

    public CSVFile(PrintWriter out, String separator) {
        this.writer = out;
        this.separator = separator;
    }

    public void setAllowDuplicateRows(boolean allowDuplicateRows) {
        this.allowDuplicateRows = allowDuplicateRows;
    }

    public boolean getAllowDuplicateRows() {
        return this.allowDuplicateRows;
    }

    public int parse(CSVReader callback) throws IOException {
        if (this.file != null) {
            BOMInputStream bom = new BOMInputStream((InputStream)new FileInputStream(this.file));
            InputStreamReader reader = bom.hasBOM() ? new InputStreamReader((InputStream)bom, bom.getBOMCharsetName()) : new InputStreamReader((InputStream)bom, "UTF-8");
            return this.parse(reader, callback);
        }
        return this.parse(this.reader, callback);
    }

    protected int parse(Reader reader, CSVReader callback) throws IOException {
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        int lines = 1;
        if (this.columnHeaders == null) {
            try {
                this.columnHeaders = this.readNext(lineNumberReader);
                callback.processHeaders(this.columnHeaders);
                ++lines;
            }
            catch (Exception ex) {
                throw new IOException("Could not process header " + lines + ": " + this.lastLine, ex);
            }
        }
        try {
            List<String> row = null;
            while ((row = this.readNext(lineNumberReader)) != null) {
                boolean stop = callback.processRow(this.columnHeaders, row);
                if (stop) {
                    int n = lines;
                    return n;
                }
                ++lines;
            }
            int n = lines;
            return n;
        }
        catch (HaltPipelineException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Could not parse line " + lines + ": " + this.lastLine, ex);
        }
        catch (Exception ex) {
            throw new IOException("Could not process line " + lines + ": " + this.lastLine, ex);
        }
        finally {
            lineNumberReader.close();
            callback.afterProcessing();
        }
    }

    private List<String> readNext(LineNumberReader reader) throws IOException {
        do {
            this.lastLine = reader.readLine();
            if (this.lastLine != null) continue;
            return null;
        } while (this.lastLine.length() == 0);
        return this.parseColumns();
    }

    private List<String> parseColumns() {
        ArrayList<String> line = new ArrayList<String>(this.columnHeaders != null ? this.columnHeaders.size() : 10);
        int columnStart = 0;
        char sep = this.separator.charAt(0);
        boolean skipSeparator = false;
        boolean stripQuotes = false;
        for (int i = 0; i < this.lastLine.length(); ++i) {
            char currentChar = this.lastLine.charAt(i);
            if (currentChar == '\"') {
                if (skipSeparator && this.isEscaped(i)) {
                    ++i;
                    continue;
                }
                skipSeparator = !skipSeparator;
                stripQuotes = stripQuotes || i == columnStart;
                continue;
            }
            if (skipSeparator || sep != currentChar) continue;
            String content = stripQuotes ? this.lastLine.substring(columnStart + 1, i - 1) : this.lastLine.substring(columnStart, i);
            line.add(this.unescape(content));
            columnStart = i + 1;
            stripQuotes = false;
        }
        if (columnStart < this.lastLine.length()) {
            String content = stripQuotes ? this.lastLine.substring(columnStart + 1, this.lastLine.length() - 1) : this.lastLine.substring(columnStart);
            line.add(this.unescape(content));
        }
        return line;
    }

    private boolean isEscaped(int i) {
        return i + 1 < this.lastLine.length() && this.lastLine.charAt(i + 1) == '\"';
    }

    private String unescape(String input) {
        return input.replace("\\n", "\n").replace("\"\"", "\"");
    }

    public void write(Map row, String[] columnHeaders) throws IOException {
        if (this.columnHeaders == null) {
            this.columnHeaders = Arrays.asList(columnHeaders);
        }
        Object[] rowArray = new String[this.columnHeaders.size()];
        int i = 0;
        for (String columnHeader : this.columnHeaders) {
            rowArray[i++] = row.get(columnHeader) == null ? "" : row.get(columnHeader).toString();
        }
        this.write(rowArray);
    }

    public void write(Map row) throws IOException {
        if (this.columnHeaders == null) {
            this.columnHeaders = new ArrayList<String>(row.keySet().size());
            boolean i = false;
            for (Object headerKey : row.keySet()) {
                this.columnHeaders.add(headerKey.toString());
            }
        }
        if (this.rows == 0) {
            this.write(this.columnHeaders.toArray());
        }
        Object[] rowArray = new String[this.columnHeaders.size()];
        int i = 0;
        for (String columnHeader : this.columnHeaders) {
            if (row.get(columnHeader) == null) {
                rowArray[i++] = "";
                continue;
            }
            rowArray[i++] = row.get(columnHeader).toString();
        }
        this.write(rowArray);
    }

    public void write(Object ... row) throws IOException {
        boolean addRow = true;
        if (!this.allowDuplicateRows) {
            String rowString = "";
            for (Object rowValue : row) {
                rowString = rowString + "_" + rowValue.toString();
            }
            String rowHash = Utilities.MD5(rowString);
            if (!this.rowHashes.contains(rowHash)) {
                this.rowHashes.add(rowHash);
            } else {
                addRow = false;
            }
        }
        if (addRow) {
            if (this.writer == null) {
                this.writer = new PrintWriter(new FileWriter(this.file));
            }
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < row.length; ++i) {
                if (i > 0) {
                    buffer.append(this.separator);
                }
                if (row[i] == null) continue;
                buffer.append(this.escape(this.format(row[i])));
            }
            this.writer.println(buffer.toString());
            ++this.rows;
        }
    }

    private String format(Object o) {
        return o.toString();
    }

    private CharSequence escape(String source) {
        if (source.isEmpty()) {
            return source;
        }
        StringBuilder builder = new StringBuilder(source.length() + 2);
        builder.append('\"');
        int lastIndex = 0;
        block4: for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '\"': {
                    builder.append(source, lastIndex, i);
                    builder.append("\"\"");
                    lastIndex = i + 1;
                    continue block4;
                }
                case '\n': {
                    builder.append(source, lastIndex, i);
                    builder.append("\\n");
                    lastIndex = i + 1;
                }
            }
        }
        if (lastIndex < source.length()) {
            builder.append(source.subSequence(lastIndex, source.length()));
        }
        builder.append('\"');
        return builder.toString();
    }

    public void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void close() {
        this.flush();
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public int getRows() {
        return this.rows;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public List<String> getColumnHeaders() {
        return this.columnHeaders;
    }

    public void setColumnHeaders(List<String> columnHeaders) {
        this.columnHeaders = columnHeaders;
    }
}

