/*
 * Decompiled with CFR 0.152.
 */
package gratum.pgp;

import gratum.pgp.PgpObjectProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.io.Streams;

public class PgpContext {
    private PGPSecretKeyRingCollection secretKeys;
    private PGPPublicKeyRingCollection publicKeys;
    private Iterable<String> identities;
    private char[] passphrase;
    private boolean asciiArmour = true;
    private boolean checkIntegrity = true;
    private int compressedDataType = 1;
    private boolean overwrite = false;

    public PgpContext() {
        Provider provider = Security.getProvider("BC");
        if (provider == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public PgpContext addPublicKeys(PGPPublicKeyRingCollection keys) {
        this.publicKeys = keys;
        return this;
    }

    public PgpContext addSecretKeys(PGPSecretKeyRingCollection keys) {
        this.secretKeys = keys;
        return this;
    }

    public PgpContext addPublicKeys(File publicKeyRing) throws IOException, PGPException {
        try (ArmoredInputStream stream = new ArmoredInputStream((InputStream)new FileInputStream(publicKeyRing));){
            this.publicKeys = new PGPPublicKeyRingCollection((InputStream)stream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            PgpContext pgpContext = this;
            return pgpContext;
        }
    }

    public PgpContext addSecretKeys(File secretKeyRing) throws IOException, PGPException {
        try (ArmoredInputStream stream = new ArmoredInputStream((InputStream)new FileInputStream(secretKeyRing));){
            this.secretKeys = new PGPSecretKeyRingCollection((InputStream)stream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            PgpContext pgpContext = this;
            return pgpContext;
        }
    }

    public PgpContext identity(String identity, char[] passphrase) {
        this.identities = Collections.singleton(identity);
        this.passphrase = passphrase;
        return this;
    }

    public PgpContext identities(Iterable<String> identities) {
        this.identities = identities;
        return this;
    }

    public PgpContext checkIntegrity(boolean check) {
        this.checkIntegrity = check;
        return this;
    }

    public PgpContext asciiArmour(boolean asciiArmour) {
        this.asciiArmour = asciiArmour;
        return this;
    }

    public PgpContext compressData(int compressedDataType) {
        this.compressedDataType = compressedDataType;
        return this;
    }

    public PgpContext overwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void encrypt(String filename, Date modificationTime, InputStream stream, OutputStream out) throws IOException, PGPException {
        assert (this.secretKeys != null || this.publicKeys != null) : "You must provide either a secret key ring or public key ring using addPublicKeys() or addSecretKeys()";
        assert (this.identities != null) : "You must have at least 1 identity configured using addIdentities()";
        List<PGPPublicKey> keys = this.getPgpPublicKeys();
        try {
            if (this.asciiArmour) {
                out = new ArmoredOutputStream(out);
            }
            JcePGPDataEncryptorBuilder pgpBuilder = new JcePGPDataEncryptorBuilder(9).setWithIntegrityPacket(this.checkIntegrity).setSecureRandom(new SecureRandom()).setProvider("BC");
            PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)pgpBuilder);
            keys.forEach(key -> encryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(key).setProvider("BC")));
            try (OutputStream encryptedOut = encryptedDataGenerator.open(out, new byte[65536]);){
                PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(this.compressedDataType);
                try (OutputStream compressedOut = compressedDataGenerator.open(encryptedOut, new byte[65536]);){
                    PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
                    try (OutputStream pgpOut = lData.open(compressedOut, 'b', filename, modificationTime, new byte[65536]);){
                        IOUtils.copy((InputStream)stream, (OutputStream)pgpOut);
                    }
                }
            }
        }
        finally {
            out.close();
        }
    }

    private List<PGPPublicKey> getPgpPublicKeys() throws PGPException {
        ArrayList<PGPPublicKey> keys = new ArrayList<PGPPublicKey>();
        for (String identity : this.identities) {
            PGPPublicKey key = this.getPublicIdentity(identity);
            if (key != null) {
                keys.add(key);
                continue;
            }
            key = this.getSecretIdentity(identity);
            if (key != null) {
                keys.add(key);
                continue;
            }
            throw new IllegalArgumentException("No keys for identity: " + identity);
        }
        return keys;
    }

    private PGPPublicKey getPublicIdentity(String identity) throws PGPException {
        if (this.publicKeys == null) {
            return null;
        }
        Iterator rings = this.publicKeys.getKeyRings(identity, true, true);
        if (rings.hasNext()) {
            PGPPublicKeyRing ring = (PGPPublicKeyRing)rings.next();
            return this.getEncryptionKey((PGPKeyRing)ring);
        }
        return null;
    }

    private PGPPublicKey getSecretIdentity(String identity) throws PGPException {
        if (this.secretKeys == null) {
            return null;
        }
        Iterator rings = this.secretKeys.getKeyRings(identity, true, true);
        if (rings.hasNext()) {
            PGPSecretKeyRing ring = (PGPSecretKeyRing)rings.next();
            return this.getEncryptionKey((PGPKeyRing)ring);
        }
        return null;
    }

    private PGPPublicKey getEncryptionKey(PGPKeyRing ring) {
        Iterator i = ring.getPublicKeys();
        while (i.hasNext()) {
            PGPPublicKey key = (PGPPublicKey)i.next();
            if (!key.isEncryptionKey()) continue;
            return key;
        }
        throw new IllegalArgumentException("No encryption keys were found.");
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void decrypt(InputStream inputStream, OutputStream outputStream) throws IOException, PGPException {
        assert (this.secretKeys != null) : "You must provide a secret key ring using addSecretKeys()";
        assert (this.identities != null) : "You must provide an identity to decrypt using addIdentity()";
        new PgpObjectProcessor(this, this.passphrase).onData(pgpLiteralData -> {
            Streams.pipeAll((InputStream)pgpLiteralData.getInputStream(), (OutputStream)outputStream);
            outputStream.flush();
            return true;
        }).process(inputStream);
    }

    public PGPSecretKey getSecretKey(long keyID) throws PGPException {
        return this.secretKeys.getSecretKey(keyID);
    }
}

