/*
 * Decompiled with CFR 0.152.
 */
package gratum.pgp;

import gratum.pgp.ElGamalKeySize;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;

public class PgpKeyBuilder {
    private String name;
    private String email;
    private char[] passphrase;
    private Date expiration = new Date(System.currentTimeMillis() + TimeUnit.DAYS.convert(365L, TimeUnit.MILLISECONDS));
    private int dsaKeySize = 1024;
    private ElGamalKeySize elGamalKeySize = ElGamalKeySize.BIT_4096;

    public PgpKeyBuilder() {
        Provider provider = Security.getProvider("BC");
        if (provider == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static PgpKeyBuilder identity(String name, String email, char[] passphrase) {
        PgpKeyBuilder builder = new PgpKeyBuilder();
        builder.name = name;
        builder.email = email;
        builder.passphrase = passphrase;
        return builder;
    }

    public PgpKeyBuilder expires(Date expiration) {
        this.expiration = expiration;
        return this;
    }

    protected final KeyPair generateDsaKeyPair(int keySize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA", "BC");
        keyPairGenerator.initialize(keySize);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    protected final KeyPair generateElGamalKeyPair(ElGamalKeySize keySize) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        return this.generateElGamalKeyPair(keySize.getElGamalParameterSpec());
    }

    protected final KeyPair generateElGamalKeyPair(ElGamalParameterSpec paramSpecs) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ELGAMAL", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)paramSpecs);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public PGPSecretKeyRing build() throws PGPException, NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPair dsa = this.generateDsaKeyPair(this.dsaKeySize);
        KeyPair elGamal = this.generateElGamalKeyPair(this.elGamalKeySize);
        PGPKeyRingGenerator generator = this.createKeyGenerator(this.name, this.email, this.passphrase, dsa, elGamal);
        return generator.generateSecretKeyRing();
    }

    public PGPKeyRingGenerator createKeyGenerator(String name, String email, char[] passphrase, KeyPair dsaKeyPair, KeyPair elGamalKeyPair) throws PGPException {
        Date now = new Date();
        JcaPGPKeyPair dsaPgpKeyPair = new JcaPGPKeyPair(17, dsaKeyPair, now);
        JcaPGPKeyPair elGamalPgpKeyPair = new JcaPGPKeyPair(16, elGamalKeyPair, now);
        PGPDigestCalculator sha1Calc = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
        PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator();
        long seconds = this.expiration != null ? TimeUnit.MILLISECONDS.toSeconds(this.expiration.getTime() - now.getTime()) : TimeUnit.DAYS.toSeconds(365L);
        subpacketGenerator.setKeyExpirationTime(false, seconds);
        PGPSignatureSubpacketVector subpacketVector = subpacketGenerator.generate();
        PGPKeyRingGenerator keyRingGen = new PGPKeyRingGenerator(19, (PGPKeyPair)dsaPgpKeyPair, name + " <" + email + ">", sha1Calc, subpacketVector, null, (PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(dsaPgpKeyPair.getPublicKey().getAlgorithm(), 2), new JcePBESecretKeyEncryptorBuilder(9, sha1Calc).setProvider("BC").build(passphrase));
        keyRingGen.addSubKey((PGPKeyPair)elGamalPgpKeyPair);
        return keyRingGen;
    }
}

